/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.FileSystem;
import de.waldheinz.fs.FileSystemFactory;
import de.waldheinz.fs.FsDirectory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.util.FileDisk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FatFileIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class FatArchiveContainerIdentifier
extends ArchiveContentIdentifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public FatArchiveContainerIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, archiveConfiguration);
    }

    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = this.makeContainerURI("fat", request.getFileName());
        this.setSlash1("");
        if (request.getClass().isAssignableFrom(FileSystemIdentificationRequest.class)) {
            FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)request;
            try {
                FileDisk fileDisk = new FileDisk(req.getFile().toFile(), true);
                FileSystem fatSystem = FileSystemFactory.create((BlockDevice)fileDisk, (boolean)true);
                FsDirectory root = fatSystem.getRoot();
                for (FsDirectoryEntry entry : root) {
                    this.processEntry(entry, uri, newPath);
                }
            }
            catch (IOException e) {
                throw new CommandExecutionException("IO error in FatFileSystem", e);
            }
        } else {
            this.log.info("Identification request for Fat image ignored due to limited support.");
        }
    }

    private void processEntry(FsDirectoryEntry entry, URI uri, String newPath) throws CommandExecutionException, IOException {
        String name = entry.getName();
        if (!entry.isDirectory()) {
            RequestMetaData metaData = new RequestMetaData(Long.valueOf(entry.getFile().getLength()), Long.valueOf(2L), name);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            FatFileIdentificationRequest req = new FatFileIdentificationRequest(metaData, identifier, this.getTmpDir());
            ByteBuffer buffer = ByteBuffer.allocate((int)entry.getFile().getLength());
            entry.getFile().read(0L, buffer);
            buffer.flip();
            this.expandContainer((IdentificationRequest)req, new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit()), newPath);
        } else {
            this.log.trace("processing directory : " + entry.getName());
        }
    }
}

