/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ISOImageIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class IsoArchiveContainerIdentifier
extends ArchiveContentIdentifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public IsoArchiveContainerIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, archiveConfiguration);
    }

    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = this.makeContainerURI("iso", request.getFileName());
        this.setSlash1("");
        if (request.getClass().isAssignableFrom(FileSystemIdentificationRequest.class)) {
            FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)request;
            try (Iso9660FileSystem fileSystem = new Iso9660FileSystem(req.getFile().toFile(), true);){
                for (Iso9660FileEntry entry : fileSystem) {
                    this.processEntry(entry, uri, fileSystem, newPath);
                }
            }
            catch (IOException | RuntimeException e) {
                System.err.println(e + " (" + newPath + ")");
            }
        } else {
            this.log.info("Identification request for ISO image ignored due to limited support.");
        }
    }

    private void processEntry(Iso9660FileEntry entry, URI uri, Iso9660FileSystem fileSystem, String newPath) throws CommandExecutionException {
        String name = entry.getPath();
        if (!entry.isDirectory()) {
            RequestMetaData metaData = new RequestMetaData(Long.valueOf(entry.getSize()), Long.valueOf(2L), name);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            ISOImageIdentificationRequest req = new ISOImageIdentificationRequest(metaData, identifier, this.getTmpDir());
            this.expandContainer((IdentificationRequest)req, fileSystem.getInputStream(entry), newPath);
        } else {
            this.log.trace("processing directory : " + entry.getPath());
        }
    }
}

