/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import com.github.junrar.Archive;
import com.github.junrar.VolumeManager;
import com.github.junrar.exception.RarException;
import com.github.junrar.impl.FileVolumeManager;
import com.github.junrar.rarfile.FileHeader;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RarIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class RarArchiveContainerIdentifier
extends ArchiveContentIdentifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public RarArchiveContainerIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, archiveConfiguration);
    }

    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = this.makeContainerURI("rar", request.getFileName());
        this.setSlash1("");
        if (request.getClass().isAssignableFrom(FileSystemIdentificationRequest.class)) {
            FileSystemIdentificationRequest req = (FileSystemIdentificationRequest)request;
            FileVolumeManager fileVolumeManager = new FileVolumeManager(req.getFile().toFile());
            try (Archive archive = new Archive((VolumeManager)fileVolumeManager);){
                if (archive.isEncrypted()) {
                    this.log.info("encrypted rar");
                } else {
                    for (FileHeader entry : archive.getFileHeaders()) {
                        this.processEntry(entry, archive, uri, newPath);
                    }
                }
            }
            catch (RarException | IOException e) {
                System.err.println(e + " (" + newPath + ")");
            }
        } else {
            this.log.info("Identification request for RAR archive ignored due to limited support.");
        }
    }

    private void processEntry(FileHeader entry, Archive archive, URI uri, String newPath) throws CommandExecutionException, IOException, RarException {
        String name = entry.getFileNameString();
        if (!entry.isDirectory()) {
            RequestMetaData metaData = new RequestMetaData(Long.valueOf(entry.getUnpSize()), Long.valueOf(2L), name);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            RarIdentificationRequest req = new RarIdentificationRequest(metaData, identifier, this.getTmpDir());
            this.expandContainer((IdentificationRequest)req, archive.getInputStream(entry), newPath);
        } else {
            this.log.trace("processing directory : " + entry.getFileNameString());
        }
    }
}

