/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.xbill.DNS.Message;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;
import uk.nominet.dnsjnio.NonblockingResolver;
import uk.nominet.dnsjnio.Response;
import uk.nominet.dnsjnio.ResponseQueue;

public class ExtendedNonblockingResolver
implements Resolver {
    private static Random random = new Random();
    static Integer threadCount = new Integer(0);
    static final Object threadCountLock = new Object();
    private static final int quantum = 5;
    private List resolvers = new ArrayList();
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;
    static int idCount = 0;
    private ResolutionThread resolutionThread;

    public void setPort(int n) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setPort(n);
        }
    }

    public void setTCP(boolean bl) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTCP(bl);
        }
    }

    public void setIgnoreTruncation(boolean bl) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setIgnoreTruncation(bl);
        }
    }

    public void setEDNS(int n) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(n);
        }
    }

    public void setEDNS(int n, int n2, int n3, List list) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(n, n2, n3, list);
        }
    }

    public void setTSIGKey(TSIG tSIG) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(tSIG);
        }
    }

    public void setTimeout(int n, int n2) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTimeout(n, n2);
        }
    }

    public void setTimeout(int n) {
        this.setTimeout(n, 0);
    }

    public static ExtendedNonblockingResolver newInstance() throws UnknownHostException {
        ExtendedNonblockingResolver extendedNonblockingResolver = new ExtendedNonblockingResolver();
        return extendedNonblockingResolver;
    }

    private ExtendedNonblockingResolver() throws UnknownHostException {
        String[] stringArray = ResolverConfig.getCurrentConfig().servers();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                NonblockingResolver nonblockingResolver = new NonblockingResolver(stringArray[i]);
                nonblockingResolver.setTimeout(5);
                this.resolvers.add(nonblockingResolver);
            }
        } else {
            this.resolvers.add(new NonblockingResolver());
        }
        this.startResolutionThread();
    }

    private void startResolutionThread() {
        this.resolutionThread = new ResolutionThread(this);
        this.resolutionThread.start();
    }

    public static ExtendedNonblockingResolver newInstance(NonblockingResolver[] nonblockingResolverArray) throws UnknownHostException {
        ExtendedNonblockingResolver extendedNonblockingResolver = new ExtendedNonblockingResolver(nonblockingResolverArray);
        return extendedNonblockingResolver;
    }

    private ExtendedNonblockingResolver(NonblockingResolver[] nonblockingResolverArray) throws UnknownHostException {
        for (int i = 0; i < nonblockingResolverArray.length; ++i) {
            this.resolvers.add(nonblockingResolverArray[i]);
        }
        this.startResolutionThread();
    }

    public Message send(Message message) throws IOException {
        ResponseQueue responseQueue = new ResponseQueue();
        this.sendAsync(message, responseQueue);
        Response response = responseQueue.getItem();
        if (response.isException()) {
            throw new IOException();
        }
        return response.getMessage();
    }

    public Object sendAsync(Message message, ResponseQueue responseQueue) {
        Integer n = new Integer(idCount++);
        this.sendAsync(message, n, responseQueue);
        return n;
    }

    public void sendAsync(Message message, Object object, ResponseQueue responseQueue) {
        this.resolutionThread.startNewRequest(message, object, responseQueue);
    }

    public Object sendAsync(Message message, ResolverListener resolverListener) {
        throw new RuntimeException("Listener callback not implemented - use ResponseQueue instead!");
    }

    public NonblockingResolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (NonblockingResolver)this.resolvers.get(n);
        }
        return null;
    }

    public NonblockingResolver[] getResolvers() {
        return this.resolvers.toArray(new NonblockingResolver[this.resolvers.size()]);
    }

    public void addResolver(NonblockingResolver nonblockingResolver) {
        this.resolvers.add(nonblockingResolver);
    }

    public void deleteResolver(NonblockingResolver nonblockingResolver) {
        this.resolvers.remove(nonblockingResolver);
    }

    public void setLoadBalance(boolean bl) {
        this.loadBalance = bl;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    private class ResolutionThread
    extends Thread {
        NonblockingResolver[] resolvers;
        ExtendedNonblockingResolver eres;
        private Map clientRequests = new HashMap();
        ResponseQueue queryQueue = new ResponseQueue();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolutionThread(ExtendedNonblockingResolver extendedNonblockingResolver2) {
            int n = 0;
            Object object = threadCountLock;
            synchronized (object) {
                n = threadCount;
                threadCount = new Integer(threadCount + 1);
            }
            this.setName("EnbrResolutionThread-" + n);
            object = extendedNonblockingResolver2.resolvers;
            this.resolvers = object.toArray(new NonblockingResolver[object.size()]);
            if (extendedNonblockingResolver2.loadBalance) {
                int n2 = this.resolvers.length;
                int n3 = extendedNonblockingResolver2.lbStart++ % n2;
                if (extendedNonblockingResolver2.lbStart > n2) {
                    extendedNonblockingResolver2.lbStart %= n2;
                }
                if (n3 > 0) {
                    NonblockingResolver[] nonblockingResolverArray = new NonblockingResolver[n2];
                    for (int i = 0; i < n2; ++i) {
                        int n4 = (i + n3) % n2;
                        nonblockingResolverArray[i] = this.resolvers[n4];
                    }
                    this.resolvers = nonblockingResolverArray;
                }
            }
        }

        private void startNewRequest(Message message, Object object, ResponseQueue responseQueue) {
            QueryRequest queryRequest = new QueryRequest(responseQueue, object, message);
            this.clientRequests.put(queryRequest.responseId, queryRequest);
            this.sendQueryToNextResolver(queryRequest);
        }

        private void processResponse(Response response, QueryRequest queryRequest) {
            if (this.clientRequests.containsKey(queryRequest.responseId)) {
                this.clientRequests.remove(queryRequest.responseId);
                response.setId(queryRequest.responseId);
                response.setException(false);
                queryRequest.responseQueue.insert(response);
            }
        }

        public void run() {
            while (true) {
                Response response = this.queryQueue.getItem();
                QueryRequest queryRequest = ((QueryId)response.getId()).request;
                --queryRequest.outstanding;
                if (response.isException()) {
                    if (response.getException() instanceof InterruptedIOException) {
                        this.dealWithTimeout(response, queryRequest);
                    }
                    if (queryRequest.outstanding == 0) {
                        this.sendExceptionToClient(queryRequest);
                        continue;
                    }
                } else {
                    this.processResponse(response, queryRequest);
                    continue;
                }
                if (((QueryId)response.getId()).resolver == queryRequest.currentResolver) {
                    this.queryNextResolver(queryRequest);
                }
                if (queryRequest.outstanding != 0) continue;
                this.sendExceptionToClient(queryRequest);
            }
        }

        private void dealWithTimeout(Response response, QueryRequest queryRequest) {
            NonblockingResolver nonblockingResolver = ((QueryId)response.getId()).resolver;
            int n = (Integer)queryRequest.sent.get(nonblockingResolver) - 1;
            if (n < ExtendedNonblockingResolver.this.retries) {
                QueryId queryId = new QueryId(queryRequest, nonblockingResolver);
                Message message = (Message)queryRequest.query.clone();
                message.getHeader().setID(random.nextInt(65535));
                int n2 = nonblockingResolver.getTimeoutMillis();
                int n3 = n2 << n;
                nonblockingResolver.sendAsync(message, queryId, n3, false, this.queryQueue);
                ++queryRequest.outstanding;
                Integer n4 = (Integer)queryRequest.sent.get(nonblockingResolver);
                n4 = new Integer(n4 + 1);
                queryRequest.sent.remove(nonblockingResolver);
                queryRequest.sent.put(nonblockingResolver, n4);
            }
        }

        private void queryNextResolver(QueryRequest queryRequest) {
            if (queryRequest.currentIndex < this.resolvers.length) {
                this.sendQueryToNextResolver(queryRequest);
            }
        }

        private void sendQueryToNextResolver(QueryRequest queryRequest) {
            queryRequest.currentResolver = this.resolvers[queryRequest.currentIndex++];
            QueryId queryId = new QueryId(queryRequest, queryRequest.currentResolver);
            Message message = (Message)queryRequest.query.clone();
            message.getHeader().setID(random.nextInt(65535));
            queryRequest.currentResolver.sendAsync(message, (Object)queryId, this.queryQueue);
            queryRequest.sent.put(queryRequest.currentResolver, new Integer(1));
            ++queryRequest.outstanding;
        }

        private void sendExceptionToClient(QueryRequest queryRequest) {
            this.clientRequests.remove(queryRequest.responseId);
            Response response = new Response();
            response.setException(new InterruptedIOException());
            response.setException(true);
            response.setId(queryRequest.responseId);
            queryRequest.responseQueue.insert(response);
        }

        private class QueryId {
            protected QueryRequest request;
            protected NonblockingResolver resolver;

            public QueryId(QueryRequest queryRequest, NonblockingResolver nonblockingResolver) {
                this.request = queryRequest;
                this.resolver = nonblockingResolver;
            }
        }
    }

    private class QueryRequest {
        protected ResponseQueue responseQueue;
        protected Object responseId;
        protected Message query;
        protected HashMap sent = new HashMap();
        protected int outstanding = 0;
        protected int currentIndex = 0;
        protected NonblockingResolver currentResolver = null;

        public QueryRequest(ResponseQueue responseQueue, Object object, Message message) {
            this.responseQueue = responseQueue;
            this.responseId = object;
            this.query = message;
        }
    }
}

