/*
 * Decompiled with CFR 0.152.
 */
package uk.nominet.dnsjnio;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;
import uk.nominet.dnsjnio.AbstractTransaction;
import uk.nominet.dnsjnio.Connection;
import uk.nominet.dnsjnio.NonblockingResolver;
import uk.nominet.dnsjnio.QueryData;
import uk.nominet.dnsjnio.ResponseQueue;
import uk.nominet.dnsjnio.TCPConnection;
import uk.nominet.dnsjnio.Timer;
import uk.nominet.dnsjnio.UDPConnection;

public class Transaction
extends AbstractTransaction {
    Connection connection;
    Message query;
    Object id;
    boolean responded = false;
    TSIG tsig;
    boolean tcp;
    boolean ignoreTruncation;
    protected InetSocketAddress remoteAddr;
    protected InetSocketAddress localAddr;
    private long endTime;
    private ResponseQueue responseQueue;
    private ResolverListener listener = null;
    protected int udpSize;
    private boolean answered = false;
    private final Object lock = new Object();

    public Transaction(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, TSIG tSIG, boolean bl, boolean bl2) {
        this.tcp = bl;
        this.ignoreTruncation = bl2;
        this.tsig = tSIG;
        this.remoteAddr = inetSocketAddress;
        this.localAddr = inetSocketAddress2;
    }

    public void sendQuery(Message message, Object object, ResponseQueue responseQueue, long l) {
        this.responseQueue = responseQueue;
        this.id = object;
        this.query = message;
        this.endTime = l;
        this.startTimer();
        this.startConnect();
    }

    public void sendQuery(Message message, Object object, ResolverListener resolverListener, long l) {
        this.listener = resolverListener;
        this.id = object;
        this.query = message;
        this.endTime = l;
        this.startTimer();
        this.startConnect();
    }

    private void startTimer() {
        Timer.addTimeout(this.endTime, this);
    }

    protected void startConnect() {
        this.connection = this.tcp ? new TCPConnection(this) : new UDPConnection(this, this.udpSize);
        this.connection.connect(this.remoteAddr, this.localAddr);
    }

    protected boolean disconnect(QueryData queryData) {
        return this.disconnect(this.connection);
    }

    public void readyToSend(Connection connection) {
        Transaction.sendQuery(this.connection, this.query);
    }

    public void dataAvailable(byte[] byArray, Connection connection) {
        try {
            this.disconnect(connection);
            Message message = NonblockingResolver.parseMessage(byArray);
            NonblockingResolver.verifyTSIG(this.query, message, byArray, this.tsig);
            if (!this.tcp && !this.ignoreTruncation && message.getHeader().getFlag(6)) {
                this.tcp = true;
                this.startConnect();
                return;
            }
            if (this.query.getHeader().getID() != message.getHeader().getID()) {
                return;
            }
            this.returnResponse(message);
        }
        catch (IOException iOException) {
            this.returnException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnResponse(Message message) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.answered) {
                this.answered = true;
                bl = true;
            }
        }
        if (bl) {
            this.cancelTimer();
            Transaction.returnResponse(this.listener, this.responseQueue, message, this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnException(Exception exception, QueryData queryData) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.answered) {
                this.answered = true;
                bl = true;
            }
        }
        if (bl) {
            this.cancelTimer();
            this.returnException(this.listener, this.responseQueue, exception, this.id);
        }
    }

    private void cancelTimer() {
        Timer.cancelTimeout(this);
        this.responded = true;
    }

    public void setUdpSize(int n) {
        this.udpSize = n;
    }
}

