/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json;

import java.util.function.Supplier;
import uk.org.webcompere.modelassert.json.impl.MemoizedSupplier;

public class Result {
    private MemoizedSupplier<String> conditionSupplier;
    private String was;
    private boolean isPassed;

    public Result(String condition, String was, boolean isPassed) {
        this.conditionSupplier = MemoizedSupplier.of(() -> condition);
        this.was = was;
        this.isPassed = isPassed;
    }

    public Result(Supplier<String> conditionSupplier, String was, boolean isPassed) {
        this.conditionSupplier = MemoizedSupplier.of(conditionSupplier);
        this.was = was;
        this.isPassed = isPassed;
    }

    public String getCondition() {
        return this.conditionSupplier.get();
    }

    public Result withPreCondition(String condition) {
        MemoizedSupplier<String> previousSupplier = this.conditionSupplier;
        this.conditionSupplier = MemoizedSupplier.of(() -> condition + " " + (String)previousSupplier.get());
        return this;
    }

    public Result withNewDescription(String condition) {
        this.conditionSupplier = MemoizedSupplier.of(() -> condition);
        return this;
    }

    public String getWas() {
        return this.was;
    }

    public boolean isPassed() {
        return this.isPassed;
    }

    public Result invert() {
        this.isPassed = !this.isPassed;
        return this;
    }
}

