/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;
import uk.org.webcompere.modelassert.json.condition.ConditionList;
import uk.org.webcompere.modelassert.json.condition.HasValueWithLooseType;
import uk.org.webcompere.modelassert.json.condition.array.LooseComparison;

public class ArrayContains
implements Condition {
    private String description;
    private List<Condition> arrayElementConditions;
    private boolean requireStrict;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ArrayContains(String description, List<Condition> arrayElementConditions, boolean requireStrict) {
        this.description = description;
        this.arrayElementConditions = arrayElementConditions;
        this.requireStrict = requireStrict;
    }

    public static ArrayContains containsValues(Object first, Object ... rest) {
        Object[] remainder = ArrayContains.correctRestForNulls(rest);
        return new ArrayContains(ArrayContains.describe(first, remainder), ArrayContains.toConditions(first, remainder), false);
    }

    public static ArrayContains containsValues(ConditionList conditions) {
        if (conditions == null) {
            return ArrayContains.containsValues(null, new Object[0]);
        }
        return new ArrayContains(ArrayContains.describe(conditions), conditions.getConditionList(), false);
    }

    public static ArrayContains containsValuesExactly(Object first, Object ... rest) {
        Object[] remainder = ArrayContains.correctRestForNulls(rest);
        return new ArrayContains(ArrayContains.describe(first, remainder), ArrayContains.toConditions(first, remainder), true);
    }

    public static ArrayContains containsValuesExactly(ConditionList conditions) {
        return new ArrayContains(ArrayContains.describe(conditions), conditions.getConditionList(), true);
    }

    private static Object[] correctRestForNulls(Object[] rest) {
        if (rest != null) {
            return rest;
        }
        return new Object[]{null};
    }

    @Override
    public Result test(JsonNode json) {
        if (!json.isArray() || !(json instanceof ArrayNode)) {
            return new Result(this.describe(), json.getNodeType().toString(), false);
        }
        ArrayNode arrayNode = (ArrayNode)json;
        if (this.requireStrict) {
            return this.strictComparison(arrayNode);
        }
        return this.looseComparison(arrayNode);
    }

    private Result looseComparison(ArrayNode arrayNode) {
        return LooseComparison.fromConditions(this.arrayElementConditions, () -> this.description).looseComparison(arrayNode);
    }

    private Result strictComparison(ArrayNode arrayNode) {
        if (arrayNode.size() != this.arrayElementConditions.size()) {
            return new Result(this.describe(), "different number of elements: found " + arrayNode.size() + " rather than expected " + this.arrayElementConditions.size(), false);
        }
        Result[] results = new Result[this.arrayElementConditions.size()];
        for (int i = 0; i < this.arrayElementConditions.size(); ++i) {
            results[i] = this.arrayElementConditions.get(i).test(arrayNode.get(i));
        }
        if (Arrays.stream(results).allMatch(Result::isPassed)) {
            return new Result(this.describe(), "all matched", true);
        }
        return new Result(this.describe(), this.explainFailures(results), false);
    }

    private String explainFailures(Result[] results) {
        return IntStream.range(0, results.length).filter(index -> !results[index].isPassed()).mapToObj(index -> "Index " + index + " expected " + results[index].getCondition() + " but was " + results[index].getWas()).collect(Collectors.joining("\n"));
    }

    @Override
    public String describe() {
        return this.description + (this.requireStrict ? " in exact order" : "");
    }

    private static String describe(Object first, Object ... rest) {
        return "Array with values " + Stream.concat(Stream.of(first), Arrays.stream(rest)).map(Objects::toString).collect(Collectors.toList());
    }

    private static String describe(ConditionList conditionList) {
        return "Array where:\n" + IntStream.range(0, conditionList.getConditionList().size()).mapToObj(idx -> "Index " + idx + ": " + conditionList.getConditionList().get(idx).describe()).collect(Collectors.joining("\n"));
    }

    private static List<Condition> toConditions(Object first, Object ... rest) {
        return Stream.concat(Stream.of(first), Arrays.stream(rest)).map(HasValueWithLooseType::new).collect(Collectors.toList());
    }
}

