/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.function.Function;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.Result;

public class HasValue<V>
implements Condition {
    private Function<JsonNode, V> valueExtractor;
    private V expected;

    public HasValue(Function<JsonNode, V> valueExtractor, V expected) {
        this.valueExtractor = valueExtractor;
        this.expected = expected;
    }

    @Override
    public Result test(JsonNode json) {
        V extracted = this.valueExtractor.apply(json);
        return new Result(this.describe(), extracted.toString(), Objects.equals(this.expected, extracted));
    }

    @Override
    public String describe() {
        return "equal to " + this.expected.toString();
    }
}

