/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.modelassert.json.condition.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import uk.org.webcompere.modelassert.json.Condition;
import uk.org.webcompere.modelassert.json.JsonProvider;
import uk.org.webcompere.modelassert.json.Result;
import uk.org.webcompere.modelassert.json.condition.array.ArrayElementCondition;
import uk.org.webcompere.modelassert.json.condition.array.LooseComparison;
import uk.org.webcompere.modelassert.json.condition.tree.ArrayComparisonElementCondition;
import uk.org.webcompere.modelassert.json.condition.tree.Location;
import uk.org.webcompere.modelassert.json.condition.tree.PathRule;
import uk.org.webcompere.modelassert.json.condition.tree.TreeRule;

public class TreeComparisonCondition
implements Condition {
    private JsonNode expected;
    private LinkedList<PathRule> rules = new LinkedList();

    private TreeComparisonCondition(JsonNode expected) {
        this.expected = expected;
    }

    public static <T> TreeComparisonCondition isEqualTo(T json, JsonProvider<T> provider) {
        return new TreeComparisonCondition(provider.jsonFrom(json));
    }

    public static TreeComparisonCondition isEqualTo(JsonNode tree) {
        return new TreeComparisonCondition(tree);
    }

    public TreeComparisonCondition withRules(List<PathRule> rules) {
        this.rules.addAll(rules);
        return this;
    }

    @Override
    public Result test(JsonNode json) {
        ArrayList<String> failures = new ArrayList<String>();
        Location root = new Location();
        this.compareTrees(json, this.expected, root, failures);
        if (!failures.isEmpty()) {
            return new Result(this.describe(), String.join((CharSequence)"\n", failures), false);
        }
        return new Result(this.describe(), "equal", true);
    }

    void compareTrees(JsonNode actual, JsonNode expected, Location pathToHere, List<String> failures) {
        Optional<PathRule> alternativeCondition = this.findRule(pathToHere, TreeRule.CONDITION);
        if (alternativeCondition.isPresent()) {
            Result result = alternativeCondition.get().getRuleCondition().test(actual);
            if (!result.isPassed()) {
                failures.add(pathToHere.toString() + ": expected " + result.getCondition() + " but was " + result.getWas());
            }
            return;
        }
        if (actual.getNodeType() != expected.getNodeType()) {
            failures.add(pathToHere.toString() + " different types: expected " + expected.getNodeType() + ", actual " + actual.getNodeType());
            return;
        }
        switch (actual.getNodeType()) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case STRING: {
                if (actual.equals((Object)expected)) break;
                failures.add(pathToHere.toString() + " value is different: expected " + expected + ", actual " + actual);
                break;
            }
            case ARRAY: {
                this.compareArrays((ArrayNode)actual, (ArrayNode)expected, pathToHere, failures);
                break;
            }
            case OBJECT: {
                this.compareObjects((ObjectNode)actual, (ObjectNode)expected, pathToHere, failures);
                break;
            }
            default: {
                failures.add("Unexpected node type: " + actual.getNodeType());
            }
        }
    }

    private void compareObjects(ObjectNode actual, ObjectNode expected, Location pathToHere, List<String> failures) {
        Set<String> actualKeys = TreeComparisonCondition.toSet(actual.fieldNames());
        Set<String> expectedKeys = TreeComparisonCondition.toSet(expected.fieldNames());
        HashSet<String> missingKeys = new HashSet<String>(expectedKeys);
        missingKeys.removeAll(actualKeys);
        HashSet<String> extraKeys = new HashSet<String>(actualKeys);
        extraKeys.removeAll(expectedKeys);
        boolean usingObjectContains = this.findRule(pathToHere, TreeRule.OBJECT_CONTAINS).isPresent();
        if (!usingObjectContains) {
            this.reportKeys("unexpected", actual, pathToHere, failures, extraKeys);
        }
        this.reportKeys("missing", actual, pathToHere, failures, missingKeys);
        LinkedHashSet<String> actualKeysWithoutExtras = new LinkedHashSet<String>(actualKeys);
        actualKeysWithoutExtras.removeAll(extraKeys);
        LinkedHashSet<String> expectedKeysFoundInActual = new LinkedHashSet<String>(expectedKeys);
        expectedKeysFoundInActual.retainAll(actualKeys);
        if (!usingObjectContains && this.keysShouldBeInOrder(pathToHere)) {
            this.checkKeyOrder(pathToHere, failures, actualKeysWithoutExtras, expectedKeysFoundInActual);
        }
        for (String key : actualKeysWithoutExtras) {
            this.compareTrees(actual.get(key), expected.get(key), pathToHere.child(key), failures);
        }
    }

    private boolean keysShouldBeInOrder(Location pathToHere) {
        return this.findRule(pathToHere, TreeRule.REQUIRE_KEY_ORDER).isPresent() || !this.findRule(pathToHere, TreeRule.IGNORE_KEY_ORDER).isPresent();
    }

    private void reportKeys(String name, ObjectNode actual, Location pathToHere, List<String> failures, Set<String> keys) {
        List filtered = keys.stream().filter(key -> !this.isKeyAllowedByRules(actual, pathToHere, (String)key)).collect(Collectors.toList());
        if (!filtered.isEmpty()) {
            failures.add(pathToHere.toString() + ": " + name + " keys " + filtered);
        }
    }

    private boolean isKeyAllowedByRules(ObjectNode actual, Location pathToHere, String key) {
        return this.findRule(pathToHere.child(key), TreeRule.CONDITION).map(rule -> rule.getRuleCondition().test(actual.get(key)).isPassed()).orElse(false);
    }

    private Optional<PathRule> findRule(Location pathToHere, TreeRule ruleToFind) {
        return this.rulesInPriorityOrder().filter(rule -> rule.matches(pathToHere) && rule.getRule().equals((Object)ruleToFind)).findFirst();
    }

    private Stream<PathRule> rulesInPriorityOrder() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.rules.descendingIterator(), 16), false);
    }

    private void checkKeyOrder(Location pathToHere, List<String> failures, Set<String> actualKeysWithoutExtras, Set<String> expectedKeysFoundInActual) {
        if (!new LinkedList<String>(actualKeysWithoutExtras).equals(new LinkedList<String>(expectedKeysFoundInActual))) {
            failures.add(pathToHere.toString() + ": keys in the wrong order - expected " + expectedKeysFoundInActual + ", found " + actualKeysWithoutExtras);
        }
    }

    private void compareArrays(ArrayNode actual, ArrayNode expected, Location pathToHere, List<String> failures) {
        boolean usingArrayContains = this.findRule(pathToHere, TreeRule.ARRAY_CONTAINS).isPresent();
        if (!usingArrayContains && actual.size() != expected.size()) {
            failures.add(pathToHere.toString() + ": arrays have different size, expected: " + expected.size() + " actual: " + actual.size());
        }
        if (!this.findRule(pathToHere, TreeRule.IGNORE_ARRAY_ORDER).isPresent() && !usingArrayContains) {
            this.performExactArrayComparison(actual, expected, pathToHere, failures);
        } else {
            this.performLooseArrayComparison(actual, expected, pathToHere, failures);
        }
    }

    private void performLooseArrayComparison(ArrayNode actual, ArrayNode expected, Location pathToHere, List<String> failures) {
        LinkedList<ArrayElementCondition> expectedConditions = new LinkedList<ArrayElementCondition>();
        for (int i = 0; i < expected.size(); ++i) {
            expectedConditions.add(new ArrayComparisonElementCondition(expected.get(i), i, pathToHere, this));
        }
        Result result = new LooseComparison(expectedConditions, () -> "Matches array at " + pathToHere.toString()).looseComparison(actual);
        if (!result.isPassed()) {
            failures.add(result.getCondition() + " " + result.getWas());
        }
    }

    private void performExactArrayComparison(ArrayNode actual, ArrayNode expected, Location pathToHere, List<String> failures) {
        for (int i = 0; i < Math.min(actual.size(), expected.size()); ++i) {
            this.compareTrees(actual.get(i), expected.get(i), pathToHere.child(Integer.toString(i)), failures);
        }
    }

    @Override
    public String describe() {
        return "equal to " + this.expected.toPrettyString() + this.explainRules();
    }

    private String explainRules() {
        if (this.rules.isEmpty()) {
            return "";
        }
        return "\nWith rules:" + this.rules.stream().map(PathRule::toString).collect(Collectors.joining("\n"));
    }

    private static Set<String> toSet(Iterator<String> iterable) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        iterable.forEachRemaining(set::add);
        return set;
    }
}

