/*
========================================================================
SchemaCrawler
http://www.schemacrawler.com
Copyright (c) 2000-2024, Sualeh Fatehi <sualeh@hotmail.com>.
All rights reserved.
------------------------------------------------------------------------

SchemaCrawler is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

SchemaCrawler and the accompanying materials are made available under
the terms of the Eclipse Public License v1.0, GNU General Public License
v3 or GNU Lesser General Public License v3.

You may elect to redistribute this code under any of these licenses.

The Eclipse Public License is available at:
http://www.eclipse.org/legal/epl-v10.html

The GNU General Public License v3 and the GNU Lesser General Public
License v3 are available at:
http://www.gnu.org/licenses/

========================================================================
*/

package schemacrawler.schema;

import static java.sql.DatabaseMetaData.tableIndexClustered;
import static java.sql.DatabaseMetaData.tableIndexHashed;
import static java.sql.DatabaseMetaData.tableIndexOther;
import static java.sql.DatabaseMetaData.tableIndexStatistic;

/** An enumeration wrapper around index types. */
public enum IndexType implements IdentifiedEnum {
  unknown(-1),
  statistic(tableIndexStatistic),
  clustered(tableIndexClustered),
  hashed(tableIndexHashed),
  other(tableIndexOther);

  private final int id;

  IndexType(final int id) {
    this.id = id;
  }

  /** {@inheritDoc} */
  @Override
  public int id() {
    return id;
  }
}
