/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe.util;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.values.LogicalValue;
import us.springett.parsers.cpe.values.Part;

public final class Convert {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final Logger LOG = LoggerFactory.getLogger(Convert.class);

    private Convert() {
    }

    public static String toWellFormed(String value) {
        if (value == null) {
            return LogicalValue.ANY.getAbbreviation();
        }
        if (LogicalValue.ANY.getAbbreviation().equals(value) || LogicalValue.NA.getAbbreviation().equals(value)) {
            return value;
        }
        StringBuilder buffer = new StringBuilder(value);
        for (int x = 0; x < buffer.length(); ++x) {
            char c = buffer.charAt(x);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            buffer.insert(x++, '\\');
        }
        return buffer.toString();
    }

    public static String fromWellFormed(String value) {
        if (value == null) {
            return LogicalValue.ANY.getAbbreviation();
        }
        StringBuilder buffer = new StringBuilder(value);
        int p = 32;
        for (int x = 0; x < buffer.length() - 1; ++x) {
            char c = buffer.charAt(x);
            if (c == '\\' && p != 92) {
                buffer.delete(x, x + 1);
                --x;
            }
            p = c;
        }
        return buffer.toString();
    }

    public static String wellFormedToCpeUri(Part value) {
        if (value == null) {
            return Part.ANY.getAbbreviation();
        }
        return value.getAbbreviation();
    }

    public static String wellFormedToCpeUri(String wellFormed) throws CpeEncodingException {
        if (wellFormed == null || wellFormed.isEmpty() || LogicalValue.ANY.getAbbreviation().equals(wellFormed)) {
            return "";
        }
        if (LogicalValue.NA.getAbbreviation().equals(wellFormed)) {
            return wellFormed;
        }
        try {
            byte[] bytes = wellFormed.getBytes("UTF-8");
            StringBuilder sb = new StringBuilder(wellFormed.length() + 10);
            for (int x = 0; x < bytes.length; ++x) {
                byte c = bytes[x];
                if (c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                    sb.append((char)c);
                    continue;
                }
                if (c == 92) {
                    if (++x >= bytes.length) {
                        throw new CpeEncodingException("Invalid Well Formed string - ends with an unquoted backslash");
                    }
                    c = bytes[x];
                    if (c == 95 || c == 46 || c == 45) {
                        sb.append((char)c);
                        continue;
                    }
                    sb.append('%').append(HEX_CHARS[(c & 0xF0) >>> 4]).append(HEX_CHARS[c & 0xF]);
                    continue;
                }
                if (c == 42) {
                    sb.append("%02");
                    continue;
                }
                if (c == 63) {
                    sb.append("%01");
                    continue;
                }
                throw new CpeEncodingException("Invalid Well Formed string - unexpected characters: " + wellFormed);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new CpeEncodingException("UTF-8 encoding is not supported on this JVM?", ex);
        }
    }

    public static String cpeUriToWellFormed(String value) throws CpeEncodingException {
        return Convert.cpeUriToWellFormed(value, false);
    }

    public static String cpeUriToWellFormed(String value, boolean lenient) throws CpeEncodingException {
        if (value == null || value.isEmpty() || LogicalValue.ANY.getAbbreviation().equals(value)) {
            return LogicalValue.ANY.getAbbreviation();
        }
        if (LogicalValue.NA.getAbbreviation().equals(value)) {
            return LogicalValue.NA.getAbbreviation();
        }
        try {
            byte[] bytes = value.toLowerCase().getBytes("UTF-8");
            StringBuilder sb = new StringBuilder(value.length());
            for (int x = 0; x < bytes.length; ++x) {
                char c = (char)bytes[x];
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                    sb.append(c);
                    continue;
                }
                if (c == '_' || c == '.' || c == '-') {
                    sb.append('\\').append(c);
                    continue;
                }
                if (c == '%') {
                    if (2 + x >= bytes.length) {
                        throw new CpeEncodingException("Invalid CPE URI component - ends with a single percent");
                    }
                    char decoded = (char)(Character.digit(bytes[++x], 16) * 16 + Character.digit(bytes[++x], 16));
                    switch (decoded) {
                        case '\u0001': {
                            sb.append('?');
                            break;
                        }
                        case '\u0002': {
                            sb.append('*');
                            break;
                        }
                        default: {
                            sb.append('\\').append(decoded);
                            break;
                        }
                    }
                    continue;
                }
                if (lenient) {
                    LOG.debug("Invalid CPE URI part, '%s'; escaping '%s' as a well formatted string", (Object)value, (Object)Character.valueOf(c));
                    sb.append('\\').append(c);
                    continue;
                }
                throw new CpeEncodingException("Invalid CPE URI component - unexpected characters");
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new CpeEncodingException("UTF-8 encoding is not supported on this JVM?", ex);
        }
    }

    public static String wellFormedToFS(Part value) {
        if (value == null) {
            return LogicalValue.ANY.getAbbreviation();
        }
        return value.getAbbreviation();
    }

    public static String wellFormedToFS(String value) {
        if (value == null || value.isEmpty()) {
            return LogicalValue.ANY.getAbbreviation();
        }
        if (LogicalValue.ANY.getAbbreviation().equals(value) || LogicalValue.NA.getAbbreviation().equals(value)) {
            return value;
        }
        StringBuilder buffer = new StringBuilder(value);
        int p = 32;
        for (int x = 0; x < buffer.length() - 1; ++x) {
            char c = buffer.charAt(x);
            if ((c == '.' || c == '_' || c == '-') && p == 92) {
                buffer.delete(x - 1, x);
                --x;
            }
            p = c;
        }
        return buffer.toString();
    }

    public static String fsToWellFormed(String value) {
        return Convert.fsToWellFormed(value, false);
    }

    public static String fsToWellFormed(String value, boolean lenient) {
        if (value == null || value.isEmpty()) {
            return LogicalValue.ANY.getAbbreviation();
        }
        if (LogicalValue.ANY.getAbbreviation().equals(value) || LogicalValue.NA.getAbbreviation().equals(value)) {
            return value;
        }
        int startLenient = -1;
        int endLenient = value.length() - 1;
        if (lenient) {
            int prev = 32;
            for (int x = 0; x < value.length(); ++x) {
                char c = value.charAt(x);
                if (startLenient < 0 && c != '?' && c != '*') {
                    startLenient = x;
                }
                switch (c) {
                    case '*': 
                    case '?': {
                        if (prev == 42 || prev == 63) break;
                        endLenient = x - 1;
                        break;
                    }
                    case '\\': {
                        ++x;
                    }
                    default: {
                        endLenient = value.length() - 1;
                    }
                }
                prev = c;
            }
        }
        boolean quoted = false;
        StringBuilder buffer = new StringBuilder(value);
        for (int x = 0; x < buffer.length(); ++x) {
            char c = buffer.charAt(x);
            if (c == '.' || c == '_' || c == '-') {
                buffer.insert(x++, '\\');
                ++endLenient;
                continue;
            }
            if (!lenient || x < startLenient || x > endLenient) continue;
            if (!quoted && c == '\\') {
                quoted = true;
                continue;
            }
            if (!(quoted || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                buffer.insert(x++, '\\');
                ++endLenient;
            }
            quoted = false;
        }
        return buffer.toString();
    }

    public static Pattern wellFormedToPattern(String value) {
        StringBuilder sb = new StringBuilder(value.length() + 4);
        for (int x = 0; x < value.length(); ++x) {
            if (value.charAt(x) == '*') {
                sb.append(".*");
                continue;
            }
            if (value.charAt(x) == '?') {
                sb.append(".");
                continue;
            }
            if (value.charAt(x) == '\\' && x + 1 < value.length()) {
                sb.append('\\').append(value.charAt(x++)).append('\\').append(value.charAt(x));
                continue;
            }
            if (value.charAt(x) >= 'a' && value.charAt(x) <= 'z' || value.charAt(x) >= 'A' && value.charAt(x) <= 'Z' || value.charAt(x) >= '0' && value.charAt(x) <= '9') {
                sb.append(value.charAt(x));
                continue;
            }
            sb.append('\\').append(value.charAt(x));
        }
        return Pattern.compile(sb.toString());
    }
}

