/*
 * Decompiled with CFR 0.152.
 */
package xyz.urbanmatrix.mavlink.generator;

import com.squareup.kotlinpoet.ClassName;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.urbanmatrix.mavlink.generator.models.EnumModel;
import xyz.urbanmatrix.mavlink.generator.models.MavlinkModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lxyz/urbanmatrix/mavlink/generator/EnumResolver;", "", "basePackage", "", "mavlinkModels", "", "Lxyz/urbanmatrix/mavlink/generator/models/MavlinkModel;", "(Ljava/lang/String;Ljava/util/List;)V", "resolve", "Lcom/squareup/kotlinpoet/ClassName;", "enumType", "generator"})
public final class EnumResolver {
    @NotNull
    private final String basePackage;
    @NotNull
    private final List<MavlinkModel> mavlinkModels;

    public EnumResolver(@NotNull String basePackage, @NotNull List<MavlinkModel> mavlinkModels) {
        Intrinsics.checkNotNullParameter((Object)basePackage, (String)"basePackage");
        Intrinsics.checkNotNullParameter(mavlinkModels, (String)"mavlinkModels");
        this.basePackage = basePackage;
        this.mavlinkModels = mavlinkModels;
    }

    @NotNull
    public final ClassName resolve(@NotNull String enumType) {
        Intrinsics.checkNotNullParameter((Object)enumType, (String)"enumType");
        for (MavlinkModel mavlinkModel : this.mavlinkModels) {
            for (EnumModel enumModel : mavlinkModel.getEnums()) {
                if (!Intrinsics.areEqual((Object)enumModel.getName(), (Object)enumType)) continue;
                String[] stringArray = new String[]{enumModel.getFormattedName()};
                return new ClassName(this.basePackage + '.' + mavlinkModel.getSubPackageName(), stringArray);
            }
        }
        throw new IllegalArgumentException(enumType + " not defined in available mavlink schema");
    }
}

