/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AppointmentResponse", profile="http://hl7.org/fhir/StructureDefinition/AppointmentResponse")
public class AppointmentResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected List<Identifier> identifier;
    @Child(name="appointment", type={Appointment.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Appointment this response relates to", formalDefinition="Appointment that this response is replying to.")
    protected Reference appointment;
    protected Appointment appointmentTarget;
    @Child(name="start", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time from appointment, or requested new start time", formalDefinition="Date/Time that the appointment is to take place, or requested new start time.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time from appointment, or requested new end time", formalDefinition="This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.")
    protected InstantType end;
    @Child(name="participantType", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Role of participant in the appointment", formalDefinition="Role of participant in the appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
    protected List<CodeableConcept> participantType;
    @Child(name="actor", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person, Location, HealthcareService, or Device", formalDefinition="A Person, Location, HealthcareService, or Device that is participating in the appointment.")
    protected Reference actor;
    protected Resource actorTarget;
    @Child(name="participantStatus", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="accepted | declined | tentative | needs-action", formalDefinition="Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/participationstatus")
    protected Enumeration<ParticipantStatus> participantStatus;
    @Child(name="comment", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional comments", formalDefinition="Additional comments about the appointment.")
    protected StringType comment;
    private static final long serialVersionUID = 248548635L;
    @SearchParamDefinition(name="actor", path="AppointmentResponse.actor", description="The Person, Location/HealthcareService or Device that this appointment response replies for", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("AppointmentResponse:actor").toLocked();
    @SearchParamDefinition(name="identifier", path="AppointmentResponse.identifier", description="An Identifier in this appointment response", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="practitioner", path="AppointmentResponse.actor.where(resolve() is Practitioner)", description="This Response is for this Practitioner", type="reference", target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("AppointmentResponse:practitioner").toLocked();
    @SearchParamDefinition(name="part-status", path="AppointmentResponse.participantStatus", description="The participants acceptance status for this appointment", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="patient", path="AppointmentResponse.actor.where(resolve() is Patient)", description="This Response is for this Patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AppointmentResponse:patient").toLocked();
    @SearchParamDefinition(name="appointment", path="AppointmentResponse.appointment", description="The appointment that the response is attached to", type="reference", target={Appointment.class})
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("AppointmentResponse:appointment").toLocked();
    @SearchParamDefinition(name="location", path="AppointmentResponse.actor.where(resolve() is Location)", description="This Response is for this Location", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("AppointmentResponse:location").toLocked();

    public AppointmentResponse() {
    }

    public AppointmentResponse(Reference appointment, Enumeration<ParticipantStatus> participantStatus) {
        this.appointment = appointment;
        this.participantStatus = participantStatus;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AppointmentResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AppointmentResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getAppointment() {
        if (this.appointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointment = new Reference();
            }
        }
        return this.appointment;
    }

    public boolean hasAppointment() {
        return this.appointment != null && !this.appointment.isEmpty();
    }

    public AppointmentResponse setAppointment(Reference value) {
        this.appointment = value;
        return this;
    }

    public Appointment getAppointmentTarget() {
        if (this.appointmentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentTarget = new Appointment();
            }
        }
        return this.appointmentTarget;
    }

    public AppointmentResponse setAppointmentTarget(Appointment value) {
        this.appointmentTarget = value;
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public AppointmentResponse setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public AppointmentResponse setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new InstantType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public AppointmentResponse setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public AppointmentResponse setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getParticipantType() {
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        return this.participantType;
    }

    public AppointmentResponse setParticipantType(List<CodeableConcept> theParticipantType) {
        this.participantType = theParticipantType;
        return this;
    }

    public boolean hasParticipantType() {
        if (this.participantType == null) {
            return false;
        }
        for (CodeableConcept item : this.participantType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addParticipantType() {
        CodeableConcept t = new CodeableConcept();
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        this.participantType.add(t);
        return t;
    }

    public AppointmentResponse addParticipantType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        this.participantType.add(t);
        return this;
    }

    public CodeableConcept getParticipantTypeFirstRep() {
        if (this.getParticipantType().isEmpty()) {
            this.addParticipantType();
        }
        return this.getParticipantType().get(0);
    }

    public Reference getActor() {
        if (this.actor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.actor");
            }
            if (Configuration.doAutoCreate()) {
                this.actor = new Reference();
            }
        }
        return this.actor;
    }

    public boolean hasActor() {
        return this.actor != null && !this.actor.isEmpty();
    }

    public AppointmentResponse setActor(Reference value) {
        this.actor = value;
        return this;
    }

    public Resource getActorTarget() {
        return this.actorTarget;
    }

    public AppointmentResponse setActorTarget(Resource value) {
        this.actorTarget = value;
        return this;
    }

    public Enumeration<ParticipantStatus> getParticipantStatusElement() {
        if (this.participantStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.participantStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.participantStatus = new Enumeration<ParticipantStatus>(new ParticipantStatusEnumFactory());
            }
        }
        return this.participantStatus;
    }

    public boolean hasParticipantStatusElement() {
        return this.participantStatus != null && !this.participantStatus.isEmpty();
    }

    public boolean hasParticipantStatus() {
        return this.participantStatus != null && !this.participantStatus.isEmpty();
    }

    public AppointmentResponse setParticipantStatusElement(Enumeration<ParticipantStatus> value) {
        this.participantStatus = value;
        return this;
    }

    public ParticipantStatus getParticipantStatus() {
        return this.participantStatus == null ? null : (ParticipantStatus)((Object)this.participantStatus.getValue());
    }

    public AppointmentResponse setParticipantStatus(ParticipantStatus value) {
        if (this.participantStatus == null) {
            this.participantStatus = new Enumeration<ParticipantStatus>(new ParticipantStatusEnumFactory());
        }
        this.participantStatus.setValue((Object)value);
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public AppointmentResponse setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public AppointmentResponse setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "Appointment that this response is replying to.", 0, 1, this.appointment));
        children.add(new Property("start", "instant", "Date/Time that the appointment is to take place, or requested new start time.", 0, 1, this.start));
        children.add(new Property("end", "instant", "This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.", 0, 1, this.end));
        children.add(new Property("participantType", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.participantType));
        children.add(new Property(SP_ACTOR, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location, HealthcareService, or Device that is participating in the appointment.", 0, 1, this.actor));
        children.add(new Property("participantStatus", "code", "Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.", 0, 1, this.participantStatus));
        children.add(new Property("comment", "string", "Additional comments about the appointment.", 0, 1, this.comment));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1474995297: {
                return new Property(SP_APPOINTMENT, "Reference(Appointment)", "Appointment that this response is replying to.", 0, 1, this.appointment);
            }
            case 109757538: {
                return new Property("start", "instant", "Date/Time that the appointment is to take place, or requested new start time.", 0, 1, this.start);
            }
            case 100571: {
                return new Property("end", "instant", "This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.", 0, 1, this.end);
            }
            case 841294093: {
                return new Property("participantType", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.participantType);
            }
            case 92645877: {
                return new Property(SP_ACTOR, "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location, HealthcareService, or Device that is participating in the appointment.", 0, 1, this.actor);
            }
            case 996096261: {
                return new Property("participantStatus", "code", "Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.", 0, 1, this.participantStatus);
            }
            case 950398559: {
                return new Property("comment", "string", "Additional comments about the appointment.", 0, 1, this.comment);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1474995297: {
                Base[] baseArray;
                if (this.appointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.appointment;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.end;
                }
                return baseArray;
            }
            case 841294093: {
                return this.participantType == null ? new Base[]{} : this.participantType.toArray(new Base[this.participantType.size()]);
            }
            case 92645877: {
                Base[] baseArray;
                if (this.actor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.actor;
                }
                return baseArray;
            }
            case 996096261: {
                Base[] baseArray;
                if (this.participantStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.participantStatus;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.comment;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1474995297: {
                this.appointment = this.castToReference(value);
                return value;
            }
            case 109757538: {
                this.start = this.castToInstant(value);
                return value;
            }
            case 100571: {
                this.end = this.castToInstant(value);
                return value;
            }
            case 841294093: {
                this.getParticipantType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 92645877: {
                this.actor = this.castToReference(value);
                return value;
            }
            case 996096261: {
                value = new ParticipantStatusEnumFactory().fromType(this.castToCode(value));
                this.participantStatus = value;
                return value;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.appointment = this.castToReference(value);
        } else if (name.equals("start")) {
            this.start = this.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = this.castToInstant(value);
        } else if (name.equals("participantType")) {
            this.getParticipantType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.actor = this.castToReference(value);
        } else if (name.equals("participantStatus")) {
            value = new ParticipantStatusEnumFactory().fromType(this.castToCode(value));
            this.participantStatus = value;
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1474995297: {
                return this.getAppointment();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case 100571: {
                return this.getEndElement();
            }
            case 841294093: {
                return this.addParticipantType();
            }
            case 92645877: {
                return this.getActor();
            }
            case 996096261: {
                return this.getParticipantStatusElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1474995297: {
                return new String[]{"Reference"};
            }
            case 109757538: {
                return new String[]{"instant"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case 841294093: {
                return new String[]{"CodeableConcept"};
            }
            case 92645877: {
                return new String[]{"Reference"};
            }
            case 996096261: {
                return new String[]{"code"};
            }
            case 950398559: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_APPOINTMENT)) {
            this.appointment = new Reference();
            return this.appointment;
        }
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.end");
        }
        if (name.equals("participantType")) {
            return this.addParticipantType();
        }
        if (name.equals(SP_ACTOR)) {
            this.actor = new Reference();
            return this.actor;
        }
        if (name.equals("participantStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.participantStatus");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AppointmentResponse";
    }

    @Override
    public AppointmentResponse copy() {
        AppointmentResponse dst = new AppointmentResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AppointmentResponse dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.appointment = this.appointment == null ? null : this.appointment.copy();
        dst.start = this.start == null ? null : this.start.copy();
        InstantType instantType = dst.end = this.end == null ? null : this.end.copy();
        if (this.participantType != null) {
            dst.participantType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.participantType) {
                dst.participantType.add(codeableConcept.copy());
            }
        }
        dst.actor = this.actor == null ? null : this.actor.copy();
        dst.participantStatus = this.participantStatus == null ? null : this.participantStatus.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
    }

    protected AppointmentResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AppointmentResponse)) {
            return false;
        }
        AppointmentResponse o = (AppointmentResponse)other_;
        return AppointmentResponse.compareDeep(this.identifier, o.identifier, true) && AppointmentResponse.compareDeep(this.appointment, o.appointment, true) && AppointmentResponse.compareDeep(this.start, o.start, true) && AppointmentResponse.compareDeep(this.end, o.end, true) && AppointmentResponse.compareDeep(this.participantType, o.participantType, true) && AppointmentResponse.compareDeep(this.actor, o.actor, true) && AppointmentResponse.compareDeep(this.participantStatus, o.participantStatus, true) && AppointmentResponse.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AppointmentResponse)) {
            return false;
        }
        AppointmentResponse o = (AppointmentResponse)other_;
        return AppointmentResponse.compareValues(this.start, o.start, true) && AppointmentResponse.compareValues(this.end, o.end, true) && AppointmentResponse.compareValues(this.participantStatus, o.participantStatus, true) && AppointmentResponse.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.appointment, this.start, this.end, this.participantType, this.actor, this.participantStatus, this.comment});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AppointmentResponse;
    }

    public static class ParticipantStatusEnumFactory
    implements EnumFactory<ParticipantStatus> {
        @Override
        public ParticipantStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return ParticipantStatus.ACCEPTED;
            }
            if ("declined".equals(codeString)) {
                return ParticipantStatus.DECLINED;
            }
            if ("tentative".equals(codeString)) {
                return ParticipantStatus.TENTATIVE;
            }
            if ("needs-action".equals(codeString)) {
                return ParticipantStatus.NEEDSACTION;
            }
            throw new IllegalArgumentException("Unknown ParticipantStatus code '" + codeString + "'");
        }

        public Enumeration<ParticipantStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ParticipantStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<ParticipantStatus>(this, ParticipantStatus.ACCEPTED);
            }
            if ("declined".equals(codeString)) {
                return new Enumeration<ParticipantStatus>(this, ParticipantStatus.DECLINED);
            }
            if ("tentative".equals(codeString)) {
                return new Enumeration<ParticipantStatus>(this, ParticipantStatus.TENTATIVE);
            }
            if ("needs-action".equals(codeString)) {
                return new Enumeration<ParticipantStatus>(this, ParticipantStatus.NEEDSACTION);
            }
            throw new FHIRException("Unknown ParticipantStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ParticipantStatus code) {
            if (code == ParticipantStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == ParticipantStatus.DECLINED) {
                return "declined";
            }
            if (code == ParticipantStatus.TENTATIVE) {
                return "tentative";
            }
            if (code == ParticipantStatus.NEEDSACTION) {
                return "needs-action";
            }
            return "?";
        }

        @Override
        public String toSystem(ParticipantStatus code) {
            return code.getSystem();
        }
    }

    public static enum ParticipantStatus {
        ACCEPTED,
        DECLINED,
        TENTATIVE,
        NEEDSACTION,
        NULL;


        public static ParticipantStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("declined".equals(codeString)) {
                return DECLINED;
            }
            if ("tentative".equals(codeString)) {
                return TENTATIVE;
            }
            if ("needs-action".equals(codeString)) {
                return NEEDSACTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ParticipantStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACCEPTED: {
                    return "accepted";
                }
                case DECLINED: {
                    return "declined";
                }
                case TENTATIVE: {
                    return "tentative";
                }
                case NEEDSACTION: {
                    return "needs-action";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACCEPTED: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case DECLINED: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case TENTATIVE: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case NEEDSACTION: {
                    return "http://hl7.org/fhir/participationstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACCEPTED: {
                    return "The participant has accepted the appointment.";
                }
                case DECLINED: {
                    return "The participant has declined the appointment and will not participate in the appointment.";
                }
                case TENTATIVE: {
                    return "The participant has  tentatively accepted the appointment. This could be automatically created by a system and requires further processing before it can be accepted. There is no commitment that attendance will occur.";
                }
                case NEEDSACTION: {
                    return "The participant needs to indicate if they accept the appointment by changing this status to one of the other statuses.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACCEPTED: {
                    return "Accepted";
                }
                case DECLINED: {
                    return "Declined";
                }
                case TENTATIVE: {
                    return "Tentative";
                }
                case NEEDSACTION: {
                    return "Needs Action";
                }
            }
            return "?";
        }
    }
}

