/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.generator.maven;

import com.anaptecs.jeaf.fwk.generator.util.ModelingTool;
import com.anaptecs.jeaf.fwk.generator.util.RESTLibrary;
import com.anaptecs.jeaf.fwk.generator.util.TargetRuntime;
import com.anaptecs.jeaf.fwk.tools.message.generator.ConversionResult;
import com.anaptecs.jeaf.fwk.tools.message.generator.ExcelToMessageResourceConverter;
import com.anaptecs.jeaf.fwk.tools.message.generator.MessageConstantsGenerator;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.tools.api.file.FileTools;
import com.anaptecs.jeaf.tools.api.performance.Stopwatch;
import com.anaptecs.jeaf.tools.api.performance.TimePrecision;
import com.anaptecs.jeaf.tools.api.string.StringTools;
import com.anaptecs.jeaf.tools.api.xml.DocumentProperties;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.VerificationResult;
import com.anaptecs.jeaf.xfun.api.errorhandling.ApplicationException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openarchitectureware.workflow.WorkflowRunner;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="Generator", defaultPhase=LifecyclePhase.NONE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=false, defaultValue="MAGIC_DRAW")
    private ModelingTool umlModelingTool;
    @Parameter(required=false)
    private String xmiDirectory;
    @Parameter(required=false)
    private String modelArtifactGroupID;
    @Parameter(required=false)
    private String modelArtifactArtifactID;
    @Parameter(required=false)
    private String modelArtifactXMIPath;
    @Parameter(required=false)
    private String umlModelFile;
    @Parameter(required=false, defaultValue="JMM.profile.uml")
    private String umlProfileFile;
    @Parameter(required=false, defaultValue="CustomRoot::Root")
    private String customRootTemplate;
    @Parameter(required=false, defaultValue=" ")
    private List<String> customCheckFiles;
    @Parameter(required=false)
    private String sourceDirectory;
    @Parameter(required=false)
    private String sourceGenDirectory;
    @Parameter(required=false, defaultValue="false")
    private boolean cleanSourceGen;
    @Parameter(required=false)
    private String resourceDirectory;
    @Parameter(required=false)
    private String resourceGenDirectory;
    @Parameter(required=false, defaultValue="false")
    private boolean cleanResourceGen;
    @Parameter(required=false, defaultValue=" ")
    private List<String> packages;
    @Parameter(required=false, defaultValue=" ")
    private List<String> ignoredResourceFiles;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateCustomConstraints;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateServiceInterfaces;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateServiceProxies;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateServiceProviderInterfaces;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateServiceProviderImpls;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateRESTResources;
    @Parameter(required=false)
    private String restPathPrefix = "";
    @Parameter(required=false, defaultValue="false")
    private Boolean generateRESTServiceProxies;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateRESTServiceProxyConfigFile;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateActivityInterfaces;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateActivityImpls;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateServiceObjects;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateExceptionClasses;
    @Parameter(required=false, defaultValue="false")
    private Boolean generatePersistentObjects;
    @Parameter(required=false, defaultValue="false")
    private Boolean generatePOJOs;
    @Parameter(required=false, defaultValue="false")
    private Boolean makePOJOsSerializable;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateDomainObjects;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateObjectMappers;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateComponentImpls;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateComponentRuntimeClasses;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateGlobalParts;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateJUnitTests;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateOpenAPISpec;
    @Parameter(required=false, defaultValue="false")
    private Boolean enableYAML11Compatibility;
    @Parameter(required=false, defaultValue="false")
    private Boolean suppressTechnicalHeaders;
    @Parameter(required=false, defaultValue="false")
    private Boolean addIgnoredHeadersToOpenAPISpec;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateJAXRSAnnotations;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateJacksonAnnotations;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateValidAnnotationForClasses;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateValidationAnnotationsForAttributesFromMultiplicity;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateValidationAnnotationsForAssociationsFromMultiplicity;
    @Parameter(required=false, defaultValue="true")
    private Boolean enableSemVerForJSON;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateJSONSerializers;
    @Parameter(required=false, defaultValue="false")
    private Boolean suppressClassNameCommentInOpenAPISpec;
    @Parameter(required=false, defaultValue="true")
    private Boolean generateConstantsForAttributeNames;
    @Parameter(required=false)
    private List<String> suppressWarnings = new ArrayList<String>();
    @Parameter(required=false, defaultValue="false")
    private Boolean suppressAllWarnings;
    @Parameter(required=false, defaultValue="false")
    private Boolean addGeneratedAnnotation;
    @Parameter(required=false, defaultValue="false")
    private Boolean addGenerationTimestamp;
    @Parameter(required=false)
    private String generationComment = "";
    @Parameter(required=false, defaultValue="JEAF")
    private TargetRuntime targetRuntime;
    @Parameter(required=false)
    private RESTLibrary restLibrary;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateMessageConstants;
    @Parameter(required=false, defaultValue="false")
    private Boolean generatePublicSettersForAssociations;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateNullChecksForToOneAssociations;
    @Parameter(required=false, defaultValue="false")
    private Boolean generatePublicObjectView;
    @Parameter(required=false, defaultValue="false")
    private Boolean disableImmutabilityOfCollections;
    @Parameter(required=false, defaultValue="false")
    private Boolean disableImmutabilityOfArrays;
    @Parameter(required=false, defaultValue="false")
    private Boolean disableImmutabilityOfBinaryData;
    @Parameter(required=false, defaultValue="false")
    private Boolean enableDetailedToStringMethod;
    @Parameter(required=false, defaultValue="false")
    private Boolean enableLegacyBuilderStyle;
    @Parameter(required=false, defaultValue="false")
    private Boolean generateBuilderWithAllMandatoryFields;
    @Parameter(required=false, defaultValue="true")
    private Boolean breakBuildOnGeneratorError;
    @Parameter(required=false, defaultValue="OID")
    private String peristentObjectsOIDRowName;
    @Parameter(required=false, defaultValue="VERSION")
    private String peristentObjectsVersionLabelRowName;
    @Parameter(required=false, defaultValue="Please add organization file header")
    private String fileHeaderCompany;
    @Parameter(required=false, defaultValue="JEAF Generator")
    private String fileHeaderAuthor;
    @Parameter(required=false, defaultValue="All rights reserved.")
    private String fileHeaderCopyright;
    @Parameter(required=false, defaultValue="1.0")
    private String fileHeaderVersion;
    @Parameter(required=false, defaultValue="false")
    private boolean disableFormatting;
    @Parameter(required=false, defaultValue="false")
    private boolean disableSourceFormatting;
    @Parameter(required=false, defaultValue="false")
    private boolean disableResourceFormatting;
    @Parameter(required=false, defaultValue="anaptecs_code_guideline.xml")
    private String javaFormatterStyleFile;
    @Parameter(required=false, defaultValue="anaptecs_xml_style.properties")
    private String xmlFormatterStyleFile;
    @Parameter(required=false, defaultValue="java.,javax.,org.,com.")
    private String importGroups;
    @Parameter(required=false, defaultValue="java,*")
    private String staticImportGroups;
    @Parameter(required=false, defaultValue="true")
    private boolean removeUnusedImports;
    @Component
    private BuildPluginManager pluginManager;

    public GeneratorMojo() {
        System.setProperty("log4j.configuration", "jeaf-generator-log4j.xml");
        System.setProperty("log4j2.configurationFile", "jeaf-generator-log4j2.xml");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isGenerationRequested()) {
            this.showStartupInfo();
            this.cleanDirectories();
            this.runMessageConstantsGenerator();
            boolean lSuccessful = this.runUMLGenerator();
            if (lSuccessful) {
                this.runFormatter();
            } else {
                if (this.breakBuildOnGeneratorError.booleanValue()) {
                    throw new MojoFailureException("Problem occured during code generation from UML model. Please see log output for further details.");
                }
                this.getLog().error((CharSequence)"");
                this.getLog().error((CharSequence)"Error(s) during code generation. Please see log output for further details.");
                this.getLog().error((CharSequence)"For further information about how to solve them please check: https://anaptecs.atlassian.net/l/cp/5KVHFrW9");
                this.getLog().error((CharSequence)"");
            }
        } else {
            Log lLog = this.getLog();
            lLog.info((CharSequence)"--------------------------------------------------------------------------------------");
            lLog.info((CharSequence)("Starting JEAF Generator " + XFun.getVersionInfo().getVersionString()));
            lLog.info((CharSequence)"Skipping code generation as there is no configuration present.");
            lLog.info((CharSequence)"--------------------------------------------------------------------------------------");
        }
    }

    private String getPackageWhitelist() {
        return this.packages.stream().collect(Collectors.joining("; "));
    }

    private String getCustomCheckFiles() {
        return this.customCheckFiles.stream().collect(Collectors.joining("; "));
    }

    private void showStartupInfo() {
        Log lLog = this.getLog();
        lLog.info((CharSequence)"--------------------------------------------------------------------------------------");
        lLog.info((CharSequence)("Starting JEAF Generator " + XFun.getVersionInfo().getVersionString()));
        lLog.info((CharSequence)"--------------------------------------------------------------------------------------");
        if (this.isUMLGenerationRequested()) {
            lLog.info((CharSequence)("UML Model File:                                   " + this.umlModelFile));
            lLog.info((CharSequence)("UML Profile File:                                 " + this.umlProfileFile));
            if (this.xmiDirectory != null) {
                lLog.info((CharSequence)("XMI Path:                                         " + this.xmiDirectory));
            }
            if (this.modelArtifactGroupID != null) {
                lLog.info((CharSequence)("Model Artifact Group-ID:                          " + this.modelArtifactGroupID));
            }
            if (this.modelArtifactArtifactID != null) {
                lLog.info((CharSequence)("Model Artifact-ID:                                " + this.modelArtifactArtifactID));
            }
            if (this.modelArtifactXMIPath != null) {
                lLog.info((CharSequence)("Model Artifact XMI Path:                          " + this.modelArtifactXMIPath));
            }
            lLog.info((CharSequence)" ");
        }
        lLog.info((CharSequence)("src:                                              " + this.sourceDirectory));
        lLog.info((CharSequence)("src-gen:                                          " + this.sourceGenDirectory));
        lLog.info((CharSequence)("res:                                              " + this.resourceDirectory));
        lLog.info((CharSequence)("res-gen:                                          " + this.resourceGenDirectory));
        if (!this.breakBuildOnGeneratorError.booleanValue()) {
            lLog.warn((CharSequence)"");
            lLog.warn((CharSequence)"Errors during code generation do not break the build. Please make sure that this is configured intentionally.");
            lLog.warn((CharSequence)"");
        }
        if (this.isUMLGenerationRequested()) {
            lLog.info((CharSequence)" ");
            lLog.info((CharSequence)("UML Modeling Tool:                                " + this.umlModelingTool.getDisplayName()));
            lLog.info((CharSequence)("Target Runtime:                                   " + this.targetRuntime.name()));
        }
        if (this.restLibrary != null) {
            lLog.info((CharSequence)("REST Library:                                     " + this.restLibrary.name()));
        }
        lLog.info((CharSequence)" ");
        lLog.info((CharSequence)("Code-Style:                                       " + this.xmlFormatterStyleFile));
        lLog.info((CharSequence)("Package Whitelist:                                " + this.getPackageWhitelist()));
        String lIgnoredResources = Tools.getCollectionTools().toString(this.ignoredResourceFiles, ", ");
        if (lIgnoredResources.trim().isEmpty()) {
            lIgnoredResources = "none";
        }
        lLog.info((CharSequence)("Ignored resource files:                           " + lIgnoredResources));
        lLog.info((CharSequence)" ");
        if (this.generateCustomConstraints.booleanValue()) {
            lLog.info((CharSequence)("Generate Custmom Constraints:                     " + this.generateCustomConstraints));
        }
        if (this.generateServiceObjects.booleanValue()) {
            lLog.info((CharSequence)("Generate Service Objects:                         " + this.generateServiceObjects));
            lLog.info((CharSequence)("Generate Constants for Attribute Names:           " + this.generateConstantsForAttributeNames));
        }
        if (this.generateExceptionClasses.booleanValue()) {
            lLog.info((CharSequence)("Generate Exception Classes:                       " + this.generateExceptionClasses));
        }
        if (this.generateServiceInterfaces.booleanValue()) {
            lLog.info((CharSequence)("Generate Service Interfaces:                      " + this.generateServiceInterfaces));
        }
        if (this.generateServiceProxies.booleanValue()) {
            lLog.info((CharSequence)("Generate Service Proxies:                         " + this.generateServiceProxies));
        }
        if (this.generateServiceProviderInterfaces.booleanValue()) {
            lLog.info((CharSequence)("Generate Service Provider Interfaces:             " + this.generateServiceProviderInterfaces));
        }
        if (this.generateServiceProviderImpls.booleanValue()) {
            lLog.info((CharSequence)("Generate Service Provider Impls:                  " + this.generateServiceProviderImpls));
        }
        if (this.generateRESTResources.booleanValue()) {
            lLog.info((CharSequence)("Generate REST Resources:                          " + this.generateRESTResources));
        }
        if (this.restPathPrefix.length() > 0) {
            lLog.info((CharSequence)("REST Path Prefix:                                 " + this.restPathPrefix));
        }
        if (this.generateRESTServiceProxies.booleanValue()) {
            lLog.info((CharSequence)("Generate REST Service Proxies:                    " + this.generateRESTServiceProxies));
        }
        if (this.generateRESTServiceProxyConfigFile.booleanValue()) {
            lLog.info((CharSequence)("Generate REST Service Default Config File:        " + this.generateRESTServiceProxyConfigFile));
        }
        if (this.generateActivityInterfaces.booleanValue()) {
            lLog.info((CharSequence)("Generate Activity Interfaces:                     " + this.generateActivityInterfaces));
        }
        if (this.generateActivityImpls.booleanValue()) {
            lLog.info((CharSequence)("Generate Activity Impls:                          " + this.generateActivityImpls));
        }
        if (this.generatePOJOs.booleanValue()) {
            lLog.info((CharSequence)("Generate POJO's:                                  " + this.generatePOJOs));
            lLog.info((CharSequence)("Make POJO's serializable:                         " + this.makePOJOsSerializable));
            lLog.info((CharSequence)("Generate Constants for Attribute Names:           " + this.generateConstantsForAttributeNames));
        }
        if (this.generateDomainObjects.booleanValue()) {
            lLog.info((CharSequence)("Generate Domain Objects:                          " + this.generateDomainObjects));
            lLog.info((CharSequence)("Generate Constants for Attribute Names:           " + this.generateConstantsForAttributeNames));
        }
        if (this.generateObjectMappers.booleanValue()) {
            lLog.info((CharSequence)("Generate Object Mappers:                          " + this.generateObjectMappers));
        }
        if (this.generateComponentImpls.booleanValue()) {
            lLog.info((CharSequence)("Generate Component Impls:                         " + this.generateComponentImpls));
        }
        if (this.generateComponentRuntimeClasses.booleanValue()) {
            lLog.info((CharSequence)("Generate Component Runtime Classe:                " + this.generateComponentRuntimeClasses));
        }
        if (this.generateGlobalParts.booleanValue()) {
            lLog.info((CharSequence)("Generate Global Parts:                            " + this.generateGlobalParts));
        }
        if (this.generateJUnitTests.booleanValue()) {
            lLog.info((CharSequence)("Generate JUnit Test Cases:                        " + this.generateJUnitTests));
        }
        if (this.generateOpenAPISpec.booleanValue()) {
            lLog.info((CharSequence)("Generate OpenAPI Specification:                   " + this.generateOpenAPISpec));
            lLog.info((CharSequence)("Enable YAML 1.1 compatibility mode:               " + this.enableYAML11Compatibility));
            lLog.info((CharSequence)("Add ignored header fields to OpenAPI spec:        " + this.addIgnoredHeadersToOpenAPISpec));
        }
        if (this.suppressTechnicalHeaders.booleanValue()) {
            lLog.info((CharSequence)("Suppress technical http headers:                  " + this.suppressTechnicalHeaders));
        }
        if (this.generateJAXRSAnnotations.booleanValue()) {
            lLog.info((CharSequence)("Generate JAX-RS annotations:                      " + this.generateJAXRSAnnotations));
        }
        if (this.generateJacksonAnnotations.booleanValue()) {
            lLog.info((CharSequence)("Generate Jackson annotations:                     " + this.generateJacksonAnnotations));
            lLog.info((CharSequence)("Enable SemVer for JSON serialization:             " + this.enableSemVerForJSON));
        }
        if (this.generateJSONSerializers.booleanValue()) {
            lLog.info((CharSequence)("Generate JSON serializers:                        " + this.generateJSONSerializers));
        }
        if (this.suppressAllWarnings.booleanValue()) {
            lLog.info((CharSequence)("Suppress all warnings:                            " + this.suppressAllWarnings));
        }
        if (!this.suppressWarnings.isEmpty()) {
            lLog.info((CharSequence)("Suppress all warnings:                            " + this.suppressWarnings.stream().collect(Collectors.joining("; "))));
        }
        if (this.addGeneratedAnnotation.booleanValue()) {
            lLog.info((CharSequence)("Generate @Generated annotation:                   " + this.addGeneratedAnnotation));
            lLog.info((CharSequence)("Add generation timestamp:                         " + this.addGenerationTimestamp));
            lLog.info((CharSequence)("Add generation comment:                           " + this.generationComment));
        }
        if (this.generateMessageConstants.booleanValue()) {
            lLog.info((CharSequence)("Generate Message Constants:                       " + this.generateMessageConstants));
        }
        if (this.generateValidAnnotationForClasses.booleanValue()) {
            lLog.info((CharSequence)("Generate @Valid Annotations for classes:          " + this.generateValidAnnotationForClasses));
        }
        if (this.generateValidationAnnotationsForAttributesFromMultiplicity.booleanValue()) {
            lLog.info((CharSequence)("Generate Validation Annotations for attributes:   " + this.generateValidationAnnotationsForAttributesFromMultiplicity));
        }
        if (this.generateValidationAnnotationsForAssociationsFromMultiplicity.booleanValue()) {
            lLog.info((CharSequence)("Generate Validation Annotations for associations: " + this.generateValidationAnnotationsForAssociationsFromMultiplicity));
        }
        if (this.generatePersistentObjects.booleanValue()) {
            lLog.info((CharSequence)("Generate Persistent Objects:                      " + this.generatePersistentObjects));
            lLog.info((CharSequence)" ");
            lLog.info((CharSequence)("Generate Constants for Attribute Names:           " + this.generateConstantsForAttributeNames));
            lLog.info((CharSequence)("OID Row Name:                                     " + this.peristentObjectsOIDRowName));
            lLog.info((CharSequence)("Version Label Row Name:                           " + this.peristentObjectsVersionLabelRowName));
        }
        if (this.generatePublicSettersForAssociations.booleanValue()) {
            lLog.info((CharSequence)("Generate public setters for associations:         " + this.generatePublicSettersForAssociations));
        }
        if (this.generateNullChecksForToOneAssociations.booleanValue()) {
            lLog.info((CharSequence)("NULL checks for to one associations:              " + this.generateNullChecksForToOneAssociations));
        }
        if (this.generatePublicObjectView.booleanValue()) {
            lLog.info((CharSequence)("Generate public view for POJO's / ServiceObjects: " + this.generatePublicObjectView));
        }
        if (this.disableImmutabilityOfCollections.booleanValue()) {
            lLog.info((CharSequence)("Disable immutability for collections:             " + this.disableImmutabilityOfCollections));
        }
        if (this.disableImmutabilityOfArrays.booleanValue()) {
            lLog.info((CharSequence)("Disable immutability for non-binary arrays:       " + this.disableImmutabilityOfArrays));
        }
        if (this.disableImmutabilityOfBinaryData.booleanValue()) {
            lLog.info((CharSequence)("Disable immutability for binary arrays:           " + this.disableImmutabilityOfBinaryData));
        }
        if (this.enableLegacyBuilderStyle.booleanValue()) {
            lLog.info((CharSequence)("Enable legacy builder style:                      " + this.enableLegacyBuilderStyle));
        }
        if (this.generateBuilderWithAllMandatoryFields.booleanValue()) {
            lLog.info((CharSequence)("Generate builder with all manadatory fields:      " + this.generateBuilderWithAllMandatoryFields));
        }
        if (this.enableDetailedToStringMethod.booleanValue()) {
            lLog.info((CharSequence)("Enable detailed toString():                       " + this.enableDetailedToStringMethod));
        }
        lLog.info((CharSequence)" ");
        lLog.info((CharSequence)("Javadoc Company Tag:                              " + this.fileHeaderCompany));
        lLog.info((CharSequence)("Javadoc Author Tag:                               " + this.fileHeaderAuthor));
        lLog.info((CharSequence)("Javadoc Copyright Tag:                            " + this.fileHeaderCopyright));
        lLog.info((CharSequence)("Javadoc Version Tag:                              " + this.fileHeaderVersion));
        lLog.info((CharSequence)" ");
    }

    private void cleanDirectories() {
        FileTools lFileTools = Tools.getFileTools();
        if (this.cleanSourceGen) {
            this.getLog().info((CharSequence)("Cleaning src-gen directory '" + this.sourceGenDirectory + "'."));
            lFileTools.tryDeleteRecursive(this.sourceGenDirectory, true);
            lFileTools.createDirectory(this.sourceGenDirectory);
        }
        if (this.cleanResourceGen) {
            this.getLog().info((CharSequence)("Cleaning res-gen directory '" + this.resourceGenDirectory + "'."));
            lFileTools.tryDeleteRecursive(this.resourceGenDirectory, true);
            lFileTools.createDirectory(this.resourceGenDirectory);
        }
    }

    private boolean runUMLGenerator() throws MojoFailureException {
        boolean lSuccessful;
        if (this.isUMLGenerationRequested()) {
            this.prepareXMIFiles();
            System.setProperty("maven.version", this.mavenProject.getVersion());
            System.setProperty("info.version", this.fileHeaderVersion);
            System.setProperty("info.company", this.fileHeaderCompany);
            System.setProperty("info.copyright", this.fileHeaderCopyright);
            System.setProperty("info.author", this.fileHeaderAuthor);
            System.setProperty("list.custom.checkfiles", this.getCustomCheckFiles());
            System.setProperty("list.pkgs.whitelist", this.getPackageWhitelist());
            System.setProperty("switch.gen.custom.constraints", this.generateCustomConstraints.toString());
            System.setProperty("switch.gen.global.parts", this.generateGlobalParts.toString());
            System.setProperty("switch.gen.services", this.generateServiceInterfaces.toString());
            System.setProperty("switch.gen.service.proxies", this.generateServiceProxies.toString());
            System.setProperty("switch.gen.service.provider.interfaces", this.generateServiceProviderInterfaces.toString());
            System.setProperty("switch.gen.persistent.objects", this.generatePersistentObjects.toString());
            System.setProperty("switch.gen.activity.interfaces", this.generateActivityInterfaces.toString());
            System.setProperty("switch.gen.activity.impls", this.generateActivityImpls.toString());
            System.setProperty("switch.gen.object.mappers", this.generateObjectMappers.toString());
            System.setProperty("switch.gen.component.runtime.classes", this.generateComponentRuntimeClasses.toString());
            System.setProperty("switch.gen.component.impls", this.generateComponentImpls.toString());
            System.setProperty("switch.gen.service.provider.impls", this.generateServiceProviderImpls.toString());
            System.setProperty("switch.gen.rest.resources", this.generateRESTResources.toString());
            System.setProperty("switch.gen.rest.path.prefix", this.restPathPrefix);
            System.setProperty("switch.gen.rest.service.proxy", this.generateRESTServiceProxies.toString());
            System.setProperty("switch.gen.rest.service.proxy.config.file", this.generateRESTServiceProxyConfigFile.toString());
            System.setProperty("switch.gen.service.objects", this.generateServiceObjects.toString());
            System.setProperty("switch.gen.exception.classes", this.generateExceptionClasses.toString());
            System.setProperty("switch.gen.pojos", this.generatePOJOs.toString());
            System.setProperty("switch.gen.serializable.pojos", this.makePOJOsSerializable.toString());
            System.setProperty("switch.gen.domain.objects", this.generateDomainObjects.toString());
            System.setProperty("switch.gen.junits", this.generateJUnitTests.toString());
            System.setProperty("switch.gen.openapispec", this.generateOpenAPISpec.toString());
            System.setProperty("switch.gen.openapi.yaml.11.comapitibility", this.enableYAML11Compatibility.toString());
            System.setProperty("switch.gen.rest.suppress.technical.headers", this.suppressTechnicalHeaders.toString());
            System.setProperty("switch.gen.openapi.addIgnoredHeadersToOpenAPISpec", this.addIgnoredHeadersToOpenAPISpec.toString());
            System.setProperty("switch.gen.jaxrs.annotations", this.generateJAXRSAnnotations.toString());
            System.setProperty("switch.gen.jackson.annotations", this.generateJacksonAnnotations.toString());
            System.setProperty("switch.gen.enable.json.semver", this.enableSemVerForJSON.toString());
            System.setProperty("switch.gen.json.serializers", this.generateJSONSerializers.toString());
            System.setProperty("switch.gen.enable.name.constants", this.generateConstantsForAttributeNames.toString());
            System.setProperty("switch.gen.target.runtime", this.targetRuntime.name());
            if (this.restLibrary != null) {
                System.setProperty("switch.gen.target.rest.library", this.restLibrary.name());
            }
            System.setProperty("switch.gen.suppress.warnings", this.suppressWarnings.stream().collect(Collectors.joining("; ")));
            System.setProperty("switch.gen.suppress.all.warnings", this.suppressAllWarnings.toString());
            System.setProperty("switch.gen.add.generated.annotation", this.addGeneratedAnnotation.toString());
            System.setProperty("switch.gen.add.generation.timestamp", this.addGenerationTimestamp.toString());
            System.setProperty("switch.gen.generation.comment", this.generationComment.toString());
            System.setProperty("switch.gen.suppress.classname.openapi", this.suppressClassNameCommentInOpenAPISpec.toString());
            System.setProperty("switch.gen.enable.valid.annotation.classes", this.generateValidAnnotationForClasses.toString());
            System.setProperty("switch.gen.enable.validation.annotation.attributes", this.generateValidationAnnotationsForAttributesFromMultiplicity.toString());
            System.setProperty("switch.gen.enable.validation.annotation.associations", this.generateValidationAnnotationsForAssociationsFromMultiplicity.toString());
            System.setProperty("switch.gen.public.setters.for.associations", this.generatePublicSettersForAssociations.toString());
            System.setProperty("switch.gen.null.checks.for.to.one.associations.of.service.objects", this.generateNullChecksForToOneAssociations.toString());
            System.setProperty("switch.gen.public.object.view", this.generatePublicObjectView.toString());
            System.setProperty("switch.gen.disable.collection.immutability", this.disableImmutabilityOfCollections.toString());
            System.setProperty("switch.gen.disable.array.immutability", this.disableImmutabilityOfArrays.toString());
            System.setProperty("switch.gen.disable.binary.data.immutability", this.disableImmutabilityOfBinaryData.toString());
            System.setProperty("switch.gen.enable.detailed.toString", this.enableDetailedToStringMethod.toString());
            System.setProperty("switch.gen.enable.legacy.builder.style", this.enableLegacyBuilderStyle.toString());
            System.setProperty("switch.gen.enable.builder.for.manadatory.fields", this.generateBuilderWithAllMandatoryFields.toString());
            System.setProperty("name.oid.row", this.peristentObjectsOIDRowName);
            System.setProperty("name.version.label.row", this.peristentObjectsVersionLabelRowName);
            String lXMIDirectory = this.getXMIDirectoryLocation();
            String lModelFilePath = lXMIDirectory + "/" + this.umlModelFile;
            File lModelFile = new File(lModelFilePath);
            String lProfileFilePath = lXMIDirectory + "/" + this.umlProfileFile;
            File lProfileFile = new File(lProfileFilePath);
            if (!lModelFile.exists()) {
                throw new MojoFailureException("UML Model file " + lModelFilePath + " does not exist. Please make sure that the path to the UML model file is correct.");
            }
            if (!lProfileFile.exists()) {
                throw new MojoFailureException("UML profile file " + lProfileFilePath + " does not exist. Please make sure that the path to the UML profile file is correct.");
            }
            HashMap<String, String> lParams = new HashMap<String, String>();
            lParams.put("template.root", "Root::Root");
            lParams.put("custom.root.template", this.customRootTemplate);
            lParams.put("output.slot", "model");
            lParams.put("model.file", lModelFilePath);
            lParams.put("profile.file", lProfileFilePath);
            lParams.put("profile.name", "JMM");
            lParams.put("path.src.gen", this.sourceGenDirectory);
            lParams.put("path.src", this.sourceDirectory);
            lParams.put("path.res.gen", this.resourceGenDirectory);
            lParams.put("path.res", this.resourceDirectory);
            this.getLog().info((CharSequence)("Starting code generation from UML model " + this.umlModelFile));
            WorkflowRunner lRunner = new WorkflowRunner();
            lSuccessful = lRunner.run("workflow.oaw", null, lParams, null);
        } else {
            lSuccessful = true;
        }
        return lSuccessful;
    }

    private void preCheckXMIFiles(List<String> pUMLFiles) throws MojoFailureException {
        for (String lNextFile : pUMLFiles) {
            try {
                String lStartOfFile = FileTools.getFileTools().readLinesAsString(lNextFile, 0, 5);
                if (!lStartOfFile.contains("file:/")) continue;
                this.getLog().warn((CharSequence)("Warning: [9102] " + lNextFile + " seems to use file system references. This might lead to portabilty issues with the exported XMI files. For further details please refer to FAQ entry #2.1 on https://anaptecs.atlassian.net/l/cp/ndmtZxvX"));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage());
            }
        }
    }

    private void prepareXMIFiles() throws MojoFailureException {
        Stopwatch lStopwatch = Tools.getPerformanceTools().createStopwatch("XMI file preparation", TimePrecision.MILLIS);
        lStopwatch.start();
        String lXMIFiles = this.copyXMIFiles();
        FileTools lFileTools = Tools.getFileTools();
        ArrayList<String> lExtensions = new ArrayList<String>();
        lExtensions.add("*.uml");
        List lUMLFiles = lFileTools.listFiles(lXMIFiles, lFileTools.createExtensionFilenameFilter(lExtensions));
        this.preCheckXMIFiles(lUMLFiles);
        if (this.umlModelingTool != ModelingTool.MAGIC_DRAW) {
            this.getLog().info((CharSequence)"Preparing XMI files to be processed by JEAF Generator");
            String lCurrentFile = null;
            try {
                Iterator iterator = lUMLFiles.iterator();
                while (iterator.hasNext()) {
                    String lNextFileName;
                    lCurrentFile = lNextFileName = (String)iterator.next();
                    Path lNextFile = Paths.get(lNextFileName, new String[0]);
                    Stream<String> lLines = Files.lines(lNextFile);
                    List lReplacement = lLines.map(line -> line.replaceAll("xmlns:uml=\"http://www.eclipse.org/uml2/5.0.0/UML\"", "xmlns:uml=\"http://www.eclipse.org/uml2/2.0.0/UML\"")).collect(Collectors.toList());
                    lReplacement = lReplacement.stream().map(line -> line.replaceAll("xmlns:standard=\"http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard\"", "xmlns:standard=\"http://www.eclipse.org/uml2/schemas/Standard/1\"")).collect(Collectors.toList());
                    Files.write(lNextFile, lReplacement, new OpenOption[0]);
                    lLines.close();
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to process XMI file" + lCurrentFile, (Throwable)e);
            }
        }
        lStopwatch.stop();
        if (this.umlModelingTool != ModelingTool.MAGIC_DRAW) {
            this.getLog().info((CharSequence)("XMI file preparation took " + lStopwatch.getResult().getDuration() + "ms"));
        }
    }

    private String getXMIDirectoryLocation() throws MojoFailureException {
        String lXMIDirectory;
        String lExtractDirectory = this.mavenProject.getBuild().getDirectory() + "/uml-model";
        StringTools lTools = Tools.getStringTools();
        if (lTools.isRealString(this.xmiDirectory)) {
            lXMIDirectory = this.umlModelingTool == ModelingTool.MAGIC_DRAW ? this.xmiDirectory : lExtractDirectory;
        } else if (lTools.isRealString(this.modelArtifactGroupID) && lTools.isRealString(this.modelArtifactArtifactID)) {
            lXMIDirectory = lTools.isRealString(this.modelArtifactXMIPath) ? lExtractDirectory + "/" + this.modelArtifactXMIPath : lExtractDirectory;
        } else {
            throw new MojoFailureException("Path to UML model (XMI) is neither defined as direct directory (config parameter 'xmiDirectory') nor through a Maven artifact (config parameters 'modelArtifactXXX'.");
        }
        return lXMIDirectory;
    }

    private String copyXMIFiles() throws MojoFailureException {
        String lXMIDirectoryPath;
        StringTools lTools = Tools.getStringTools();
        if (lTools.isRealString(this.xmiDirectory)) {
            lXMIDirectoryPath = this.getXMIDirectoryLocation();
            if (this.umlModelingTool != ModelingTool.MAGIC_DRAW) {
                FileTools lFileTools = Tools.getFileTools();
                lFileTools.tryDeleteRecursive(lXMIDirectoryPath, true);
                File lXMIDirectory = new File(lXMIDirectoryPath);
                lFileTools.createDirectory(lXMIDirectory);
                ArrayList<String> lExtensions = new ArrayList<String>();
                lExtensions.add("*.uml");
                List lUMLFiles = lFileTools.listFiles(this.xmiDirectory, lFileTools.createExtensionFilenameFilter(lExtensions));
                try {
                    for (String lFile : lUMLFiles) {
                        File lSourceFile = new File(lFile);
                        lFileTools.copyFile(lSourceFile, new File(lXMIDirectoryPath, lSourceFile.getName()));
                    }
                }
                catch (IOException e) {
                    throw new MojoFailureException("Unable to copy XMI files to working directory.", (Throwable)e);
                }
            }
        } else if (lTools.isRealString(this.modelArtifactGroupID) && lTools.isRealString(this.modelArtifactArtifactID)) {
            String lKey = this.modelArtifactGroupID + ":" + this.modelArtifactArtifactID;
            try {
                Artifact lModelArtifact = (Artifact)this.mavenProject.getArtifactMap().get(lKey);
                if (lModelArtifact != null) {
                    Assert.assertNotNull((Object)lModelArtifact, (String)"Model artifact not availble.");
                    String lFilePath = lModelArtifact.getFile().getCanonicalPath();
                    String lExtractDirectory = this.mavenProject.getBuild().getDirectory() + "/uml-model";
                    this.getLog().info((CharSequence)("Extracting UML model files from Maven Artifact " + lFilePath + " to directory " + lExtractDirectory + "."));
                    Tools.getFileTools().extractZipFile(lFilePath, lExtractDirectory, Long.MAX_VALUE);
                    if (lTools.isRealString(this.modelArtifactXMIPath)) {
                        lXMIDirectoryPath = lExtractDirectory + "/" + this.modelArtifactXMIPath;
                    }
                    lXMIDirectoryPath = lExtractDirectory;
                }
                throw new MojoFailureException("Unable to resolve XMI files from artifact " + lKey + ". Maven artifact is not available.Please check configuration of JEAF Generator Plugin.");
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to resolve and extract XMI files from artifact " + lKey, (Throwable)e);
            }
        } else {
            throw new MojoFailureException("Path to UML model (XMI) is neither defined as direct directory (config parameter 'xmiDirectory') nor through a Maven artifact (config parameters 'modelArtifactXXX'.");
        }
        this.getLog().debug((CharSequence)("XMI Working Directory: " + lXMIDirectoryPath));
        return lXMIDirectoryPath;
    }

    private boolean isUMLGenerationRequested() {
        return this.generateCustomConstraints | this.generateServiceInterfaces | this.generateServiceProxies | this.generateServiceProviderInterfaces | this.generateServiceProviderImpls | this.generateRESTResources | this.generateRESTServiceProxies | this.generateRESTServiceProxyConfigFile | this.generateActivityInterfaces | this.generateActivityImpls | this.generateServiceObjects | this.generatePOJOs | this.generateDomainObjects | this.generateObjectMappers | this.generatePersistentObjects | this.generateComponentImpls | this.generateComponentRuntimeClasses | this.generateGlobalParts | this.generateExceptionClasses | this.generateJUnitTests | this.generateOpenAPISpec;
    }

    private boolean isMessageConstantsGenerationRequested() {
        return this.generateMessageConstants;
    }

    private boolean isGenerationRequested() {
        return this.isUMLGenerationRequested() | this.isMessageConstantsGenerationRequested();
    }

    private void runMessageConstantsGenerator() throws MojoFailureException {
        if (this.generateMessageConstants.booleanValue()) {
            this.generateMessageResourceFiles();
            this.generateMessageClasses();
        }
    }

    private void generateMessageResourceFiles() throws MojoFailureException {
        XFun.getTrace().info("");
        XFun.getTrace().info("Transforming Excel files with message definitions to XML representation.");
        File lOutputDirectory = new File(this.resourceGenDirectory);
        if (lOutputDirectory.isDirectory()) {
            List<String> lResourceFiles = this.resolveResourceFiles(this.resourceDirectory, ".xlsx", this.ignoredResourceFiles);
            if (!lResourceFiles.isEmpty()) {
                ExcelToMessageResourceConverter lConverter = new ExcelToMessageResourceConverter();
                for (String lFileName : lResourceFiles) {
                    String lBaseName = Tools.getFileTools().getBaseName(new File(lFileName));
                    if (lBaseName.startsWith("~$")) continue;
                    try {
                        String lOutputFileName = this.resourceGenDirectory + "/" + lBaseName + ".xml";
                        Trace lTrace = XFun.getTrace();
                        lTrace.info("Converting Excel file " + lFileName + " to XML message resource " + lOutputFileName);
                        ConversionResult lResult = lConverter.generateMessageResource(lFileName);
                        VerificationResult lVerificationResult = lResult.getVerificationResult();
                        String lMessage = lVerificationResult.getMessage();
                        if (lVerificationResult.containsErrors()) {
                            lTrace.error(lMessage);
                        } else if (lVerificationResult.containsWarnings()) {
                            lTrace.warn(lMessage);
                        } else {
                            lTrace.info(lMessage);
                        }
                        if (!lVerificationResult.containsErrors()) {
                            DocumentProperties.Builder lProperties = DocumentProperties.Builder.newBuilder();
                            lProperties.setDoctypePublic("MessageData");
                            lProperties.setDoctypeSystem("MessageData.dtd");
                            FileOutputStream lOutputStream = new FileOutputStream(lOutputFileName, false);
                            try {
                                Tools.getXMLTools().writeDocument(lResult.getDocument(), lProperties.build(), (OutputStream)lOutputStream);
                                continue;
                            }
                            finally {
                                lOutputStream.close();
                                continue;
                            }
                        }
                        throw new MojoFailureException("Message resource file '" + lOutputFileName + "' will not be written due to the errors in the source Excel file. For further details please refer to plugin output above.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                XFun.getTrace().info("Skipping transformation of Excel files as none were found.");
            }
        } else {
            String lMessage = "'" + this.resourceGenDirectory + "' is not a valid output directory.";
            XFun.getTrace().info(lMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMessageClasses() {
        XFun.getTrace().info("");
        XFun.getTrace().info("Generating message constants classes");
        File lOutputDirectory = new File(this.sourceGenDirectory);
        if (lOutputDirectory.isDirectory()) {
            ArrayList<String> lResourceFiles = new ArrayList<String>(0);
            lResourceFiles.addAll(this.resolveResourceFiles(this.resourceDirectory, ".xml", this.ignoredResourceFiles));
            lResourceFiles.addAll(this.resolveResourceFiles(this.resourceGenDirectory, ".xml", this.ignoredResourceFiles));
            MessageConstantsGenerator lGenerator = new MessageConstantsGenerator();
            for (String lFileName : lResourceFiles) {
                try {
                    lFileName = new File(lFileName).getCanonicalPath();
                    XFun.getTrace().info("Generating class for message resource '" + lFileName + "'.");
                    lGenerator.generateMessageClass(lFileName, lOutputDirectory.getCanonicalPath());
                }
                catch (IOException e) {
                    XFun.getTrace().info("Exception during generation.");
                    e.printStackTrace(System.out);
                }
                catch (ApplicationException e) {
                    XFun.getTrace().info("Exception during generation.");
                    e.printStackTrace(System.out);
                }
                finally {
                    XFun.getTrace().info("");
                }
            }
        } else {
            String lMessage = "'" + this.sourceGenDirectory + "' is not a valid output directory.";
            XFun.getTrace().info(lMessage);
        }
    }

    private List<String> resolveResourceFiles(String pResourceLocationPath, String pFileExtension, List<String> pExclusionList) {
        List<String> lResourceFiles;
        Assert.assertNotNull((Object)pResourceLocationPath, (String)"pResourceLocationPath");
        Assert.assertNotNull((Object)pFileExtension, (String)"pFileExtension");
        File lMessageResourceLocation = new File(pResourceLocationPath);
        if (lMessageResourceLocation.exists()) {
            if (lMessageResourceLocation.isDirectory()) {
                ArrayList<String> lExtensions = new ArrayList<String>();
                lExtensions.add(pFileExtension);
                FilenameFilter lFileFilter = Tools.getFileTools().createExtensionFilenameFilter(lExtensions, pExclusionList);
                File[] lFiles = lMessageResourceLocation.listFiles(lFileFilter);
                if (lFiles != null) {
                    lResourceFiles = new ArrayList<String>(lFiles.length);
                    for (int i = 0; i < lFiles.length; ++i) {
                        lResourceFiles.add(lFiles[i].getAbsolutePath());
                    }
                } else {
                    lResourceFiles = Collections.emptyList();
                }
            } else {
                lResourceFiles = new ArrayList<String>(1);
                lResourceFiles.add(pResourceLocationPath);
            }
        } else {
            lResourceFiles = Collections.emptyList();
        }
        return lResourceFiles;
    }

    private void runFormatter() throws MojoExecutionException {
        if (this.disableFormatting || this.disableSourceFormatting && this.disableResourceFormatting) {
            this.getLog().info((CharSequence)"Skipping formatting of generated sources and resources as it is disabled in the plugin configuration.");
        } else {
            this.executeImportBeautifierPlugin();
            this.executeImportSorterPlugin();
            this.executeFormatterPlugin();
        }
    }

    private void executeImportBeautifierPlugin() throws MojoExecutionException {
        if (this.disableFormatting || this.disableSourceFormatting) {
            this.getLog().info((CharSequence)"Skipping beautification of imports as it is disbale in the plugin configuration.");
        } else {
            this.getLog().info((CharSequence)"Beautifying imports.");
            List lDependencies = MojoExecutor.dependencies((Dependency[])new Dependency[]{MojoExecutor.dependency((String)"com.anaptecs.jeaf.generator", (String)"jeaf-generator-maven-plugin", (String)XFun.getVersionInfo().getVersionString())});
            Plugin lBeautifierPlugin = MojoExecutor.plugin((String)"org.andromda.maven.plugins", (String)"andromda-beautifier-plugin", (String)"3.4", (List)lDependencies);
            String lBeautifierGoal = MojoExecutor.goal((String)"beautify-imports");
            Xpp3Dom lFormatterConfiguration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"inputDirectory", (String)this.sourceGenDirectory)});
            MojoExecutor.ExecutionEnvironment lExecutionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager);
            MojoExecutor.executeMojo((Plugin)lBeautifierPlugin, (String)lBeautifierGoal, (Xpp3Dom)lFormatterConfiguration, (MojoExecutor.ExecutionEnvironment)lExecutionEnvironment);
        }
    }

    private void executeFormatterPlugin() throws MojoExecutionException {
        if (this.disableFormatting || this.disableSourceFormatting) {
            this.getLog().info((CharSequence)"Skipping formatting of generated source files as it is disbale in the plugin configuration.");
        } else {
            this.getLog().info((CharSequence)"Formatting generated code.");
            List lDependencies = MojoExecutor.dependencies((Dependency[])new Dependency[]{MojoExecutor.dependency((String)"com.anaptecs.jeaf.generator", (String)"jeaf-generator-code-styles", (String)XFun.getVersionInfo().getVersionString())});
            Plugin lFormatterPlugin = MojoExecutor.plugin((String)"net.revelc.code.formatter", (String)"formatter-maven-plugin", (String)"2.16.0", (List)lDependencies);
            String lFormatterGoal = MojoExecutor.goal((String)"format");
            Xpp3Dom lFormatterConfiguration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"configFile", (String)this.javaFormatterStyleFile), MojoExecutor.element((String)"configXmlFile", (String)this.xmlFormatterStyleFile), this.createDirectoryElementConfiguration()});
            MojoExecutor.ExecutionEnvironment lExecutionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager);
            MojoExecutor.executeMojo((Plugin)lFormatterPlugin, (String)lFormatterGoal, (Xpp3Dom)lFormatterConfiguration, (MojoExecutor.ExecutionEnvironment)lExecutionEnvironment);
        }
    }

    private void executeImportSorterPlugin() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Sorting imports.");
        Plugin lFormatterPlugin = MojoExecutor.plugin((String)"net.revelc.code", (String)"impsort-maven-plugin", (String)"1.2.0");
        String lFormatterGoal = MojoExecutor.goal((String)"sort");
        Xpp3Dom lFormatterConfiguration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groups", (String)this.importGroups), MojoExecutor.element((String)"staticGroups", (String)this.staticImportGroups), MojoExecutor.element((String)"removeUnused", (String)Boolean.toString(this.removeUnusedImports)), this.createDirectoryElementConfiguration()});
        MojoExecutor.ExecutionEnvironment lExecutionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager);
        MojoExecutor.executeMojo((Plugin)lFormatterPlugin, (String)lFormatterGoal, (Xpp3Dom)lFormatterConfiguration, (MojoExecutor.ExecutionEnvironment)lExecutionEnvironment);
    }

    private MojoExecutor.Element createDirectoryElementConfiguration() {
        MojoExecutor.Element lElement;
        if (!this.disableSourceFormatting && !this.disableResourceFormatting) {
            lElement = MojoExecutor.element((String)"directories", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.sourceGenDirectory), MojoExecutor.element((String)"directory", (String)this.resourceGenDirectory)});
        } else if (this.disableSourceFormatting) {
            lElement = MojoExecutor.element((String)"directories", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.resourceGenDirectory)});
        } else if (this.disableResourceFormatting) {
            lElement = MojoExecutor.element((String)"directories", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.sourceGenDirectory)});
        } else {
            lElement = null;
            Assert.internalError((String)"Method must not be called if formatting is disabled completely.");
        }
        return lElement;
    }
}

