/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.cache;

import com.anaptecs.jeaf.tools.api.cache.Cache;
import com.anaptecs.jeaf.tools.api.cache.Cacheable;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleObjectCache<K, O extends Cacheable<K>>
implements Cache<K, O> {
    private static final int MILLIS = 1000;
    private final int cacheTTL;
    private Long nextRefresh;
    private Map<K, O> cachedObjects = new HashMap<K, O>();

    public SimpleObjectCache(int pCacheTTL) {
        this.cacheTTL = pCacheTTL;
        this.nextRefresh = System.currentTimeMillis() + (long)(this.cacheTTL * 1000);
    }

    public final synchronized O getCachedObject(K pCacheKey) {
        Check.checkInvalidParameterNull(pCacheKey, (String)"pCacheKey");
        this.cleanIfExpired();
        Cacheable lCacheEntry = (Cacheable)this.cachedObjects.get(pCacheKey);
        if (lCacheEntry != null && this.isCacheEntryExpired(lCacheEntry)) {
            lCacheEntry = null;
            this.cachedObjects.remove(pCacheKey);
        }
        return (O)lCacheEntry;
    }

    public final synchronized void cacheObject(O pCacheObject) {
        Check.checkInvalidParameterNull(pCacheObject, (String)"pCacheObject");
        this.cachedObjects.put(pCacheObject.getCacheKey(), pCacheObject);
    }

    public final synchronized List<K> getAllKeys() {
        this.cleanIfExpired();
        Set<K> lKeySet = this.cachedObjects.keySet();
        return new ArrayList<K>(lKeySet);
    }

    private boolean isCacheEntryExpired(O pCachedObject) {
        Calendar lExpiryDate = pCachedObject.getExpiryDate();
        long lNow = System.currentTimeMillis();
        return lExpiryDate.getTimeInMillis() < lNow;
    }

    public final synchronized List<O> getAllCachedObjects() {
        this.cleanIfExpired();
        return new ArrayList<O>(this.cachedObjects.values());
    }

    private void cleanIfExpired() {
        long lNow = System.currentTimeMillis();
        if (this.nextRefresh != null && lNow > this.nextRefresh) {
            this.cachedObjects.clear();
            this.nextRefresh = lNow + (long)(this.cacheTTL * 1000);
        }
    }
}

