/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.collections;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.collections.CollectionTools;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

@ToolsImplementation(toolsInterface=CollectionTools.class)
public class CollectionToolsImpl
implements CollectionTools {
    public <T> Collection<T> unmodifiableClone(Collection<? extends T> pCollection) {
        Check.checkInvalidParameterNull(pCollection, (String)"pCollection");
        return Collections.unmodifiableCollection(new ArrayList<T>(pCollection));
    }

    public <T> List<T> unmodifiableClone(List<? extends T> pList) {
        Check.checkInvalidParameterNull(pList, (String)"pList");
        return Collections.unmodifiableList(new ArrayList<T>(pList));
    }

    public <K, V> Map<K, V> unmodifiableClone(Map<? extends K, ? extends V> pMap) {
        Check.checkInvalidParameterNull(pMap, (String)"pMap");
        return Collections.unmodifiableMap(new HashMap<K, V>(pMap));
    }

    public <T> Set<T> unmodifiableClone(Set<? extends T> pSet) {
        Check.checkInvalidParameterNull(pSet, (String)"pSet");
        return Collections.unmodifiableSet(new HashSet<T>(pSet));
    }

    public <T> SortedSet<T> unmodifiableClone(SortedSet<? extends T> pSortedSet) {
        Check.checkInvalidParameterNull(pSortedSet, (String)"pSortedSet");
        return Collections.unmodifiableSortedSet(new TreeSet<T>(pSortedSet));
    }

    public <T, S extends T> List<S> filter(Collection<? extends T> pCollection, Class<S> pClass) {
        Check.checkInvalidParameterNull(pCollection, (String)"pCollection");
        Check.checkInvalidParameterNull(pClass, (String)"pClass");
        LinkedList<T> lFilteredList = new LinkedList<T>();
        for (T lNextObject : pCollection) {
            if (!pClass.isInstance(lNextObject)) continue;
            lFilteredList.add(lNextObject);
        }
        return lFilteredList;
    }

    public <T, S extends T> List<S> filter(Map<?, ? extends T> pMap, Class<S> pClass) {
        Check.checkInvalidParameterNull(pMap, (String)"pMap");
        Check.checkInvalidParameterNull(pClass, (String)"pClass");
        LinkedList<T> lFilteredList = new LinkedList<T>();
        for (Map.Entry<?, T> lEntry : pMap.entrySet()) {
            T lValue = lEntry.getValue();
            if (!pClass.isInstance(lValue)) continue;
            lFilteredList.add(lValue);
        }
        return lFilteredList;
    }

    public String toString(Collection<?> pCollection, String pSeparator) {
        Check.checkInvalidParameterNull(pCollection, (String)"pCollection");
        Check.checkInvalidParameterNull((Object)pSeparator, (String)"pSeparator");
        StringBuilder lBuilder = new StringBuilder();
        Iterator<?> lIterator = pCollection.iterator();
        while (lIterator.hasNext()) {
            Object lNextObject = lIterator.next();
            if (lNextObject == null) continue;
            lBuilder.append(lNextObject.toString());
            if (!lIterator.hasNext()) continue;
            lBuilder.append(pSeparator);
        }
        return lBuilder.toString();
    }

    public <T> boolean addAll(Collection<T> pCollection, T ... pElements) {
        boolean lElementsAdded;
        Check.checkInvalidParameterNull(pCollection, (String)"pCollection");
        if (pElements != null && pElements.length > 0) {
            Collections.addAll(pCollection, pElements);
            lElementsAdded = true;
        } else {
            lElementsAdded = false;
        }
        return lElementsAdded;
    }
}

