/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.date;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.date.DateFormatStyle;
import com.anaptecs.jeaf.tools.api.date.DateTools;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@ToolsImplementation(toolsInterface=DateTools.class)
public class DateToolsImpl
implements DateTools {
    private static final int MILLISECONDS_TO_SECONDS = 1000;
    private static final int MILLISECONDS_TO_MINUTES = 60000;
    private static final int MILLISECONDS_TO_HOURS = 3600000;
    private static final int MILLISECONDS_TO_DAYS = 86400000;
    private static final String[] DATE_PATTERN_ORDER = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd"};

    public Calendar newCalendar() {
        return Calendar.getInstance();
    }

    public Calendar newCalendar(long pTimeInMillis) {
        Calendar lCalendar = this.newCalendar();
        lCalendar.setTimeInMillis(pTimeInMillis);
        return lCalendar;
    }

    public Date toDate(int pYear, int pMonth, int pDay) {
        return this.toDate(pYear, pMonth, pDay, 0, 0, 0, 0);
    }

    public Date toDate(int pYear, int pMonth, int pDay, int pHour, int pMiniute, int pSecond) {
        return this.toDate(pYear, pMonth, pDay, pHour, pMiniute, pSecond, 0);
    }

    public Date toDate(int pYear, int pMonth, int pDay, int pHour, int pMinute, int pSecond, int pMilliseconds) {
        StringBuilder lDate = new StringBuilder();
        lDate.append(pYear);
        lDate.append("-");
        lDate.append(pMonth);
        lDate.append("-");
        lDate.append(pDay);
        lDate.append(" ");
        lDate.append(pHour);
        lDate.append(":");
        lDate.append(pMinute);
        lDate.append(":");
        lDate.append(pSecond);
        lDate.append(".");
        lDate.append(pMilliseconds);
        SimpleDateFormat lSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            return lSimpleDateFormat.parse(lDate.toString());
        }
        catch (ParseException e) {
            Assert.internalError((String)"Unable to create date from pattern yyyy-MM-dd HH:mm:ss.SSS.");
            return null;
        }
    }

    public Date toDate(Calendar pCalendar) {
        Check.checkInvalidParameterNull((Object)pCalendar, (String)"pCalendar");
        return new Date(pCalendar.getTimeInMillis());
    }

    public Date toDate(FileTime pFileTime) {
        Check.checkInvalidParameterNull((Object)pFileTime, (String)"pFileTime");
        return new Date(pFileTime.toMillis());
    }

    public Date toDate(String pDate) {
        return this.toDate(pDate, true);
    }

    public Date toDate(String pDate, boolean pStrict) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        int lMaxLoops = pStrict ? 1 : DATE_PATTERN_ORDER.length;
        Date lDate = null;
        String lLastPattern = null;
        ParseException lLastException = null;
        for (int i = 0; i < lMaxLoops; ++i) {
            lLastPattern = DATE_PATTERN_ORDER[i];
            SimpleDateFormat lSimpleDateFormat = new SimpleDateFormat(lLastPattern);
            try {
                lDate = lSimpleDateFormat.parse(pDate);
                break;
            }
            catch (ParseException e) {
                lLastException = e;
                continue;
            }
        }
        if (lDate != null) {
            return lDate;
        }
        throw new JEAFSystemException(ToolsMessages.INVALID_TIMESTAMP_FORMAT, (Throwable)lLastException, new String[]{pDate, lLastPattern});
    }

    public String toString(Date pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        return this.toString(this.toCalendar(pDate));
    }

    public String toString(Calendar pCalendar) {
        Check.checkInvalidParameterNull((Object)pCalendar, (String)"pCalendar");
        String lFormatPattern = this.getStringFormatPattern(pCalendar);
        return this.toString(pCalendar, lFormatPattern);
    }

    private String getStringFormatPattern(Calendar pCalendar) {
        Assert.assertNotNull((Object)pCalendar, (String)"pCalendar");
        String lPattern = pCalendar.get(14) == 0 ? (pCalendar.get(13) == 0 ? (pCalendar.get(11) == 0 && pCalendar.get(12) == 0 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm") : "yyyy-MM-dd HH:mm:ss") : "yyyy-MM-dd HH:mm:ss.SSS";
        return lPattern;
    }

    public String toDateString(Date pDate) {
        return this.toString(pDate, "yyyy-MM-dd");
    }

    public String toDateString(Calendar pDate) {
        return this.toString(pDate, "yyyy-MM-dd");
    }

    public String toDateTimeString(Date pDate) {
        return this.toString(pDate, "yyyy-MM-dd HH:mm:ss");
    }

    public String toDateTimeString(Calendar pDate) {
        return this.toString(pDate, "yyyy-MM-dd HH:mm:ss");
    }

    public String toShortDateTimeString(Date pDate) {
        return this.toString(pDate, "yyyy-MM-dd HH:mm");
    }

    public String toShortDateTimeString(Calendar pDate) {
        return this.toString(pDate, "yyyy-MM-dd HH:mm");
    }

    public String toTimestampString(Date pDate) {
        return this.toString(pDate, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String toTimestampString(Calendar pDate) {
        return this.toString(pDate, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String toLocalizedDateTimeString(Date pDate, Locale pLocale, DateFormatStyle pStyle) {
        String lLocalizedDateTime;
        Check.checkInvalidParameterNull((Object)pLocale, (String)"pLocale");
        Check.checkInvalidParameterNull((Object)pStyle, (String)"pStyle");
        if (pDate != null) {
            DateFormat lDateFormat = DateFormat.getDateTimeInstance(pStyle.getDateFormatStyle(), pStyle.getTimeFormatStyle(), pLocale);
            lLocalizedDateTime = lDateFormat.format(pDate);
        } else {
            lLocalizedDateTime = "";
        }
        return lLocalizedDateTime;
    }

    public String toLocalizedDateTimeString(Calendar pDate, Locale pLocale, DateFormatStyle pStyle) {
        String lLocalizedDateTime = pDate != null ? this.toLocalizedDateTimeString(this.toDate(pDate), pLocale, pStyle) : "";
        return lLocalizedDateTime;
    }

    public String toLocalizedDateTimeString(Date pDate, DateFormatStyle pStyle) {
        return this.toLocalizedDateTimeString(pDate, XFun.getLocaleProvider().getCurrentLocale(), pStyle);
    }

    public String toLocalizedDateTimeString(Calendar pDate, DateFormatStyle pStyle) {
        return this.toLocalizedDateTimeString(pDate, XFun.getLocaleProvider().getCurrentLocale(), pStyle);
    }

    public String toLocalizedDateOnlyString(Date pDate, Locale pLocale, DateFormatStyle pStyle) {
        String lLocalizedDateOnly;
        Check.checkInvalidParameterNull((Object)pLocale, (String)"pLocale");
        Check.checkInvalidParameterNull((Object)pStyle, (String)"pStyle");
        if (pDate != null) {
            DateFormat lDateFormat = DateFormat.getDateInstance(pStyle.getDateFormatStyle(), pLocale);
            lLocalizedDateOnly = lDateFormat.format(pDate);
        } else {
            lLocalizedDateOnly = "";
        }
        return lLocalizedDateOnly;
    }

    public String toLocalizedDateOnlyString(Calendar pDate, Locale pLocale, DateFormatStyle pStyle) {
        String lLocalizedDateOnly = pDate != null ? this.toLocalizedDateOnlyString(this.toDate(pDate), pLocale, pStyle) : "";
        return lLocalizedDateOnly;
    }

    public String toLocalizedDateOnlyString(Date pDate, DateFormatStyle pStyle) {
        return this.toLocalizedDateOnlyString(pDate, XFun.getLocaleProvider().getCurrentLocale(), pStyle);
    }

    public String toLocalizedDateOnlyString(Calendar pDate, DateFormatStyle pStyle) {
        return this.toLocalizedDateOnlyString(pDate, XFun.getLocaleProvider().getCurrentLocale(), pStyle);
    }

    public String toLocalizedTimeOnlyString(Date pDate, Locale pLocale, DateFormatStyle pStyle) {
        String lLocalizedTimeOnly;
        Check.checkInvalidParameterNull((Object)pLocale, (String)"pLocale");
        Check.checkInvalidParameterNull((Object)pStyle, (String)"pStyle");
        if (pDate != null) {
            DateFormat lDateFormat = DateFormat.getTimeInstance(pStyle.getTimeFormatStyle(), pLocale);
            lLocalizedTimeOnly = lDateFormat.format(pDate);
        } else {
            lLocalizedTimeOnly = "";
        }
        return lLocalizedTimeOnly;
    }

    public String toLocalizedTimeOnlyString(Calendar pDate, Locale pLocale, DateFormatStyle pStyle) {
        String lLocalizedTimeOnly = pDate != null ? this.toLocalizedTimeOnlyString(this.toDate(pDate), pLocale, pStyle) : "";
        return lLocalizedTimeOnly;
    }

    public String toLocalizedTimeOnlyString(Date pDate, DateFormatStyle pStyle) {
        return this.toLocalizedTimeOnlyString(pDate, XFun.getLocaleProvider().getCurrentLocale(), pStyle);
    }

    public String toLocalizedTimeOnlyString(Calendar pDate, DateFormatStyle pStyle) {
        return this.toLocalizedTimeOnlyString(pDate, XFun.getLocaleProvider().getCurrentLocale(), pStyle);
    }

    public String toString(Date pDate, String pPattern) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        Check.checkInvalidParameterNull((Object)pPattern, (String)"pPattern");
        SimpleDateFormat lDateFormat = new SimpleDateFormat(pPattern);
        return lDateFormat.format(pDate);
    }

    public String toString(Calendar pDate, String pPattern) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        Check.checkInvalidParameterNull((Object)pPattern, (String)"pPattern");
        return this.toString(this.toDate(pDate), pPattern);
    }

    public Date addDaysToActualDate(int pDays) {
        Calendar cal = this.addDaysToActualCalendar(pDays);
        return this.toDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public Calendar addDaysToActualCalendar(int pDays) {
        Calendar lCalendar = Calendar.getInstance();
        lCalendar.add(5, pDays);
        return lCalendar;
    }

    public int calculateTimeDifferenceInDays(Date pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        long lDiff = pDate.getTime() - System.currentTimeMillis();
        return (int)(lDiff / 86400000L);
    }

    public int calculateTimeDifferenceInDays(Calendar pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        return this.calculateTimeDifferenceInDays(this.toDate(pDate));
    }

    public int calculateTimeDifferenceInHours(Date pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        long lDiff = pDate.getTime() - System.currentTimeMillis();
        return (int)(lDiff / 3600000L);
    }

    public int calculateTimeDifferenceInHours(Calendar pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        return this.calculateTimeDifferenceInHours(this.toDate(pDate));
    }

    public int calculateTimeDifferenceInMinutes(Date pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        long lDiff = pDate.getTime() - System.currentTimeMillis();
        return (int)(lDiff / 60000L);
    }

    public int calculateTimeDifferenceInMinutes(Calendar pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        return this.calculateTimeDifferenceInMinutes(this.toDate(pDate));
    }

    public int calculateTimeDifferenceInSeconds(Date pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        long lDiff = pDate.getTime() - System.currentTimeMillis();
        return (int)(lDiff / 1000L);
    }

    public int calculateTimeDifferenceInSeconds(Calendar pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        return this.calculateTimeDifferenceInSeconds(this.toDate(pDate));
    }

    public Calendar toCalendar(Date pDate) {
        Check.checkInvalidParameterNull((Object)pDate, (String)"pDate");
        Calendar lCalendar = Calendar.getInstance();
        lCalendar.setTime(pDate);
        return lCalendar;
    }

    public Calendar toCalendar(FileTime pFileTime) {
        Check.checkInvalidParameterNull((Object)pFileTime, (String)"pFileTime");
        Calendar lCalendar = Calendar.getInstance();
        lCalendar.setTimeInMillis(pFileTime.toMillis());
        return lCalendar;
    }

    public Calendar toCalendar(String pDateString) {
        Date lDate = this.toDate(pDateString);
        return this.toCalendar(lDate);
    }

    public Calendar toCalendar(String pDate, boolean pStrict) {
        Date lDate = this.toDate(pDate, pStrict);
        return this.toCalendar(lDate);
    }

    public boolean isDateValid(String pDate) {
        boolean lIsValid;
        if (pDate != null) {
            try {
                SimpleDateFormat lDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                lDateFormat.setLenient(false);
                lDateFormat.parse(pDate);
                lIsValid = true;
            }
            catch (ParseException e) {
                lIsValid = false;
            }
        } else {
            lIsValid = false;
        }
        return lIsValid;
    }
}

