/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.encoding;

import com.anaptecs.jeaf.tools.annotations.EncodingToolsConfig;
import com.anaptecs.jeaf.tools.impl.DefaultToolsConfiguration;
import com.anaptecs.jeaf.xfun.api.config.AnnotationBasedConfiguration;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;

public class EncodingToolsConfiguration
extends AnnotationBasedConfiguration<EncodingToolsConfig> {
    public EncodingToolsConfiguration() {
        this("EncodingToolsConfig", "META-INF/JEAF/Tools", true);
    }

    public EncodingToolsConfiguration(String pCustomConfigurationResourceName, String pCustomConfigurationBasePackagePath, boolean pExceptionOnError) {
        super(pCustomConfigurationResourceName, pCustomConfigurationBasePackagePath, pExceptionOnError);
    }

    protected Class<EncodingToolsConfig> getAnnotationClass() {
        return EncodingToolsConfig.class;
    }

    protected String getDefaultConfigurationClass() {
        return DefaultToolsConfiguration.class.getName();
    }

    public EncodingToolsConfig getEmptyConfiguration() {
        return new EncodingToolsConfig(){

            public Class<? extends Annotation> annotationType() {
                return EncodingToolsConfig.class;
            }

            public boolean useSystemDefaultEncoding() {
                return true;
            }

            public String defaultEncoding() {
                return "UTF-8";
            }
        };
    }

    public List<String> checkCustomConfiguration(EncodingToolsConfig pCustomConfiguration) {
        ArrayList<String> lErrors;
        if (!pCustomConfiguration.useSystemDefaultEncoding()) {
            try {
                Charset.forName(pCustomConfiguration.defaultEncoding());
                lErrors = null;
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                lErrors = new ArrayList<String>(1);
                lErrors.add(e.getMessage());
            }
        } else {
            lErrors = null;
        }
        return lErrors;
    }

    public boolean useSystemDefaultEncoding() {
        return ((EncodingToolsConfig)this.theConfig).useSystemDefaultEncoding();
    }

    public Charset getDefaultCharset() {
        Charset lDefaultCharset = ((EncodingToolsConfig)this.theConfig).useSystemDefaultEncoding() ? Charset.defaultCharset() : Charset.forName(((EncodingToolsConfig)this.theConfig).defaultEncoding());
        return lDefaultCharset;
    }
}

