/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.encryption;

import com.anaptecs.jeaf.tools.annotations.EncryptionToolsConfig;
import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.encryption.AESEncrypted;
import com.anaptecs.jeaf.tools.api.encryption.AESKeyLength;
import com.anaptecs.jeaf.tools.api.encryption.AESSecretKey;
import com.anaptecs.jeaf.tools.api.encryption.EncryptionTools;
import com.anaptecs.jeaf.tools.impl.encryption.EncryptionToolsConfiguration;
import com.anaptecs.jeaf.tools.impl.encryption.SecureTokenGenerator;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

@EncryptionToolsConfig
@ToolsImplementation(toolsInterface=EncryptionTools.class)
public class EncryptionToolsImpl
implements EncryptionTools {
    private static final int RSA_HASH_SIZE = 32;
    private static final IvParameterSpec ENCRYPTION_IV = new IvParameterSpec("aao48dh30smsandk".getBytes());
    private static final String AES_TRANSFORMATION = "AES/CTR/PKCS5Padding";
    private Cipher cipher;
    private Cipher decipher;
    private SecretKeySpec secret;
    private Map<Integer, SecureTokenGenerator> secureTokenGenerators = new HashMap<Integer, SecureTokenGenerator>();
    private final AESKeyLength aesDefaultKeyLength;
    private final String rsaAlgorithm;
    private final String rsaTransform;

    public EncryptionToolsImpl() {
        EncryptionToolsConfiguration lConfiguration = new EncryptionToolsConfiguration();
        this.aesDefaultKeyLength = this.resolveAESKeyLength(lConfiguration.getAESDefaultKeyLength());
        this.rsaAlgorithm = lConfiguration.getRSAAlgorithm();
        this.rsaTransform = lConfiguration.getRSATransformation();
    }

    private AESKeyLength resolveAESKeyLength(AESKeyLength pConfiguredKeyLength) {
        try {
            int lSupportedKeyLength = Cipher.getMaxAllowedKeyLength(AES_TRANSFORMATION);
            AESKeyLength lKeyLenght = pConfiguredKeyLength.getKeyLength() <= lSupportedKeyLength ? pConfiguredKeyLength : AESKeyLength.fromKeyLength((int)lSupportedKeyLength);
            return lKeyLenght;
        }
        catch (NoSuchAlgorithmException e) {
            throw new JEAFSystemException(ToolsMessages.UNSUPPORTED_ALGORITHM, (Throwable)e, new String[]{AES_TRANSFORMATION});
        }
    }

    public String encryptAES(String pString, AESKeyLength pKeyLength, int pHashIterations) {
        String lEncryptedString;
        if (pString != null) {
            Arrays.fill(pString.toCharArray(), '\u0000');
            byte[] lBytes = pString.getBytes(StandardCharsets.UTF_8);
            try {
                this.cipher = this.getCipher(pKeyLength, pHashIterations);
                byte[] lEncryptedTextBytes = this.cipher.doFinal(lBytes);
                lEncryptedString = Base64.getEncoder().encodeToString(lEncryptedTextBytes);
            }
            catch (GeneralSecurityException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_ENCRYPT_STRING, (Throwable)e, new String[0]);
            }
        } else {
            lEncryptedString = null;
        }
        return lEncryptedString;
    }

    public AESEncrypted encrypt(String pPlainText, AESSecretKey pKey) {
        AESEncrypted lAESCipher;
        Check.checkInvalidParameterNull((Object)pKey, (String)"pKey");
        if (pPlainText != null) {
            try {
                SecretKey lSecretKey = pKey.getSecretKey();
                Cipher lEncrypter = Cipher.getInstance(AES_TRANSFORMATION);
                lEncrypter.init(1, lSecretKey);
                AlgorithmParameters params = lEncrypter.getParameters();
                byte[] lIV = params.getParameterSpec(IvParameterSpec.class).getIV();
                byte[] lCipherText = lEncrypter.doFinal(pPlainText.getBytes(StandardCharsets.UTF_8));
                lAESCipher = new AESEncrypted(lIV, lCipherText);
            }
            catch (GeneralSecurityException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_ENCRYPT_STRING, (Throwable)e, new String[0]);
            }
        } else {
            lAESCipher = new AESEncrypted((byte[])null, (byte[])null);
        }
        return lAESCipher;
    }

    public String decrypt(AESEncrypted pAESCipher, AESSecretKey pKey) {
        String lPlainText;
        Check.checkInvalidParameterNull((Object)pAESCipher, (String)"pAESCipher");
        Check.checkInvalidParameterNull((Object)pKey, (String)"pKey");
        byte[] lCipherText = pAESCipher.getCipherText();
        if (lCipherText != null) {
            try {
                SecretKey lSecretKey = pKey.getSecretKey();
                Cipher lDecrypter = Cipher.getInstance(AES_TRANSFORMATION);
                lDecrypter.init(2, (Key)lSecretKey, new IvParameterSpec(pAESCipher.getIV()));
                lPlainText = new String(lDecrypter.doFinal(lCipherText), StandardCharsets.UTF_8);
            }
            catch (GeneralSecurityException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_DECRYPT_STRING, (Throwable)e, new String[0]);
            }
        } else {
            lPlainText = null;
        }
        return lPlainText;
    }

    public String decryptAES(String pString, AESKeyLength pKeyLength, int pHashIterations) {
        String lDecryptedString;
        if (pString != null) {
            try {
                byte[] encryptedTextBytes = Base64.getDecoder().decode(pString);
                this.decipher = this.getDecipher(pKeyLength, pHashIterations);
                byte[] decryptedTextBytes = this.decipher.doFinal(encryptedTextBytes);
                lDecryptedString = new String(decryptedTextBytes, StandardCharsets.UTF_8);
            }
            catch (GeneralSecurityException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_DECRYPT_STRING, (Throwable)e, new String[0]);
            }
        } else {
            lDecryptedString = null;
        }
        return lDecryptedString;
    }

    private Cipher getCipher(AESKeyLength pKeyLength, int pHashIterations) throws GeneralSecurityException {
        if (this.cipher == null) {
            this.secret = this.getSecret(pKeyLength, pHashIterations);
            this.cipher = Cipher.getInstance(AES_TRANSFORMATION);
            this.cipher.init(1, (Key)this.secret, ENCRYPTION_IV);
        }
        return this.cipher;
    }

    private SecretKeySpec getSecret(AESKeyLength pKeyLength, int pHashIterations) throws GeneralSecurityException {
        if (this.secret == null) {
            int lKeyLength = pKeyLength.getKeyLength();
            PBEKeySpec lKeySpec = new PBEKeySpec(null, "ctA9sWW0nxEa2kXi".getBytes(), pHashIterations, lKeyLength);
            SecretKeyFactory lSecretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey lSecretKey = lSecretKeyFactory.generateSecret(lKeySpec);
            this.secret = new SecretKeySpec(lSecretKey.getEncoded(), "AES");
            lKeySpec.clearPassword();
        }
        return this.secret;
    }

    private Cipher getDecipher(AESKeyLength pKeyLength, int pHashIterations) throws GeneralSecurityException {
        if (this.decipher == null) {
            this.secret = this.getSecret(pKeyLength, pHashIterations);
            this.decipher = Cipher.getInstance(AES_TRANSFORMATION);
            this.decipher.init(2, (Key)this.secret, ENCRYPTION_IV);
        }
        return this.decipher;
    }

    public byte[] sign(byte[] pMessage, String pAlgorithm, KeyPair pKeyPair) {
        Check.checkInvalidParameterNull((Object)pKeyPair, (String)"pKeyPair");
        return this.sign(pMessage, pAlgorithm, pKeyPair.getPrivate());
    }

    public boolean verify(byte[] pMessage, String pAlgorithm, byte[] pSignature, KeyPair pKeyPair) {
        Check.checkInvalidParameterNull((Object)pKeyPair, (String)"pKeyPair");
        return this.verify(pMessage, pAlgorithm, pSignature, pKeyPair.getPublic());
    }

    public byte[] sign(byte[] pMessage, String pAlgorithm, PrivateKey pPrivateKey) {
        Check.checkInvalidParameterNull((Object)pMessage, (String)"pMessage");
        Check.checkInvalidParameterNull((Object)pAlgorithm, (String)"pAlgorithm");
        Check.checkInvalidParameterNull((Object)pPrivateKey, (String)"pPrivateKey");
        try {
            Signature lSignature = Signature.getInstance(pAlgorithm);
            lSignature.initSign(pPrivateKey);
            lSignature.update(pMessage);
            return lSignature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_SIGN_MESSAGE, (Throwable)e, new String[0]);
        }
    }

    public boolean verify(byte[] pMessage, String pAlgorithm, byte[] pSignature, PublicKey pPublicKey) {
        Check.checkInvalidParameterNull((Object)pMessage, (String)"pMessage");
        Check.checkInvalidParameterNull((Object)pAlgorithm, (String)"pAlgorithm");
        Check.checkInvalidParameterNull((Object)pSignature, (String)"pSignature");
        Check.checkInvalidParameterNull((Object)pPublicKey, (String)"pPublicKey");
        try {
            Signature lSignature = Signature.getInstance(pAlgorithm);
            lSignature.initVerify(pPublicKey);
            lSignature.update(pMessage);
            return lSignature.verify(pSignature);
        }
        catch (GeneralSecurityException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_VERIFY_SIGNATURE, (Throwable)e, new String[0]);
        }
    }

    public KeyPair generateRSAKeyPair(int pKeyLength) {
        return this.generateRSAKeyPair(pKeyLength, this.rsaAlgorithm);
    }

    public KeyPair generateRSAKeyPair(int pKeyLength, String pAlgorithm) {
        Check.checkInvalidParameterNull((Object)pAlgorithm, (String)"pAlgorithm");
        try {
            KeyPairGenerator lKeyGenerator = KeyPairGenerator.getInstance(pAlgorithm);
            lKeyGenerator.initialize(pKeyLength);
            return lKeyGenerator.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_GENERATE_KEY_PAIR, (Throwable)e, new String[0]);
        }
    }

    public PublicKey createRSAPublicKey(byte[] pPublicKeyBytes) {
        return this.createRSAPublicKey(pPublicKeyBytes, this.rsaAlgorithm);
    }

    public PublicKey createRSAPublicKey(byte[] pPublicKeyBytes, String pAlgorithm) {
        Check.checkInvalidParameterNull((Object)pPublicKeyBytes, (String)"pPublicKeyBytes");
        try {
            X509EncodedKeySpec lX509PublicKey = new X509EncodedKeySpec(pPublicKeyBytes);
            KeyFactory lKeyFactory = KeyFactory.getInstance(pAlgorithm);
            return lKeyFactory.generatePublic(lX509PublicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_GENERATE_KEY_FROM_BYTES, (Throwable)e, new String[0]);
        }
    }

    public PrivateKey createRSAPrivateKey(byte[] pPrivateKeyBytes) {
        return this.createRSAPrivateKey(pPrivateKeyBytes, this.rsaAlgorithm);
    }

    public PrivateKey createRSAPrivateKey(byte[] pPrivateKeyBytes, String pAlgorithm) {
        Check.checkInvalidParameterNull((Object)pPrivateKeyBytes, (String)"pPrivateKeyBytes");
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pPrivateKeyBytes);
            KeyFactory lKeyFactory = KeyFactory.getInstance(pAlgorithm);
            return lKeyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_GENERATE_KEY_FROM_BYTES, (Throwable)e, new String[0]);
        }
    }

    public byte[] encryptRSA(byte[] pContent, PublicKey pPublicKey) {
        Check.checkInvalidParameterNull((Object)pContent, (String)"pContent");
        Check.checkInvalidParameterNull((Object)pPublicKey, (String)"pPublicKey");
        int lMaxMessageSize = this.calcluateMaxMessageSize((RSAKey)((Object)pPublicKey));
        if (pContent.length <= lMaxMessageSize) {
            try {
                Cipher lCipher = Cipher.getInstance(this.rsaTransform);
                lCipher.init(1, pPublicKey);
                return lCipher.doFinal(pContent);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_ENCRYPT_STRING, (Throwable)e, new String[0]);
            }
        }
        String[] lParams = new String[]{String.valueOf(pContent.length), String.valueOf(lMaxMessageSize)};
        throw new JEAFSystemException(ToolsMessages.RSA_MAX_MESSAGE_SIZE_EXCEEDED, lParams);
    }

    private int calcluateMaxMessageSize(RSAKey lKey) {
        Assert.assertNotNull((Object)lKey, (String)"lKey");
        int lKeyLength = lKey.getModulus().bitLength();
        return lKeyLength / 8 - 64 - 2;
    }

    public byte[] decryptRSA(byte[] pEncryptedContent, PrivateKey pPrivateKey) {
        try {
            Cipher lCipher = Cipher.getInstance(this.rsaTransform);
            lCipher.init(2, pPrivateKey);
            return lCipher.doFinal(pEncryptedContent);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_DECRYPT_STRING, (Throwable)e, new String[0]);
        }
    }

    public String getKeyAsBase64(Key pKey) {
        return Base64.getEncoder().encodeToString(pKey.getEncoded());
    }

    public String getSecureToken(int pTokenLength) {
        return this.getSecureToken(pTokenLength, false);
    }

    public String getSecureToken(int pTokenLength, boolean pHumanReadable) {
        return this.getSecureTokenGenerator(pTokenLength).getToken(pHumanReadable);
    }

    private SecureTokenGenerator getSecureTokenGenerator(int pTokenLength) {
        return this.secureTokenGenerators.computeIfAbsent(pTokenLength, f -> new SecureTokenGenerator(pTokenLength));
    }

    public AESKeyLength getAESDefaultKeyLength() {
        return this.aesDefaultKeyLength;
    }
}

