/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.encryption;

import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class SecureTokenGenerator {
    private static final int CONST_52 = 52;
    private static final int CONST_26 = 26;
    private static final int CONST_62 = 62;
    private static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private SecureRandom secureNumberGenerator;
    private int tokenLength;

    public SecureTokenGenerator(int pTokenLength) {
        this(pTokenLength, DEFAULT_ALGORITHM);
    }

    public SecureTokenGenerator(int pTokenLength, String pAlgorithm) {
        Check.checkInvalidParameterNull((Object)pAlgorithm, (String)"pAlgorithm");
        if (pTokenLength > 0) {
            this.tokenLength = pTokenLength;
            try {
                this.secureNumberGenerator = SecureRandom.getInstance(pAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new JEAFSystemException(ToolsMessages.UNKNOWN_ALGORITHM, (Throwable)e, new String[]{pAlgorithm});
            }
        } else {
            throw new JEAFSystemException(ToolsMessages.INVALID_TOKEN_LENGTH);
        }
    }

    public String getToken() {
        return this.getToken(false);
    }

    public String getToken(boolean pHumanFriendly) {
        char[] lChars = new char[this.tokenLength];
        for (int i = 0; i < lChars.length; ++i) {
            int lNextInt = this.secureNumberGenerator.nextInt(62);
            lChars[i] = lNextInt < 26 ? (char)((char)lNextInt + 65) : (lNextInt < 52 ? (char)((char)lNextInt + 97 - 26) : (char)((char)lNextInt + 48 - 52));
            if (!pHumanFriendly || lChars[i] != '0' && lChars[i] != 'o' && lChars[i] != 'O') continue;
            lChars[i] = 122;
        }
        return new String(lChars);
    }
}

