/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.file;

import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.collections.CollectionTools;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ExtensionFileFilter
implements FilenameFilter {
    private final List<String> acceptedExtensions;
    private final List<String> exclusionList;

    public ExtensionFileFilter(List<String> pAcceptedExtensions) {
        this(pAcceptedExtensions, null);
    }

    public ExtensionFileFilter(List<String> pAcceptedExtensions, List<String> pExclusionList) {
        this.acceptedExtensions = this.normalizeAcceptedExtensions(pAcceptedExtensions);
        if (pExclusionList != null) {
            this.exclusionList = new ArrayList<String>();
            for (String lNextParam : pExclusionList) {
                StringTokenizer lTokenizer = new StringTokenizer(lNextParam, ";");
                while (lTokenizer.hasMoreTokens()) {
                    this.exclusionList.add(lTokenizer.nextToken().trim());
                }
            }
        } else {
            this.exclusionList = Collections.emptyList();
        }
    }

    private List<String> normalizeAcceptedExtensions(List<String> pAcceptedExtensions) {
        List lExtensions;
        if (pAcceptedExtensions != null) {
            lExtensions = new ArrayList(pAcceptedExtensions.size());
            for (String lNextExtension : pAcceptedExtensions) {
                lExtensions.add(this.normalizeExtension(lNextExtension));
            }
        } else {
            lExtensions = Collections.emptyList();
        }
        return CollectionTools.getCollectionTools().unmodifiableClone(lExtensions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String normalizeExtension(String pExtension) {
        Assert.assertNotNull((Object)pExtension, (String)"pExtension");
        pExtension = pExtension.trim();
        if (pExtension.startsWith("*.")) {
            if (pExtension.length() <= 2) throw new JEAFSystemException(ToolsMessages.INVALID_EXTENSION, new String[]{pExtension});
            return pExtension.substring(1, pExtension.length());
        }
        if (!pExtension.startsWith(".")) throw new JEAFSystemException(ToolsMessages.INVALID_EXTENSION, new String[]{pExtension});
        if (pExtension.length() <= 2) throw new JEAFSystemException(ToolsMessages.INVALID_EXTENSION, new String[]{pExtension});
        return pExtension;
    }

    @Override
    public boolean accept(File pDirectory, String pFilename) {
        Assert.assertNotNull((Object)pFilename, (String)"pFileName");
        boolean lAcceptedExtension = false;
        if (!this.acceptedExtensions.isEmpty()) {
            for (String lExtension : this.acceptedExtensions) {
                lAcceptedExtension = pFilename.toUpperCase().endsWith(lExtension.toUpperCase());
                if (!lAcceptedExtension) continue;
                break;
            }
        } else {
            lAcceptedExtension = true;
        }
        boolean lAcceptedFile = lAcceptedExtension ? !this.exclusionList.contains(pFilename) : false;
        return lAcceptedFile;
    }
}

