/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.file;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.date.DateTools;
import com.anaptecs.jeaf.tools.api.file.FileTools;
import com.anaptecs.jeaf.tools.impl.file.ExtensionFileFilter;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@ToolsImplementation(toolsInterface=FileTools.class)
public final class FileToolsImpl
implements FileTools {
    private static final int BUFFER_SIZE = 8192;
    private static final String EXTENSION_DELIMITER = ".";
    private static final char ZIP_FILE_SEPARATOR = '\\';
    private static final Charset ZIP_CHARSET = Charset.forName("CP437");

    public URL locateResourceURL(String pResourceName) throws IOException {
        Check.checkInvalidParameterNull((Object)pResourceName, (String)"pResourceName");
        ClassLoader lClassLoader = this.getClass().getClassLoader();
        URL lResourceURL = lClassLoader.getResource(pResourceName);
        if (lResourceURL != null) {
            return lResourceURL;
        }
        String lMessage = "Resource '" + pResourceName + "' could not be found within the application class path.";
        throw new IOException(lMessage);
    }

    public InputStream getResourceAsStream(String pResourceName) throws IOException {
        Check.checkInvalidParameterNull((Object)pResourceName, (String)"pResourceName");
        ClassLoader lClassLoader = this.getClass().getClassLoader();
        InputStream lResourceAsStream = lClassLoader.getResourceAsStream(pResourceName);
        if (lResourceAsStream == null) {
            String lMessage = "Resource '" + pResourceName + "' could not be found within the application class path.";
            throw new IOException(lMessage);
        }
        return lResourceAsStream;
    }

    public byte[] getFileContent(File pFile) throws IOException {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        try (FileInputStream lInputStream = new FileInputStream(pFile);){
            byte[] byArray = Tools.getStreamTools().getStreamContent((InputStream)lInputStream);
            return byArray;
        }
    }

    public byte[] getFileContent(String pFileName) throws IOException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        try (FileInputStream lInputStream = new FileInputStream(pFileName);){
            byte[] byArray = Tools.getStreamTools().getStreamContent((InputStream)lInputStream);
            return byArray;
        }
    }

    public byte[] getFileContent(InputStream pInputStream) throws IOException {
        Check.checkInvalidParameterNull((Object)pInputStream, (String)"pInputStream");
        return Tools.getStreamTools().getStreamContent(pInputStream);
    }

    public String getFileContentAsString(File pFile) throws IOException {
        byte[] lFileContent = this.getFileContent(pFile);
        return new String(lFileContent);
    }

    public String getFileContentAsString(String pFileName) throws IOException {
        byte[] lFileContent = this.getFileContent(pFileName);
        return new String(lFileContent);
    }

    public String getFileContentAsString(InputStream pInputStream) throws IOException {
        return Tools.getStreamTools().getStreamContentAsString(pInputStream);
    }

    public void writeFileContent(OutputStream pOutputStream, String pFileContent) throws IOException {
        byte[] lContentAsBytes = pFileContent != null ? pFileContent.getBytes() : null;
        this.writeFileContent(pOutputStream, lContentAsBytes);
    }

    public void writeFileContent(OutputStream pOutputStream, byte[] pFileContent) throws IOException {
        Check.checkInvalidParameterNull((Object)pOutputStream, (String)"pOutputStream");
        if (pFileContent == null) {
            pFileContent = new byte[]{};
        }
        BufferedOutputStream lBufferedOutputStream = pOutputStream instanceof BufferedOutputStream ? (BufferedOutputStream)pOutputStream : new BufferedOutputStream(pOutputStream, 8192);
        lBufferedOutputStream.write(pFileContent);
        lBufferedOutputStream.flush();
    }

    public void writeFileContent(String pFileName, byte[] pFileContent) throws IOException {
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        try (FileOutputStream lOutputStream = new FileOutputStream(pFileName);){
            this.writeFileContent((OutputStream)lOutputStream, pFileContent);
        }
    }

    public void writeFileContent(File pFile, byte[] pFileContent) throws IOException {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        try (FileOutputStream lOutputStream = new FileOutputStream(pFile);){
            this.writeFileContent((OutputStream)lOutputStream, pFileContent);
        }
    }

    public void writeFileContent(File pFile, String pFileContent) throws IOException {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        try (FileOutputStream lOutputStream = new FileOutputStream(pFile);){
            this.writeFileContent((OutputStream)lOutputStream, pFileContent);
        }
    }

    public void writeFileContent(String pFileName, String pFileContent) throws IOException {
        byte[] lContentAsBytes = pFileContent != null ? pFileContent.getBytes() : null;
        this.writeFileContent(pFileName, lContentAsBytes);
    }

    public long copyFile(String pSource, String pDestination) throws IOException {
        Check.checkInvalidParameterNull((Object)pSource, (String)"pSource");
        Check.checkInvalidParameterNull((Object)pDestination, (String)"pDestination");
        return this.copyFile(new File(pSource), new File(pDestination));
    }

    public long copyFile(File pSource, File pDestination) throws IOException {
        Check.checkInvalidParameterNull((Object)pSource, (String)"pSource");
        Check.checkInvalidParameterNull((Object)pDestination, (String)"pDestination");
        long lStart = System.nanoTime();
        boolean lFileCreated = pDestination.createNewFile();
        if (lFileCreated) {
            long lTransferedBytes = 0L;
            try (FileInputStream lFileInputStream = new FileInputStream(pSource);
                 FileChannel lSourceChannel = lFileInputStream.getChannel();
                 FileOutputStream lFileOutputStream = new FileOutputStream(pDestination);
                 FileChannel lDestinationChannel = lFileOutputStream.getChannel();){
                lTransferedBytes = lDestinationChannel.transferFrom(lSourceChannel, 0L, lSourceChannel.size());
            }
            long lEnd = System.nanoTime();
            Tools.getStreamTools().traceIOSummary(pSource.getName(), lTransferedBytes, lEnd - lStart, ToolsMessages.TRANSFERED_FILE_CONTENT);
            return lTransferedBytes;
        }
        throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CREATE_NEW_FILE, new String[]{pDestination.getName()});
    }

    public long copyContent(String pFileName, InputStream pInputStream, OutputStream pOutputStream, boolean pCloseStreams) throws IOException {
        return Tools.getStreamTools().copyContent(pFileName, pInputStream, pOutputStream, pCloseStreams);
    }

    public long copyContent(String pFileName, InputStream pInputStream, OutputStream pOutputStream, boolean pCloseStreams, long pMaxBytes) throws IOException {
        return Tools.getStreamTools().copyContent(pFileName, pInputStream, pOutputStream, pCloseStreams, pMaxBytes);
    }

    public long copyContent(String pFileName, InputStream pInputStream, RandomAccessFile pFile, boolean pClose) throws IOException {
        return this.copyContent(pFileName, pInputStream, pFile, pClose, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyContent(String pFileName, InputStream pInputStream, RandomAccessFile pFile, boolean pClose, long pMaxBytes) throws IOException {
        Assert.assertNotNull((Object)pInputStream, (String)"pInputStream");
        Assert.assertNotNull((Object)pFile, (String)"pFile");
        long lStart = System.nanoTime();
        try {
            int lLength;
            byte[] lBuffer = new byte[8192];
            long lBytes = 0L;
            pFile.setLength(0L);
            while ((lLength = pInputStream.read(lBuffer)) != -1) {
                pFile.write(lBuffer, 0, lLength);
                if ((lBytes += (long)lLength) <= pMaxBytes) continue;
                throw new JEAFSystemException(ToolsMessages.MAX_BYTES_EXCEEDED, new String[]{Long.toString(pMaxBytes)});
            }
            long lEnd = System.nanoTime();
            Tools.getStreamTools().traceIOSummary(pFileName, lBytes, lEnd - lStart, ToolsMessages.TRANSFERED_FILE_CONTENT);
            long l = lBytes;
            return l;
        }
        finally {
            if (pClose) {
                pInputStream.close();
                pFile.close();
            }
        }
    }

    public long calculateDirectorySize(File pDirectory) {
        Check.checkInvalidParameterNull((Object)pDirectory, (String)"pDirectory");
        if (pDirectory.isDirectory()) {
            long lSize = 0L;
            File[] lFiles = pDirectory.listFiles();
            if (lFiles != null) {
                for (int i = 0; i < lFiles.length; ++i) {
                    File lFile = lFiles[i];
                    if (lFile.isDirectory()) {
                        lSize += this.calculateDirectorySize(lFile);
                        continue;
                    }
                    lSize += lFile.length();
                }
                return lSize;
            }
            throw new JEAFSystemException(ToolsMessages.CALCULATION_OF_DIR_SIZE_FAILED, new String[]{pDirectory.getAbsolutePath()});
        }
        throw new JEAFSystemException(ToolsMessages.CALCULATION_OF_DIR_SIZE_FAILED, new String[]{pDirectory.getAbsolutePath()});
    }

    public void createDirectory(String pDirectoryPath) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pDirectoryPath, (String)"pDirectoryPath");
        this.createDirectory(new File(pDirectoryPath));
    }

    public void createDirectory(Path pDirectoryPath) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pDirectoryPath, (String)"pDirectoryPath");
        this.createDirectory(pDirectoryPath.toFile());
    }

    public void createDirectory(File pDirectory) throws JEAFSystemException {
        boolean lSuccessful;
        Check.checkInvalidParameterNull((Object)pDirectory, (String)"pDirectory");
        if (!pDirectory.exists() && !(lSuccessful = pDirectory.mkdirs())) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CREATE_DIRECTORY, new String[]{pDirectory.getAbsolutePath()});
        }
    }

    public void delete(String pFilePath) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        this.delete(new File(pFilePath));
    }

    public void delete(Path pFilePath) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        this.delete(pFilePath.toFile());
    }

    public void delete(File pFile) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        try {
            Files.delete(pFile.toPath());
        }
        catch (IOException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_DELETE_FILE, (Throwable)e, new String[]{pFile.getName()});
        }
    }

    public boolean tryDelete(String pFilePath) {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        return this.tryDelete(new File(pFilePath));
    }

    public boolean tryDelete(Path pFilePath) {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        return this.tryDelete(pFilePath.toFile());
    }

    public boolean tryDelete(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        return pFile.delete();
    }

    public void deleteRecursive(String pFilePath) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        this.deleteRecursive(new File(pFilePath));
    }

    public void deleteRecursive(Path pFilePath) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        this.deleteRecursive(pFilePath.toFile());
    }

    public void deleteRecursive(File pFile) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        File[] lChildElements = pFile.listFiles();
        if (lChildElements != null) {
            for (int i = 0; i < lChildElements.length; ++i) {
                this.deleteRecursive(lChildElements[i]);
            }
        }
        try {
            Files.delete(pFile.toPath());
        }
        catch (IOException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_DELETE_FILE, new String[]{pFile.getAbsolutePath()});
        }
    }

    public boolean tryDeleteRecursive(String pFilePath, boolean pContinue) {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        return this.tryDeleteRecursive(new File(pFilePath), pContinue);
    }

    public boolean tryDeleteRecursive(Path pFilePath, boolean pContinue) {
        Check.checkInvalidParameterNull((Object)pFilePath, (String)"pFilePath");
        return this.tryDeleteRecursive(pFilePath.toFile(), pContinue);
    }

    public boolean tryDeleteRecursive(File pFile, boolean pContinue) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        boolean lDeleteSucccessful = true;
        File[] lChildElements = pFile.listFiles();
        if (lChildElements != null) {
            for (int i = 0; i < lChildElements.length; ++i) {
                boolean lDeleted = this.tryDeleteRecursive(lChildElements[i], pContinue);
                boolean bl = lDeleteSucccessful = lDeleteSucccessful && lDeleted;
                if (!lDeleteSucccessful && !pContinue) break;
            }
        }
        if (lDeleteSucccessful || pContinue) {
            boolean lDeleted = pFile.delete();
            lDeleteSucccessful = lDeleteSucccessful && lDeleted;
        }
        return lDeleteSucccessful;
    }

    public void extractZipFile(String pZipFilePath, String pExtractDirectoryPath, long pMaxSize) throws IOException {
        this.extractZipFile(new File(pZipFilePath), new File(pExtractDirectoryPath), pMaxSize);
    }

    public void extractZipFile(File pZipFile, File pExtractDirectory, long pMaxExtractSize) throws IOException {
        Check.checkInvalidParameterNull((Object)pZipFile, (String)"pZipFile");
        Check.checkInvalidParameterNull((Object)pExtractDirectory, (String)"pExtractDirectory");
        long lStart = System.nanoTime();
        try (ZipFile lZipFile = new ZipFile(pZipFile, ZIP_CHARSET);){
            long lBytesLeft = pMaxExtractSize;
            String lCanonicalExtractDirectory = pExtractDirectory.getCanonicalPath();
            ArrayList<File> lCreatedFiles = new ArrayList<File>(lZipFile.size());
            Enumeration<? extends ZipEntry> lZipFileEntries = lZipFile.entries();
            while (lZipFileEntries.hasMoreElements()) {
                ZipEntry lZipEntry = lZipFileEntries.nextElement();
                String lCurrentEntryName = lZipEntry.getName().replace('\\', File.separatorChar);
                File lTempFile = new File(pExtractDirectory, lCurrentEntryName);
                String lNewFileCanonicalPath = lTempFile.getCanonicalPath();
                File lNewFile = new File(lNewFileCanonicalPath);
                if (lNewFileCanonicalPath.startsWith(lCanonicalExtractDirectory + File.separator)) {
                    File lEntryParent = lNewFile.getParentFile();
                    lEntryParent.mkdirs();
                    if (lZipEntry.isDirectory()) continue;
                    lCreatedFiles.add(lNewFile);
                    lBytesLeft = this.extractZipEntry(lZipFile, lZipEntry, lNewFile, lBytesLeft, pMaxExtractSize, lCreatedFiles);
                    continue;
                }
                throw new JEAFSystemException(ToolsMessages.PREVENTED_DIRECTORY_TRAVERSAL_ATTACK, new String[]{pZipFile.getName(), lNewFileCanonicalPath});
            }
            long lEnd = System.nanoTime();
            Tools.getStreamTools().traceIOSummary(pZipFile.getName(), pZipFile.length(), lEnd - lStart, ToolsMessages.EXTRACTED_FILE);
        }
    }

    private long extractZipEntry(ZipFile pZipFile, ZipEntry pZipEntry, File pOutputFile, long pMaxBytes, long pMaxExtractSize, List<File> pCreatedFiles) throws IOException {
        InputStream lInputStream = pZipFile.getInputStream(pZipEntry);
        FileOutputStream lFileOutputStream = new FileOutputStream(pOutputFile);
        BufferedOutputStream lOutputStream = new BufferedOutputStream(lFileOutputStream, 8192);
        try {
            long lBytesTransfered = this.copyContent(pZipEntry.getName(), lInputStream, lOutputStream, true, pMaxBytes);
            return pMaxBytes - lBytesTransfered;
        }
        catch (JEAFSystemException e) {
            for (File lNextFile : pCreatedFiles) {
                this.tryDelete(lNextFile);
            }
            ErrorCode lErrorCode = ToolsMessages.ZIP_EXTRACTION_ABORTED;
            throw new JEAFSystemException(lErrorCode, (Throwable)e, new String[]{pZipFile.getName(), Long.toString(pMaxExtractSize)});
        }
        catch (IOException e) {
            for (File lNextFile : pCreatedFiles) {
                this.tryDelete(lNextFile);
            }
            throw e;
        }
    }

    public String getBaseName(Path pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        return this.getBaseName(pFile.toString());
    }

    public String getBaseName(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        return this.getBaseName(pFile.getName());
    }

    public String getBaseName(String pFilename) {
        Check.checkInvalidParameterNull((Object)pFilename, (String)"pFilename");
        int lLastIndex = pFilename.lastIndexOf(EXTENSION_DELIMITER);
        String lBaseName = lLastIndex > 0 ? pFilename.substring(0, lLastIndex) : null;
        return lBaseName;
    }

    public String getExtension(Path pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        return this.getExtension(pFile.toString());
    }

    public String getExtension(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        return this.getExtension(pFile.getName());
    }

    public String getExtension(String pFilename) {
        Check.checkInvalidParameterNull((Object)pFilename, (String)"pFilename");
        int lLastIndex = pFilename.lastIndexOf(EXTENSION_DELIMITER);
        String lExtension = lLastIndex >= 0 && pFilename.length() > lLastIndex + 1 ? pFilename.substring(lLastIndex + 1) : null;
        return lExtension;
    }

    public Date getCreationTime(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        BasicFileAttributes lFileAttributes = this.getFileAttributes(pFile);
        return DateTools.getDateTools().toDate(lFileAttributes.creationTime());
    }

    public Date getLastModificationTime(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        BasicFileAttributes lFileAttributes = this.getFileAttributes(pFile);
        return DateTools.getDateTools().toDate(lFileAttributes.lastModifiedTime());
    }

    public Date getLastAccessTime(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        BasicFileAttributes lFileAttributes = this.getFileAttributes(pFile);
        return DateTools.getDateTools().toDate(lFileAttributes.lastAccessTime());
    }

    public Calendar getCreation(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        BasicFileAttributes lFileAttributes = this.getFileAttributes(pFile);
        return DateTools.getDateTools().toCalendar(lFileAttributes.creationTime());
    }

    public Calendar getLastModification(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        BasicFileAttributes lFileAttributes = this.getFileAttributes(pFile);
        return DateTools.getDateTools().toCalendar(lFileAttributes.lastModifiedTime());
    }

    public Calendar getLastAccess(File pFile) {
        Check.checkInvalidParameterNull((Object)pFile, (String)"pFile");
        BasicFileAttributes lFileAttributes = this.getFileAttributes(pFile);
        return DateTools.getDateTools().toCalendar(lFileAttributes.lastAccessTime());
    }

    private BasicFileAttributes getFileAttributes(File pFile) throws JEAFSystemException {
        try {
            return Files.readAttributes(pFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            ErrorCode lErrorCode = ToolsMessages.UNABLE_TO_ACCESS_FILE_ATTRIBUTES;
            throw new JEAFSystemException(lErrorCode, (Throwable)e, new String[]{pFile.getAbsolutePath()});
        }
    }

    public FilenameFilter createExtensionFilenameFilter(List<String> pAcceptedExtensions) {
        return new ExtensionFileFilter(pAcceptedExtensions);
    }

    public FilenameFilter createExtensionFilenameFilter(List<String> pAcceptedExtensions, List<String> pExclusionList) {
        return new ExtensionFileFilter(pAcceptedExtensions, pExclusionList);
    }

    public List<File> listFiles(File pDirectory) {
        return this.listFiles(pDirectory, null);
    }

    public List<File> listFiles(File pDirectory, List<String> pAcceptedExtensions, List<String> pExclusionList) {
        FilenameFilter lFileFilter = this.createExtensionFilenameFilter(pAcceptedExtensions, pExclusionList);
        return this.listFiles(pDirectory, lFileFilter);
    }

    public List<File> listFiles(File pDirectory, FilenameFilter pFileFilter) {
        Check.checkInvalidParameterNull((Object)pDirectory, (String)"pDirectory");
        if (pDirectory.isDirectory()) {
            File[] lFiles = pFileFilter != null ? pDirectory.listFiles(pFileFilter) : pDirectory.listFiles();
            return Arrays.asList(lFiles);
        }
        throw new JEAFSystemException(ToolsMessages.NOT_A_DIRECTORY, new String[]{pDirectory.getAbsolutePath()});
    }

    public List<String> listFiles(String pDirectoryName) {
        return this.listFiles(pDirectoryName, null);
    }

    public List<String> listFiles(String pDirectoryName, List<String> pAcceptedExtensions, List<String> pExclusionList) {
        FilenameFilter lFileFilter = this.createExtensionFilenameFilter(pAcceptedExtensions, pExclusionList);
        return this.listFiles(pDirectoryName, lFileFilter);
    }

    public List<String> listFiles(String pDirectoryName, FilenameFilter pFileFilter) {
        Check.checkInvalidParameterNull((Object)pDirectoryName, (String)"pDirectoryName");
        File lCurrentFile = null;
        try {
            List<File> lFiles = this.listFiles(new File(pDirectoryName), pFileFilter);
            ArrayList<String> lFileNames = new ArrayList<String>(lFiles.size());
            Iterator<File> iterator = lFiles.iterator();
            while (iterator.hasNext()) {
                File lNextFile;
                lCurrentFile = lNextFile = iterator.next();
                lFileNames.add(lNextFile.getCanonicalPath());
            }
            return lFileNames;
        }
        catch (IOException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CREATE_CANONICAL_PATH, (Throwable)e, new String[]{lCurrentFile.getAbsolutePath(), e.getMessage()});
        }
    }
}

