/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.locale;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.locale.LocaleTools;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

@ToolsImplementation(toolsInterface=LocaleTools.class)
public final class LocaleToolsImpl
implements LocaleTools {
    private final Map<String, Locale> countries;
    public static final String LOCALE_SEPERATOR = "_";

    public LocaleToolsImpl() {
        ResourceBundle lProperties = ResourceBundle.getBundle("PrimaryLanguagesALPHA-2");
        HashMap<String, String> lPrimaryLanguages = new HashMap<String, String>();
        Enumeration<String> lKeys = lProperties.getKeys();
        while (lKeys.hasMoreElements()) {
            String lNextKey = lKeys.nextElement();
            lPrimaryLanguages.put(lNextKey, lProperties.getString(lNextKey));
        }
        HashMap<String, Locale> lCountries = new HashMap<String, Locale>();
        for (Locale lNext : Locale.getAvailableLocales()) {
            String lCountryCode = lNext.getCountry();
            if (lCountryCode.isEmpty()) continue;
            String lPrimaryLanguage = (String)lPrimaryLanguages.get(lCountryCode);
            if (lPrimaryLanguage != null) {
                if (!lPrimaryLanguage.equals(lNext.getLanguage())) continue;
                lCountries.put(lCountryCode, lNext);
                try {
                    lCountries.put(lNext.getISO3Country(), lNext);
                }
                catch (MissingResourceException missingResourceException) {}
                continue;
            }
            XFun.getTrace().debug("No primary language found for " + lNext.toString());
            lCountries.put(lCountryCode, lNext);
            try {
                lCountries.put(lNext.getISO3Country(), lNext);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.countries = Collections.unmodifiableMap(lCountries);
    }

    public Locale createLocale(String pLocaleString) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pLocaleString, (String)"pLocaleString");
        StringTokenizer lTokenizer = new StringTokenizer(pLocaleString, LOCALE_SEPERATOR, true);
        int lTokenCount = lTokenizer.countTokens();
        int lMaxTokens = 5;
        if (lTokenCount <= 5) {
            String[] lTokens = new String[]{"", "", ""};
            int i = 0;
            while (lTokenizer.hasMoreTokens()) {
                String lNextToken = lTokenizer.nextToken();
                if (!LOCALE_SEPERATOR.equals(lNextToken)) {
                    lTokens[i] = lNextToken;
                    continue;
                }
                ++i;
            }
            String lLanguage = lTokens[0].trim();
            String lCountry = lTokens[1].trim();
            String lVariant = lTokens[2].trim();
            if (lLanguage.length() > 0 || lCountry.length() > 0) {
                return new Locale(lLanguage, lCountry, lVariant);
            }
            String[] lParams = new String[]{pLocaleString};
            throw new JEAFSystemException(ToolsMessages.LANGUAGE_OR_COUNTRY_MISSING, lParams);
        }
        String[] lParams = new String[]{pLocaleString};
        throw new JEAFSystemException(ToolsMessages.INVALID_LOCALE_STRING_FORMAT, lParams);
    }

    public Locale getLocaleFromCountryCode(String pCountryCode) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pCountryCode, (String)"pCountryCode");
        Locale lCountry = this.countries.get(pCountryCode);
        if (lCountry != null) {
            return lCountry;
        }
        throw new JEAFSystemException(ToolsMessages.INVALID_COUNTRY_CODE, new String[]{pCountryCode});
    }

    public Locale getCurrentLocale() {
        return XFun.getLocaleProvider().getCurrentLocale();
    }
}

