/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.monitoring;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.monitoring.CounterInfo;
import com.anaptecs.jeaf.tools.api.monitoring.GaugeInfo;
import com.anaptecs.jeaf.tools.api.monitoring.MonitoringToken;
import com.anaptecs.jeaf.tools.api.monitoring.MonitoringTools;
import com.anaptecs.jeaf.tools.api.monitoring.TimerInfo;
import com.anaptecs.jeaf.tools.api.monitoring.TimerSample;
import com.anaptecs.jeaf.tools.impl.monitoring.CounterInfoImpl;
import com.anaptecs.jeaf.tools.impl.monitoring.EmptyMonitoringTokenImpl;
import com.anaptecs.jeaf.tools.impl.monitoring.GaugeInfoImpl;
import com.anaptecs.jeaf.tools.impl.monitoring.MonitoringToolsConfiguration;
import com.anaptecs.jeaf.tools.impl.monitoring.TimerInfoImpl;
import com.anaptecs.jeaf.tools.impl.monitoring.TimerSampleImpl;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.RequiredSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

@ToolsImplementation(toolsInterface=MonitoringTools.class)
public class MonitoringToolsImpl
implements MonitoringTools {
    private final MeterRegistry meterRegistry;
    private final TimeUnit defaultTimeUnit;

    public MonitoringToolsImpl() {
        this(new MonitoringToolsConfiguration());
    }

    public MonitoringToolsImpl(MonitoringToolsConfiguration pConfiguration) {
        this.meterRegistry = pConfiguration.loadMeterRegistryFactory().createMeterRegistry(pConfiguration.getDomain());
        this.defaultTimeUnit = pConfiguration.getDefaultTimeUnit();
    }

    public TimeUnit getDefaultTimeUnit() {
        return this.defaultTimeUnit;
    }

    public long getTimestamp() {
        return this.getTimestamp(this.defaultTimeUnit);
    }

    public long getTimestamp(TimeUnit pTimeUnit) {
        long lTimestamp;
        Check.checkInvalidParameterNull((Object)((Object)pTimeUnit), (String)"pTimeUnit");
        switch (pTimeUnit) {
            case NANOSECONDS: 
            case MICROSECONDS: {
                lTimestamp = pTimeUnit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
                break;
            }
            default: {
                lTimestamp = pTimeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
        return lTimestamp;
    }

    private Timer getTimer(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pTimerTags) {
        return this.meterRegistry.timer(pName, this.convertTags(pTimerTags));
    }

    public TimerSample newTimerSample(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pTimerTags) {
        return this.newTimerSample(pName, this.defaultTimeUnit, pTimerTags);
    }

    public TimerSample newTimerSample(String pName, TimeUnit pTimeUnit, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pTimerTags) {
        long lStart = this.getTimestamp(pTimeUnit);
        return new TimerSampleImpl(pName, pTimerTags, lStart, pTimeUnit);
    }

    public void recordTimerSample(TimerSample pTimerSample) {
        Check.checkInvalidParameterNull((Object)pTimerSample, (String)"pTimerSample");
        TimeUnit lTimeUnit = pTimerSample.getTimeUnit();
        long lStop = this.getTimestamp(lTimeUnit);
        Timer lTimer = this.getTimer(pTimerSample.getTimerName(), pTimerSample.getTimerTags());
        lTimer.record(lStop - pTimerSample.getStartTimestamp(), lTimeUnit);
    }

    public TimerInfo getTimerInfo(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pTimerTags) {
        Timer lTimer = this.getTimer(pName, pTimerTags);
        return new TimerInfoImpl(lTimer);
    }

    public void incrementCounter(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pCounterTags) {
        this.getCounter(pName, pCounterTags).increment();
    }

    public CounterInfo getCounterInfo(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pCounterTags) {
        Counter lCounter = this.getCounter(pName, pCounterTags);
        return new CounterInfoImpl(lCounter);
    }

    private Counter getCounter(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pCounterTags) {
        return this.meterRegistry.counter(pName, this.convertTags(pCounterTags));
    }

    public <T> void monitorObject(T pMonitoredObject, ToDoubleFunction<T> pValueFunction, String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pTags) {
        Gauge.Builder lBuilder = Gauge.builder((String)pName, pMonitoredObject, pValueFunction);
        lBuilder.tags(this.convertTags(pTags));
        lBuilder.register(this.meterRegistry);
    }

    public GaugeInfo getGaugeInfo(String pName, com.anaptecs.jeaf.tools.api.monitoring.Tag ... pTags) {
        RequiredSearch lSearch = this.meterRegistry.get(pName);
        lSearch.tags(this.convertTags(pTags));
        Gauge lGauge = lSearch.gauge();
        return new GaugeInfoImpl(lGauge);
    }

    public MonitoringToken getMonitoringToken() {
        return new EmptyMonitoringTokenImpl();
    }

    private List<Tag> convertTags(com.anaptecs.jeaf.tools.api.monitoring.Tag[] pTags) {
        ArrayList<Tag> lMicrometerTags;
        if (pTags != null) {
            lMicrometerTags = new ArrayList<Tag>(pTags.length);
            for (com.anaptecs.jeaf.tools.api.monitoring.Tag lNext : pTags) {
                lMicrometerTags.add(Tag.of((String)lNext.getKey(), (String)lNext.getValue()));
            }
        } else {
            lMicrometerTags = null;
        }
        return lMicrometerTags;
    }
}

