/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.network;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.network.NetworkingTools;
import com.anaptecs.jeaf.tools.impl.network.Inet4AddressComparator;
import com.anaptecs.jeaf.tools.impl.network.NetworkingToolsConfiguration;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.info.OperatingSystem;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

@ToolsImplementation(toolsInterface=NetworkingTools.class)
public class NetworkingToolsImpl
implements NetworkingTools {
    private int pingTimeout;

    public NetworkingToolsImpl() {
        NetworkingToolsConfiguration lConfiguration = new NetworkingToolsConfiguration();
        this.pingTimeout = lConfiguration.getPingTimeout();
    }

    public String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_RESOLVE_NETWORK_INFO, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    public List<Inet4Address> getIPv4Addresses() {
        try {
            List<NetworkInterface> lNetworkInterfaces = this.getNetworkInterfaces();
            ArrayList<Inet4Address> lMyIPs = new ArrayList<Inet4Address>(lNetworkInterfaces.size());
            for (NetworkInterface lNextInterface : lNetworkInterfaces) {
                Enumeration<InetAddress> lAddresses = lNextInterface.getInetAddresses();
                while (lAddresses.hasMoreElements()) {
                    InetAddress lNextIP = lAddresses.nextElement();
                    if (!(lNextIP instanceof Inet4Address)) continue;
                    lMyIPs.add((Inet4Address)lNextIP);
                }
            }
            Collections.sort(lMyIPs, new Inet4AddressComparator());
            return lMyIPs;
        }
        catch (SocketException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_RESOLVE_NETWORK_INFO, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    public List<String> getHardwareAddresses() {
        try {
            List<NetworkInterface> lNetworkInterfaces = this.getNetworkInterfaces();
            ArrayList<String> lMACs = new ArrayList<String>(lNetworkInterfaces.size());
            for (NetworkInterface lNextInterface : lNetworkInterfaces) {
                byte[] lMAC = lNextInterface.getHardwareAddress();
                if (lMAC == null || lMAC.length > 6) continue;
                StringBuilder lStringBuilder = new StringBuilder(18);
                for (byte b : lMAC) {
                    if (lStringBuilder.length() > 0) {
                        lStringBuilder.append(':');
                    }
                    lStringBuilder.append(String.format("%02x", b));
                }
                lMACs.add(lStringBuilder.toString().toUpperCase());
            }
            return lMACs;
        }
        catch (SocketException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_RESOLVE_NETWORK_INFO, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    public boolean isReachable(String pHostAddress) {
        return this.isReachable(pHostAddress, this.pingTimeout);
    }

    public boolean isReachable(String pHostAddress, int pTimeout) {
        try {
            InetAddress lHost = InetAddress.getByName(pHostAddress);
            boolean lReachable = lHost.isReachable(pTimeout);
            if (XFun.getInfoProvider().getOperatingSystem() == OperatingSystem.LINUX && !lReachable) {
                XFun.getTrace().warn("Host " + pHostAddress + " seems to be not available, but please be aware that on Linux root privileges are required to execute ping.");
            }
            return lReachable;
        }
        catch (UnknownHostException e) {
            throw new JEAFSystemException(ToolsMessages.UNKNOWN_HOST, (Throwable)e, new String[]{e.getMessage()});
        }
        catch (IOException e) {
            throw new JEAFSystemException(ToolsMessages.NETWORK_ERROR_ON_PING, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    public URL toURL(String pURLString) {
        Check.checkInvalidParameterNull((Object)pURLString, (String)"pURLString");
        try {
            return new URL(pURLString);
        }
        catch (MalformedURLException e) {
            throw new JEAFSystemException(ToolsMessages.INVALID_URL, (Throwable)e, new String[]{pURLString});
        }
    }

    private List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> lInterfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<NetworkInterface> lNetworkInterfaces = new ArrayList<NetworkInterface>();
        while (lInterfaces.hasMoreElements()) {
            NetworkInterface lNextInterface = lInterfaces.nextElement();
            if (lNextInterface.isLoopback() || lNextInterface.isPointToPoint() || lNextInterface.isVirtual() || !lNextInterface.isUp()) continue;
            lNetworkInterfaces.add(lNextInterface);
        }
        return lNetworkInterfaces;
    }
}

