/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.performance;

import com.anaptecs.jeaf.tools.api.performance.Stopwatch;
import com.anaptecs.jeaf.tools.api.performance.StopwatchResult;
import com.anaptecs.jeaf.tools.api.performance.TimePrecision;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;

public class StopwatchImpl
implements Stopwatch {
    private final String name;
    private long count;
    private final TimePrecision precision;
    private long start;
    private long stop;

    public StopwatchImpl(String pName, TimePrecision pPrecision) {
        Check.checkInvalidParameterNull((Object)pPrecision, (String)pName);
        this.name = pName;
        this.precision = pPrecision;
    }

    public Stopwatch start() {
        this.start(0L);
        return this;
    }

    public Stopwatch start(long pCount) {
        this.count = pCount;
        this.start = System.nanoTime();
        this.stop = 0L;
        return this;
    }

    public void stop() {
        if (this.isRunning()) {
            this.stop = System.nanoTime();
        }
    }

    public void stop(long pCount) {
        if (this.isRunning()) {
            this.count = pCount;
            this.stop();
        }
    }

    public void stopAndTrace() {
        if (this.isRunning()) {
            this.stop();
            this.traceResult();
        }
    }

    public void stopAndTrace(long pCount) {
        if (this.isRunning()) {
            this.count = pCount;
            this.stopAndTrace();
        }
    }

    public boolean isRunning() {
        return this.start != 0L && this.stop == 0L;
    }

    public StopwatchResult getResult() {
        if (this.isRunning()) {
            this.stop();
        }
        long lDuration = (this.stop - this.start) / this.precision.getDurationDivisor();
        return new StopwatchResult(lDuration, this.precision, this.count);
    }

    public void traceResult() {
        long lDuration = (this.stop - this.start) / this.precision.getDurationDivisor();
        String lUnit = this.precision.getUnit();
        double lTPS = (double)this.count / (double)lDuration * (double)this.precision.getTPSFactor();
        XFun.getTrace().info(this.name + " " + lDuration + lUnit);
        if (this.count > 0L) {
            XFun.getTrace().info("Objects / cycles: " + this.count + " Time per cycle: " + (double)lDuration / (double)this.count + lUnit);
            XFun.getTrace().info("TPS: " + lTPS);
        }
    }
}

