/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.pooling;

import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.pooling.PoolConfiguration;
import com.anaptecs.jeaf.tools.api.pooling.PoolGrowthStrategy;
import com.anaptecs.jeaf.tools.api.pooling.PooledObject;
import com.anaptecs.jeaf.tools.api.pooling.PooledObjectLifecycleManager;
import com.anaptecs.jeaf.tools.impl.pooling.PooledObjectAllocator;
import com.anaptecs.jeaf.tools.impl.pooling.PooledObjectWrapper;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.util.concurrent.TimeUnit;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.PoolException;
import stormpot.TimeExpiration;
import stormpot.Timeout;

public final class PoolImpl<T> {
    private final String poolName;
    private final PoolConfiguration poolConfiguration;
    private final BlazePool<PooledObjectWrapper<T>> pool;
    private final Timeout timeout;

    public PoolImpl(String pPoolName, PooledObjectLifecycleManager<T> pLifecycleManager, PoolConfiguration pPoolConfiguration) {
        Check.checkInvalidParameterNull((Object)pPoolName, (String)"pPoolName");
        Check.checkInvalidParameterNull(pLifecycleManager, (String)"pLifecycleManager");
        Check.checkInvalidParameterNull((Object)pPoolConfiguration, (String)"pPoolConfiguration");
        this.poolName = pPoolName;
        this.poolConfiguration = pPoolConfiguration;
        this.timeout = new Timeout((long)pPoolConfiguration.getAcquireTimeout(), TimeUnit.MILLISECONDS);
        Config lConfig = new Config();
        lConfig.setAllocator(new PooledObjectAllocator<T>(pLifecycleManager));
        lConfig.setExpiration((Expiration)new TimeExpiration((long)this.poolConfiguration.getObjectTTL(), TimeUnit.SECONDS));
        lConfig.setSize(this.poolConfiguration.getInitialPoolSize());
        lConfig.setBackgroundExpirationEnabled(false);
        this.pool = new BlazePool(lConfig);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public PooledObject<T> getPooledObject() {
        try {
            PooledObjectWrapper lPooledObject = (PooledObjectWrapper)this.pool.claim(this.timeout);
            if (lPooledObject == null) {
                boolean lIncreasedPool = this.increasePoolSizeIfPossible();
                if (lIncreasedPool) {
                    lPooledObject = (PooledObjectWrapper)this.pool.claim(this.timeout);
                    if (lPooledObject == null) {
                        throw new JEAFSystemException(ToolsMessages.UNABLE_TO_ACQUIRE_OBJECT_FROM_POOL, new String[]{this.poolName});
                    }
                } else {
                    throw new JEAFSystemException(ToolsMessages.POOL_OVERLOADED, new String[]{this.poolName, Integer.toString(this.pool.getTargetSize())});
                }
            }
            return lPooledObject;
        }
        catch (InterruptedException | PoolException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_ACQUIRE_OBJECT_FROM_POOL, e, new String[]{this.poolName});
        }
    }

    public int getCurrentPoolSize() {
        return this.pool.getTargetSize();
    }

    public boolean increasePoolSizeIfPossible() {
        boolean lIncreasedPoolSize;
        int lCurrentPoolSize = this.pool.getTargetSize();
        if (lCurrentPoolSize < this.poolConfiguration.getMaxPoolSize()) {
            int lNewPoolSize = this.calculateNewPoolSize(lCurrentPoolSize);
            this.pool.setTargetSize(lNewPoolSize);
            Trace.getTrace().write(ToolsMessages.INCREASED_POOL_SIZE, new String[]{this.poolName, Integer.toString(lCurrentPoolSize), Integer.toString(lNewPoolSize)});
            lIncreasedPoolSize = true;
        } else {
            lIncreasedPoolSize = false;
        }
        return lIncreasedPoolSize;
    }

    public int calculateNewPoolSize(int lCurrentPoolSize) {
        int lNewPoolSize;
        PoolGrowthStrategy lEnlargementStrategy = this.poolConfiguration.getPoolGrowthStrategy();
        switch (lEnlargementStrategy) {
            case FIXED_SIZE_GROWTH: {
                lNewPoolSize = lCurrentPoolSize + this.poolConfiguration.getIncrementSize();
                break;
            }
            case PERCENTAGED_GROWTH: {
                lNewPoolSize = (int)((double)lCurrentPoolSize * (1.0 + this.poolConfiguration.getIncrementPercentage() / 100.0));
                break;
            }
            default: {
                Assert.unexpectedEnumLiteral((Enum)lEnlargementStrategy);
                lNewPoolSize = lCurrentPoolSize;
            }
        }
        lNewPoolSize = Math.min(lNewPoolSize, this.poolConfiguration.getMaxPoolSize());
        return lNewPoolSize;
    }
}

