/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.pooling;

import com.anaptecs.jeaf.tools.api.pooling.PooledObjectLifecycleManager;
import com.anaptecs.jeaf.tools.impl.pooling.PooledObjectWrapper;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import stormpot.Allocator;
import stormpot.Slot;

public final class PooledObjectAllocator<T>
implements Allocator<PooledObjectWrapper<T>> {
    private final PooledObjectLifecycleManager<T> lifecycleManager;

    public PooledObjectAllocator(PooledObjectLifecycleManager<T> pLifecycleManager) {
        Check.checkInvalidParameterNull(pLifecycleManager, (String)"pLifecycleManager");
        this.lifecycleManager = pLifecycleManager;
    }

    public PooledObjectWrapper<T> allocate(Slot pSlot) throws Exception {
        Object lObject = this.lifecycleManager.createObject();
        return new PooledObjectWrapper<Object>(lObject, this.lifecycleManager, pSlot);
    }

    public void deallocate(PooledObjectWrapper<T> pPoolable) throws Exception {
        this.lifecycleManager.cleanup(pPoolable.getPooledObject());
    }
}

