/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.pooling;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.pooling.Pool;
import com.anaptecs.jeaf.tools.api.pooling.PoolConfiguration;
import com.anaptecs.jeaf.tools.api.pooling.PooledObject;
import com.anaptecs.jeaf.tools.api.pooling.PooledObjectLifecycleManager;
import com.anaptecs.jeaf.tools.api.pooling.PoolingTools;
import com.anaptecs.jeaf.tools.impl.pooling.PoolImpl;
import com.anaptecs.jeaf.tools.impl.pooling.PooledObjectWrapper;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import java.util.ArrayList;
import java.util.List;

@ToolsImplementation(toolsInterface=PoolingTools.class)
public final class PoolingToolsImpl
implements PoolingTools {
    private final List<PoolImpl<?>> pools = new ArrayList();

    public synchronized <T> Pool<T> createPool(String pPoolName, PooledObjectLifecycleManager<T> pLifecycleManager, PoolConfiguration pConfiguration) {
        Check.checkInvalidParameterNull((Object)pPoolName, (String)"pPoolName");
        Check.checkInvalidParameterNull(pLifecycleManager, (String)"pLifecycleManager");
        Check.checkInvalidParameterNull((Object)pConfiguration, (String)"pConfiguration");
        int lPoolID = this.pools.size();
        PoolImpl<T> lNewPoolImpl = new PoolImpl<T>(pPoolName, pLifecycleManager, pConfiguration);
        this.pools.add(lNewPoolImpl);
        return new Pool(lPoolID, pPoolName);
    }

    public <T> PooledObject<T> acquirePooledObject(Pool<T> pPool) {
        Check.checkInvalidParameterNull(pPool, (String)"pPool");
        PoolImpl<?> lPoolImpl = this.pools.get(pPool.getPoolID());
        return lPoolImpl.getPooledObject();
    }

    public <T> void releasePooledObject(PooledObject<T> pPooledObject) {
        Check.checkInvalidParameterNull(pPooledObject, (String)"pPooledObject");
        PooledObjectWrapper pWrapper = (PooledObjectWrapper)pPooledObject;
        pWrapper.release();
    }
}

