/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.reflect;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.reflect.ReflectionTools;
import com.anaptecs.jeaf.xfun.api.XFunMessages;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ToolsImplementation(toolsInterface=ReflectionTools.class)
public final class ReflectionToolsImpl
implements ReflectionTools {
    public Class<?> loadClass(String pClassName) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pClassName, (String)"pClassName");
        try {
            return Class.forName(pClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JEAFSystemException(XFunMessages.CLASS_NOT_LOADABLE, (Throwable)e, new String[]{pClassName});
        }
    }

    public <T> Class<? extends T> loadClass(String pClassName, Class<T> pType) throws JEAFSystemException {
        return this.loadClass(pClassName);
    }

    public boolean isClassLoadable(String pClassName) {
        boolean lIsLoadable;
        Check.checkInvalidParameterNull((Object)pClassName, (String)"pClassName");
        try {
            Class.forName(pClassName);
            lIsLoadable = true;
        }
        catch (ClassNotFoundException e) {
            lIsLoadable = false;
        }
        return lIsLoadable;
    }

    public <T> T newInstance(Class<T> pClass) throws JEAFSystemException {
        return this.newInstance(pClass, false);
    }

    public <T> T newInstance(Class<T> pClass, boolean pMakeAccessible) throws JEAFSystemException {
        Check.checkInvalidParameterNull(pClass, (String)"pClass");
        try {
            Constructor<T> lConstructor = pClass.getDeclaredConstructor(new Class[0]);
            if (pMakeAccessible) {
                lConstructor.setAccessible(true);
            }
            return lConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CREATE_NEW_INSTANCE, (Throwable)e, new String[]{pClass.getName()});
        }
    }

    public <T> T newInstance(Class<T> pClass, Class<?> pAssignableClass) {
        Check.checkInvalidParameterNull(pClass, (String)"pClass");
        Check.checkInvalidParameterNull(pAssignableClass, (String)"pAssignableClass");
        if (pAssignableClass.isAssignableFrom(pClass)) {
            return this.newInstance(pClass);
        }
        String[] lParams = new String[]{pClass.getName(), pAssignableClass.getName()};
        throw new JEAFSystemException(ToolsMessages.CLASS_NOT_ASSIGNABLE, lParams);
    }

    public <T> T newInstance(String pClassName, Class<T> pAssignableClass) {
        Check.checkInvalidParameterNull((Object)pClassName, (String)"pClassName");
        Check.checkInvalidParameterNull(pAssignableClass, (String)"pAssignableClass");
        Class<?> lClass = this.loadClass(pClassName);
        return (T)this.newInstance(lClass, pAssignableClass);
    }

    public <T extends Annotation> Map<Class<?>, T> getAnnotations(List<Class<?>> pClasses, Class<T> pAnnotationType) {
        Check.checkInvalidParameterNull(pClasses, (String)"pClasses");
        Check.checkInvalidParameterNull(pAnnotationType, (String)"pAnnotationType");
        HashMap lAnnotationsMap = new HashMap();
        for (Class<?> lNextClass : pClasses) {
            T lAnnotation = lNextClass.getAnnotation(pAnnotationType);
            if (lAnnotation == null) continue;
            lAnnotationsMap.put(lNextClass, lAnnotation);
        }
        return lAnnotationsMap;
    }
}

