/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.serialization;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.serialization.SerializationTools;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@ToolsImplementation(toolsInterface=SerializationTools.class)
public class SerializationToolsImpl
implements SerializationTools {
    public byte[] serializeObject(Serializable pObject) {
        byte[] lBytes;
        if (pObject != null) {
            try {
                ByteArrayOutputStream lByteOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream lOut = new ObjectOutputStream(lByteOutputStream);
                lOut.writeObject(pObject);
                lBytes = lByteOutputStream.toByteArray();
                lOut.close();
                lByteOutputStream.close();
            }
            catch (IOException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_SERIALIZE_OBJECT, (Throwable)e, new String[]{pObject.getClass().getName()});
            }
        } else {
            lBytes = null;
        }
        return lBytes;
    }

    public <T extends Serializable> T deserializeObject(byte[] pBytes, Class<T> pType) {
        Serializable lObject;
        Check.checkInvalidParameterNull(pType, (String)"pType");
        if (pBytes != null) {
            try {
                ByteArrayInputStream lByteInputStream = new ByteArrayInputStream(pBytes);
                ObjectInputStream lInputStream = new ObjectInputStream(lByteInputStream);
                lObject = (Serializable)lInputStream.readObject();
                lByteInputStream.close();
                lInputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_DESERIALIZE_OBJECT, (Throwable)e, new String[]{pType.getName()});
            }
        } else {
            lObject = null;
        }
        return (T)lObject;
    }
}

