/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.ssl;

import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.impl.ssl.AcceptAllCertsTrustManager;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class AcceptAllCertsSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory socketFactory;

    public AcceptAllCertsSSLSocketFactory() {
        this("TLS");
    }

    public AcceptAllCertsSSLSocketFactory(String pProtocol) {
        try {
            SSLContext lContext = SSLContext.getInstance(pProtocol);
            lContext.init(null, new TrustManager[]{new AcceptAllCertsTrustManager()}, new SecureRandom());
            this.socketFactory = lContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CREATE_SSL_SOCKET_FACTORY, (Throwable)e, new String[0]);
        }
    }

    public static SocketFactory getDefault() {
        return new AcceptAllCertsSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }

    @Override
    public Socket createSocket(Socket pSocket, InputStream pConsumed, boolean pAutoClose) throws IOException {
        return this.socketFactory.createSocket(pSocket, pConsumed, pAutoClose);
    }

    @Override
    public Socket createSocket(Socket pSocket, String pHost, int pPort, boolean pAutoClose) throws IOException {
        return this.socketFactory.createSocket(pSocket, pHost, pPort, pAutoClose);
    }

    @Override
    public Socket createSocket(String pHost, int pPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(pHost, pPort);
    }

    @Override
    public Socket createSocket(InetAddress pHost, int pPort) throws IOException {
        return this.socketFactory.createSocket(pHost, pPort);
    }

    @Override
    public Socket createSocket(String pHost, int pPort, InetAddress pLocalHost, int pLocalPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(pHost, pPort, pLocalHost, pLocalPort);
    }

    @Override
    public Socket createSocket(InetAddress pAddress, int pPort, InetAddress pLocalAddress, int pLocalPort) throws IOException {
        return this.socketFactory.createSocket(pAddress, pPort, pLocalAddress, pLocalPort);
    }
}

