/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.stream;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.encoding.EncodingTools;
import com.anaptecs.jeaf.tools.api.stream.BufferingMode;
import com.anaptecs.jeaf.tools.api.stream.StreamTools;
import com.anaptecs.jeaf.tools.impl.stream.PoolableByteArray;
import com.anaptecs.jeaf.tools.impl.stream.PoolableByteArrayAllocator;
import com.anaptecs.jeaf.tools.impl.stream.StreamToolsConfiguration;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.messages.MessageID;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.bootstrap.Check;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.PoolException;
import stormpot.Timeout;

@ToolsImplementation(toolsInterface=StreamTools.class)
public class StreamToolsImpl
implements StreamTools {
    private final int bufferSize;
    private final int bufferPoolSize;
    private static final Timeout TIMEOUT = new Timeout(1L, TimeUnit.NANOSECONDS);
    private final BlazePool<PoolableByteArray> bufferPool;

    public StreamToolsImpl() {
        this(new StreamToolsConfiguration());
    }

    public StreamToolsImpl(StreamToolsConfiguration pConfiguration) {
        Check.checkInvalidParameterNull((Object)((Object)pConfiguration), (String)"pConfiguration");
        this.bufferSize = pConfiguration.getBufferSize();
        this.bufferPoolSize = pConfiguration.getBufferPoolSize();
        this.bufferPool = this.createBufferPool(this.bufferPoolSize, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlazePool<PoolableByteArray> createBufferPool(int pBufferPoolSize, int pBufferSize) {
        BlazePool lBufferPool;
        if (pBufferPoolSize > 0) {
            Config lConfig = new Config();
            lConfig.setSize(pBufferPoolSize);
            lConfig.setAllocator((Allocator)new PoolableByteArrayAllocator(pBufferSize));
            lBufferPool = new BlazePool(lConfig);
            PoolableByteArray lBuffer = null;
            try {
                lBuffer = (PoolableByteArray)lBufferPool.claim(new Timeout(50L, TimeUnit.MILLISECONDS));
            }
            catch (PoolException e) {
                XFun.getTrace().error("Unable to initialize buffer pool with pool size " + pBufferPoolSize + ".");
                XFun.getTrace().error(e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                XFun.getTrace().error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                if (lBuffer != null) {
                    lBuffer.release();
                }
            }
        } else {
            lBufferPool = null;
        }
        return lBufferPool;
    }

    private PoolableByteArray getBuffer() {
        PoolableByteArray lBuffer;
        if (this.bufferPool != null) {
            try {
                lBuffer = (PoolableByteArray)this.bufferPool.claim(TIMEOUT);
                if (lBuffer == null) {
                    lBuffer = new PoolableByteArray(this.bufferSize, null);
                }
            }
            catch (PoolException e) {
                XFun.getTrace().error("Exception when trying to claim object from buffer pool. Working with unpooled object instead. Please check root cause.");
                XFun.getTrace().error(e.getMessage(), (Throwable)e);
                lBuffer = new PoolableByteArray(this.bufferSize, null);
            }
            catch (InterruptedException e) {
                XFun.getTrace().error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
                lBuffer = new PoolableByteArray(this.bufferSize, null);
            }
        } else {
            lBuffer = new PoolableByteArray(this.bufferSize, null);
        }
        return lBuffer;
    }

    public byte[] getStreamContent(InputStream pInputStream) throws IOException {
        return this.getContent(pInputStream);
    }

    public String getStreamContentAsString(InputStream pInputStream) throws IOException {
        byte[] lContent = this.getContent(pInputStream);
        return new String(lContent, EncodingTools.getEncodingTools().getDefaultCharset());
    }

    public long copyContent(String pStreamName, InputStream pInputStream, OutputStream pOutputStream, boolean pCloseStreams) throws IOException {
        return this.copyContent(pStreamName, pInputStream, pOutputStream, pCloseStreams, Long.MAX_VALUE, BufferingMode.AUTO);
    }

    public long copyContent(String pStreamName, InputStream pInputStream, OutputStream pOutputStream, boolean pCloseStreams, long pMaxBytes) throws IOException {
        return this.copyContent(pStreamName, pInputStream, pOutputStream, pCloseStreams, pMaxBytes, BufferingMode.AUTO);
    }

    public long copyContent(String pStreamName, InputStream pInputStream, OutputStream pOutputStream, boolean pCloseStreams, BufferingMode pBufferingMode) throws IOException {
        return this.copyContent(pStreamName, pInputStream, pOutputStream, pCloseStreams, Long.MAX_VALUE, pBufferingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyContent(String pStreamName, InputStream pInputStream, OutputStream pOutputStream, boolean pCloseStreams, long pMaxBytes, BufferingMode pBufferingMode) throws IOException {
        InputStream lBufferedInputStream;
        com.anaptecs.jeaf.xfun.api.checks.Check.checkInvalidParameterNull((Object)pInputStream, (String)"pInputStream");
        com.anaptecs.jeaf.xfun.api.checks.Check.checkInvalidParameterNull((Object)pOutputStream, (String)"pOutputStream");
        if (this.requiresBuffering(pInputStream, pBufferingMode)) {
            lBufferedInputStream = new BufferedInputStream(pInputStream, this.bufferSize);
            lBufferedInputStream = pInputStream;
        } else {
            lBufferedInputStream = pInputStream;
        }
        OutputStream lBufferedOutputStream = this.requiresBuffering(pOutputStream, pBufferingMode) ? new BufferedOutputStream(pOutputStream, this.bufferSize) : pOutputStream;
        long lStart = System.nanoTime();
        PoolableByteArray lPoolableBuffer = null;
        try {
            int lLength;
            lPoolableBuffer = this.getBuffer();
            byte[] lBuffer = lPoolableBuffer.getByteArray();
            long lByteCount = 0L;
            while ((lLength = lBufferedInputStream.read(lBuffer)) != -1) {
                lBufferedOutputStream.write(lBuffer, 0, lLength);
                if ((lByteCount += (long)lLength) <= pMaxBytes) continue;
                throw new JEAFSystemException(ToolsMessages.MAX_BYTES_EXCEEDED, new String[]{Long.toString(pMaxBytes)});
            }
            lBufferedOutputStream.flush();
            long lEnd = System.nanoTime();
            this.traceIOSummary(pStreamName, lByteCount, lEnd - lStart, ToolsMessages.TRANSFERED_FILE_CONTENT);
            long l = lByteCount;
            return l;
        }
        finally {
            if (lPoolableBuffer != null) {
                lPoolableBuffer.release();
            }
            if (pCloseStreams) {
                try {
                    lBufferedInputStream.close();
                }
                finally {
                    lBufferedOutputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getContent(InputStream pInputStream) throws IOException {
        com.anaptecs.jeaf.xfun.api.checks.Check.checkInvalidParameterNull((Object)pInputStream, (String)"pInputStream");
        int lAvailableBytes = pInputStream.available();
        ByteArrayOutputStream lBytes = new ByteArrayOutputStream(lAvailableBytes);
        PoolableByteArray lPoolableBuffer = null;
        try {
            int lBytesRead;
            lPoolableBuffer = this.getBuffer();
            byte[] lBuffer = lPoolableBuffer.getByteArray();
            while ((lBytesRead = pInputStream.read(lBuffer, 0, lBuffer.length)) != -1) {
                lBytes.write(lBuffer, 0, lBytesRead);
            }
            byte[] byArray = lBytes.toByteArray();
            return byArray;
        }
        finally {
            if (lPoolableBuffer != null) {
                lPoolableBuffer.release();
            }
        }
    }

    public void traceIOSummary(String pFileName, long pByteCount, long pDuration, MessageID pMessageID) {
        Assert.assertNotNull((Object)pFileName, (String)"pFileName");
        if (pMessageID.isEnabled()) {
            String llFileSizeString;
            Trace lTrace = XFun.getTrace();
            double lDurationInMillis = (double)pDuration / 1000000.0;
            String lDurationString = lDurationInMillis < 1.0 ? new DecimalFormat("#.###").format(lDurationInMillis) : (lDurationInMillis < 10.0 ? new DecimalFormat("#.#").format(lDurationInMillis) : new DecimalFormat("#").format(lDurationInMillis));
            DecimalFormat lTwoDigits = new DecimalFormat("#.##");
            double lFileSizeMB = (double)pByteCount / 1048576.0;
            double lTransferrate = lFileSizeMB / lDurationInMillis * 1000.0;
            String lTransferrateString = lTwoDigits.format(lTransferrate);
            if (pByteCount < 1024L) {
                llFileSizeString = pByteCount + " Bytes";
            } else if (pByteCount < 0x100000L) {
                double lKilobytes = (double)pByteCount / 1024.0;
                llFileSizeString = lTwoDigits.format(lKilobytes) + " KB";
            } else {
                double lMegabytes = (double)pByteCount / 1048576.0;
                llFileSizeString = lTwoDigits.format(lMegabytes) + " MB";
            }
            lTrace.write(pMessageID, new String[]{pFileName, lDurationString, llFileSizeString, lTransferrateString});
        }
    }

    private boolean requiresBuffering(InputStream pInputStream, BufferingMode pBufferingMode) {
        boolean lRequiresBuffering;
        if (pBufferingMode == null) {
            pBufferingMode = BufferingMode.AUTO;
        }
        if (pBufferingMode == BufferingMode.ALWAYS) {
            lRequiresBuffering = true;
        } else if (pBufferingMode == BufferingMode.NO_BUFFERING) {
            lRequiresBuffering = false;
        } else if (pBufferingMode == BufferingMode.AUTO) {
            lRequiresBuffering = !(pInputStream instanceof BufferedInputStream) && !(pInputStream instanceof ByteArrayInputStream);
        } else {
            Assert.unexpectedEnumLiteral((Enum)pBufferingMode);
            lRequiresBuffering = false;
        }
        return lRequiresBuffering;
    }

    private boolean requiresBuffering(OutputStream pOutputStream, BufferingMode pBufferingMode) {
        boolean lRequiresBuffering;
        if (pBufferingMode == null) {
            pBufferingMode = BufferingMode.AUTO;
        }
        if (pBufferingMode == BufferingMode.ALWAYS) {
            lRequiresBuffering = true;
        } else if (pBufferingMode == BufferingMode.NO_BUFFERING) {
            lRequiresBuffering = false;
        } else if (pBufferingMode == BufferingMode.AUTO) {
            lRequiresBuffering = !(pOutputStream instanceof BufferedOutputStream) && !(pOutputStream instanceof ByteArrayOutputStream);
        } else {
            Assert.unexpectedEnumLiteral((Enum)pBufferingMode);
            lRequiresBuffering = false;
        }
        return lRequiresBuffering;
    }
}

