/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.string;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.string.StringTools;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ToolsImplementation(toolsInterface=StringTools.class)
public class StringToolsImpl
implements StringTools {
    private static final String DEFAULT_DELIMITER = ", ";

    public boolean isEmpty(String pString) {
        return pString == null || pString.trim().length() == 0;
    }

    public boolean isRealString(String pString) {
        return !this.isEmpty(pString);
    }

    public boolean isBlank(String pString) {
        boolean lIsBlank = pString == null ? true : pString.trim().isEmpty();
        return lIsBlank;
    }

    public boolean isNotBlank(String pString) {
        return !this.isBlank(pString);
    }

    public boolean containsDigitsOnly(String pString) {
        Check.checkInvalidParameterNull((Object)pString, (String)"pString");
        boolean lContainsDigitsOnly = true;
        for (char lNextCharacter : pString.toCharArray()) {
            if (Character.isDigit(lNextCharacter)) continue;
            lContainsDigitsOnly = false;
            break;
        }
        return lContainsDigitsOnly;
    }

    public List<String> split(String pString, String pRegex, boolean pTrim) {
        List<String> lStrings;
        Check.checkInvalidParameterNull((Object)pRegex, (String)pRegex);
        if (pString != null) {
            String[] lResultArray = pString.split(pRegex);
            lStrings = new ArrayList<String>(lResultArray.length);
            for (int i = 0; i < lResultArray.length; ++i) {
                if (pTrim) {
                    lStrings.add(lResultArray[i].trim());
                    continue;
                }
                lStrings.add(lResultArray[i]);
            }
        } else {
            lStrings = Collections.emptyList();
        }
        return lStrings;
    }

    public boolean endsWith(String pString, List<String> pList) {
        Check.checkInvalidParameterNull((Object)pString, (String)pString);
        Check.checkInvalidParameterNull(pList, (String)"pList");
        boolean lEndsWith = false;
        for (String lNextString : pList) {
            if (!pString.endsWith(lNextString)) continue;
            lEndsWith = true;
            break;
        }
        return lEndsWith;
    }

    public int compareToIgnoreCase(String pString1, String pString2) {
        return this.compareTo(pString1, pString2, true);
    }

    public int compareTo(String pString1, String pString2) {
        return this.compareTo(pString1, pString2, false);
    }

    private int compareTo(String pString1, String pString2, boolean pIgnoreCase) {
        int lResult = pString1 != null && pString2 != null ? (pIgnoreCase ? pString1.compareToIgnoreCase(pString2) : pString1.compareTo(pString2)) : (pString1 == null && pString2 == null ? 0 : (pString1 == null ? -1 : 1));
        return lResult;
    }

    public String getClassNamesAsString(Collection<Class<?>> pClasses) {
        return this.getClassNamesAsString(pClasses, "");
    }

    public String getClassNamesAsString(Collection<Class<?>> pClasses, String pEmptyText) {
        return this.getClassNamesAsString(pClasses, pEmptyText, DEFAULT_DELIMITER);
    }

    public String getClassNamesAsString(Collection<Class<?>> pClasses, String pEmptyText, String pDelimiter) {
        String lClassNames;
        Check.checkInvalidParameterNull((Object)pDelimiter, (String)"pDelimiter");
        if (pClasses != null) {
            StringBuilder lBuilder = new StringBuilder();
            if (!pClasses.isEmpty()) {
                Iterator<Class<?>> lIterator = pClasses.iterator();
                while (lIterator.hasNext()) {
                    Class<?> lNext = lIterator.next();
                    lBuilder.append(lNext.getName());
                    if (!lIterator.hasNext()) continue;
                    lBuilder.append(pDelimiter);
                }
                lClassNames = lBuilder.toString();
            } else {
                lClassNames = pEmptyText;
            }
        } else {
            lClassNames = pEmptyText;
        }
        return lClassNames;
    }

    public String getClassNamesAsString(Class<?>[] pClasses) {
        return this.getClassNamesAsString(pClasses, "", DEFAULT_DELIMITER);
    }

    public String getClassNamesAsString(Class<?>[] pClasses, String pEmptyText) {
        return this.getClassNamesAsString(pClasses, pEmptyText, DEFAULT_DELIMITER);
    }

    public String getClassNamesAsString(Class<?>[] pClasses, String pEmptyText, String pDelimiter) {
        List<Class<?>> lList = pClasses != null ? Arrays.asList(pClasses) : null;
        return this.getClassNamesAsString(lList, pEmptyText, pDelimiter);
    }
}

