/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.validation;

import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.messages.LocalizedObject;
import com.anaptecs.jeaf.xfun.api.messages.MessageRepository;
import com.anaptecs.jeaf.xfun.bootstrap.Check;
import java.util.Locale;
import javax.validation.MessageInterpolator;

public class JEAFMessageInterpolator
implements MessageInterpolator {
    private final MessageInterpolator defaultMessageInterpolator;

    public JEAFMessageInterpolator(MessageInterpolator pDefaultMessageInterpolator) {
        Check.checkInvalidParameterNull((Object)pDefaultMessageInterpolator, (String)"pDefaultMessageInterpolator");
        this.defaultMessageInterpolator = pDefaultMessageInterpolator;
    }

    public String interpolate(String pMessageTemplate, MessageInterpolator.Context pContext) {
        return this.interpolate(pMessageTemplate, pContext, Tools.getLocaleTools().getCurrentLocale());
    }

    public String interpolate(String pMessageTemplate, MessageInterpolator.Context pContext, Locale pLocale) {
        String lMessage;
        if (Tools.getStringTools().containsDigitsOnly(pMessageTemplate)) {
            int lCode = Integer.parseInt(pMessageTemplate);
            MessageRepository lMessageRepository = XFun.getMessageRepository();
            if (lMessageRepository.existsMessage(lCode)) {
                LocalizedObject lLocalizedObject = lMessageRepository.getLocalizedObject(lCode);
                lMessage = lMessageRepository.getMessage(lLocalizedObject, pLocale, new String[0]);
            } else {
                lMessage = this.defaultMessageInterpolator.interpolate(pMessageTemplate, pContext, pLocale);
            }
        } else {
            lMessage = this.defaultMessageInterpolator.interpolate(pMessageTemplate, pContext, pLocale);
        }
        return lMessage;
    }
}

