/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.validation;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.validation.ValidationResult;
import com.anaptecs.jeaf.tools.api.validation.ValidationTools;
import com.anaptecs.jeaf.tools.impl.validation.JEAFMessageInterpolator;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.messages.LocalizedObject;
import com.anaptecs.jeaf.xfun.api.messages.MessageRepository;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.MessageInterpolator;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.PropertyDescriptor;

@ToolsImplementation(toolsInterface=ValidationTools.class)
public class ValidationToolsImpl
implements ValidationTools {
    private final Validator validator;

    public ValidationToolsImpl() {
        try {
            Configuration lConfiguration = Validation.byDefaultProvider().configure();
            MessageInterpolator lDefaultMessageInterpolator = lConfiguration.getDefaultMessageInterpolator();
            lConfiguration.messageInterpolator((MessageInterpolator)new JEAFMessageInterpolator(lDefaultMessageInterpolator));
            ValidatorFactory lValidatorFactory = lConfiguration.buildValidatorFactory();
            this.validator = lValidatorFactory.getValidator();
        }
        catch (RuntimeException e) {
            Trace lTrace = XFun.getTrace();
            lTrace.error("Unable to initialize JEAF Validation-Tools. Most likely this is a classpath issue. Please ensure that you have all required libraries of your validation library inside your classpath.");
            lTrace.error(e.getMessage());
            throw e;
        }
    }

    public boolean requiresRequestValidation(Method pMethod) {
        Check.checkInvalidParameterNull((Object)pMethod, (String)"pMethod");
        MethodDescriptor lMethodConstraints = this.getMethodConstraints(pMethod);
        boolean lRequiresRequestValidation = lMethodConstraints != null ? lMethodConstraints.hasConstrainedParameters() : false;
        return lRequiresRequestValidation;
    }

    public boolean requiresResponseValidation(Method pMethod) {
        Check.checkInvalidParameterNull((Object)pMethod, (String)"pMethod");
        MethodDescriptor lMethodConstraints = this.getMethodConstraints(pMethod);
        boolean lRequiresResponseValidation = lMethodConstraints != null ? lMethodConstraints.hasConstrainedReturnValue() : false;
        return lRequiresResponseValidation;
    }

    public boolean requiresValidation(Field pField) {
        Check.checkInvalidParameterNull((Object)pField, (String)"pField");
        BeanDescriptor lConstraints = this.validator.getConstraintsForClass(pField.getDeclaringClass());
        PropertyDescriptor lFieldConstraints = lConstraints.getConstraintsForProperty(pField.getName());
        boolean lRequiresValidation = lFieldConstraints != null;
        return lRequiresValidation;
    }

    public boolean isValidationAnnotation(Annotation pAnnotation) {
        boolean lIsValidationAnnotation = false;
        if (pAnnotation instanceof Valid) {
            lIsValidationAnnotation = true;
        } else {
            Annotation[] lAnnotations;
            Class<? extends Annotation> lAnnotationType = pAnnotation.annotationType();
            for (Annotation lNext : lAnnotations = lAnnotationType.getAnnotations()) {
                Class<? extends Annotation> lType = lNext.annotationType();
                boolean lIsConstraintAnnontation = Constraint.class.isAssignableFrom(lType);
                if (!lIsConstraintAnnontation) continue;
                lIsValidationAnnotation = true;
                break;
            }
        }
        return lIsValidationAnnotation;
    }

    public boolean containsValidationAnnotation(List<Annotation> pAnnotations) {
        Check.checkInvalidParameterNull(pAnnotations, (String)"pAnnotations");
        boolean lContainsValidation = false;
        for (Annotation lNextAnnotation : pAnnotations) {
            boolean lValidationAnnotation = this.isValidationAnnotation(lNextAnnotation);
            if (!lValidationAnnotation) continue;
            lContainsValidation = true;
            break;
        }
        return lContainsValidation;
    }

    public boolean containsValidationAnnotation(Annotation[] pAnnotations) {
        Check.checkInvalidParameterNull((Object)pAnnotations, (String)"pAnnotations");
        boolean lContainsValidation = false;
        for (Annotation lNextAnnotation : pAnnotations) {
            boolean lValidationAnnotation = this.isValidationAnnotation(lNextAnnotation);
            if (!lValidationAnnotation) continue;
            lContainsValidation = true;
            break;
        }
        return lContainsValidation;
    }

    public <T> ValidationResult<T> validate(T pObject) {
        Set<ConstraintViolation<T>> lConstraintViolations = this.validateObject(pObject);
        return new ValidationResult(pObject, lConstraintViolations);
    }

    public <T> Set<ConstraintViolation<T>> validateObject(T pObject) {
        Check.checkInvalidParameterNull(pObject, (String)"pObject");
        return this.validator.validate(pObject, new Class[0]);
    }

    public void enforceObjectValidation(Object pObject) throws ConstraintViolationException {
        Set<ConstraintViolation<Object>> lViolations = this.validateObject(pObject);
        if (!lViolations.isEmpty()) {
            throw new ConstraintViolationException(ToolsMessages.OBJECT_VALIDATION_FAILED.toString(), lViolations);
        }
    }

    public <T> Set<ConstraintViolation<T>> validateObjects(Collection<T> pObjects) {
        Set<Object> lViolations;
        if (pObjects != null) {
            Object[] lArray = pObjects.toArray();
            lViolations = this.validateObjects(lArray);
        } else {
            lViolations = Collections.emptySet();
        }
        return lViolations;
    }

    public <T> Set<ConstraintViolation<T>> validateObjects(T[] pObjects) {
        Set<ConstraintViolation<T>> lViolations;
        if (pObjects != null) {
            lViolations = new HashSet();
            for (T pObjectToValidate : pObjects) {
                Set<ConstraintViolation<T>> lNextViolations = this.validateObject(pObjectToValidate);
                if (lNextViolations.isEmpty()) continue;
                lViolations.addAll(lNextViolations);
            }
        } else {
            lViolations = Collections.emptySet();
        }
        return lViolations;
    }

    public <T> Set<ConstraintViolation<T>> validateParameters(T pObject, Method pMethod, Object[] pParameterValues, Class<?> ... pGroups) {
        Check.checkInvalidParameterNull(pObject, (String)"pObject");
        Check.checkInvalidParameterNull((Object)pMethod, (String)"pMethod");
        Check.checkInvalidParameterNull((Object)pParameterValues, (String)"pParameterValues");
        return this.validator.forExecutables().validateParameters(pObject, pMethod, pParameterValues, (Class[])pGroups);
    }

    public <T> void enforceParameterValidation(T pObject, Method pMethod, Object[] pParameterValues, Class<?> ... pGroups) throws ConstraintViolationException {
        Set<ConstraintViolation<T>> lViolations = this.validateParameters(pObject, pMethod, pParameterValues, pGroups);
        if (!lViolations.isEmpty()) {
            MessageRepository lRepo = XFun.getMessageRepository();
            String lMessage = lRepo.getMessage((LocalizedObject)ToolsMessages.REQUEST_VALIDATION_FAILED, new String[]{Integer.toString(lViolations.size())});
            throw new ConstraintViolationException(lMessage, lViolations);
        }
    }

    public <T> Set<ConstraintViolation<T>> validateReturnValue(T pObject, Method pMethod, Object pReturnValue, Class<?> ... pGroups) {
        Check.checkInvalidParameterNull(pObject, (String)"pObject");
        Check.checkInvalidParameterNull((Object)pMethod, (String)"pMethod");
        return this.validator.forExecutables().validateReturnValue(pObject, pMethod, pReturnValue, (Class[])pGroups);
    }

    public <T> void enforceReturnValueValidation(T pObject, Method pMethod, Object pReturnValue, Class<?> ... pGroups) {
        Set<ConstraintViolation<T>> lViolations = this.validateReturnValue(pObject, pMethod, pReturnValue, pGroups);
        if (!lViolations.isEmpty()) {
            MessageRepository lRepo = XFun.getMessageRepository();
            String lMessage = lRepo.getMessage((LocalizedObject)ToolsMessages.RESPONSE_VALIDATION_FAILED, new String[]{Integer.toString(lViolations.size())});
            throw new ConstraintViolationException(lMessage, lViolations);
        }
    }

    public Validator getValidator() {
        return this.validator;
    }

    private MethodDescriptor getMethodConstraints(Method pMethod) {
        BeanDescriptor lConstraints = this.validator.getConstraintsForClass(pMethod.getDeclaringClass());
        return lConstraints.getConstraintsForMethod(pMethod.getName(), (Class[])pMethod.getParameterTypes());
    }
}

