/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.xml;

import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.impl.xml.ErrorHandlerImpl;
import com.anaptecs.jeaf.tools.impl.xml.XMLToolsImpl;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.ErrorHandler;
import stormpot.Poolable;
import stormpot.Slot;

public class PooledDocumentBuilder
implements Poolable {
    private final Slot slot;
    private final DocumentBuilder documentBuilder;
    private final ErrorHandler errorHandler;

    PooledDocumentBuilder(Slot pSlot, boolean pValidating) {
        this.slot = pSlot;
        try {
            DocumentBuilderFactory lFactory = XMLToolsImpl.createSecuredDocumentBuilderFactory(pValidating);
            this.documentBuilder = lFactory.newDocumentBuilder();
            this.errorHandler = new ErrorHandlerImpl();
            this.documentBuilder.setErrorHandler(this.errorHandler);
        }
        catch (ParserConfigurationException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CREATE_DOCUMENT_BUILDER, (Throwable)e, new String[0]);
        }
    }

    public void release() {
        this.slot.release((Poolable)this);
        this.documentBuilder.reset();
        this.documentBuilder.setErrorHandler(this.errorHandler);
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }
}

