/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.tools.impl.xml;

import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.tools.api.ToolsMessages;
import com.anaptecs.jeaf.tools.api.xml.DocumentProperties;
import com.anaptecs.jeaf.tools.api.xml.XMLTools;
import com.anaptecs.jeaf.tools.impl.xml.DocumentBuilderAllocator;
import com.anaptecs.jeaf.tools.impl.xml.ErrorHandlerImpl;
import com.anaptecs.jeaf.tools.impl.xml.PooledDocumentBuilder;
import com.anaptecs.jeaf.tools.impl.xml.XMLToolsConfiguration;
import com.anaptecs.jeaf.xfun.annotations.StartupInfoWriterImpl;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.StartupInfoWriter;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import com.anaptecs.jeaf.xfun.api.trace.TraceLevel;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.Pool;
import stormpot.PoolException;
import stormpot.Timeout;

@StartupInfoWriterImpl
@ToolsImplementation(toolsInterface=XMLTools.class)
public class XMLToolsImpl
implements XMLTools,
StartupInfoWriter {
    public static final String DOCUMENT_BUILDER_POOL_SIZE_PROPERTY = "jeaf.tools.xml.document.builder.pool.size";
    private static int noPooledObjectCounter = 0;
    private static final Timeout TIMEOUT = new Timeout(1L, TimeUnit.NANOSECONDS);
    private final int poolSize;
    private final Pool<PooledDocumentBuilder> validatingPool;
    private final Pool<PooledDocumentBuilder> nonValidatingPool;

    public XMLToolsImpl() {
        XMLToolsConfiguration lConfiguration = new XMLToolsConfiguration();
        this.poolSize = lConfiguration.getDocumentBuilderPoolSize();
        Config lConfig = new Config();
        lConfig.setAllocator((Allocator)new DocumentBuilderAllocator(true));
        lConfig.setBackgroundExpirationEnabled(false).setSize(this.poolSize);
        this.validatingPool = new BlazePool(lConfig);
        lConfig = new Config();
        lConfig.setAllocator((Allocator)new DocumentBuilderAllocator(false));
        lConfig.setBackgroundExpirationEnabled(false);
        lConfig.setSize(this.poolSize);
        this.nonValidatingPool = new BlazePool(lConfig);
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder lDocumentBuilder = this.createDocumentBuilder(false);
        lDocumentBuilder.setErrorHandler(new ErrorHandlerImpl());
        return lDocumentBuilder.newDocument();
    }

    public DocumentBuilder createDocumentBuilder(boolean pValidating) throws ParserConfigurationException {
        DocumentBuilderFactory lFactory = XMLToolsImpl.createSecuredDocumentBuilderFactory(pValidating);
        DocumentBuilder lDocumentBuilder = lFactory.newDocumentBuilder();
        lDocumentBuilder.setErrorHandler(new ErrorHandlerImpl());
        return lDocumentBuilder;
    }

    static DocumentBuilderFactory createSecuredDocumentBuilderFactory(boolean pValidating) throws ParserConfigurationException {
        DocumentBuilderFactory lFactory = DocumentBuilderFactory.newInstance();
        lFactory.setValidating(pValidating);
        lFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        lFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        lFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        lFactory.setXIncludeAware(false);
        lFactory.setExpandEntityReferences(false);
        return lFactory;
    }

    public Document parseFile(String pFileName, boolean pValidating) throws JEAFSystemException {
        return this.parseFile(pFileName, pValidating, null);
    }

    public Document parseFile(String pFileName, boolean pValidating, String pSystemID) throws JEAFSystemException {
        Document document;
        Check.checkInvalidParameterNull((Object)pFileName, (String)"pFileName");
        File lResourceFile = new File(pFileName);
        FileInputStream lResourceStream = new FileInputStream(lResourceFile);
        try {
            document = this.parseInputStream(lResourceStream, pValidating, pSystemID, pFileName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)lResourceStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JEAFSystemException(ToolsMessages.UNABLE_TO_PARSE_XML_FILE, (Throwable)e, new String[]{pFileName});
            }
        }
        ((InputStream)lResourceStream).close();
        return document;
    }

    public Document parseInputStream(InputStream pInputStream, boolean pValidating) throws JEAFSystemException {
        return this.parseInputStream(pInputStream, pValidating, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Document parseInputStream(InputStream pInputStream, boolean pValidating, String pSystemID, String pStreamName) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pInputStream, (String)"pInputStream");
        String lStreamName = pStreamName;
        if (lStreamName == null) {
            lStreamName = "unknown";
        }
        BufferedInputStream lBufferedInputStream = pInputStream instanceof BufferedInputStream ? (BufferedInputStream)pInputStream : new BufferedInputStream(pInputStream);
        PooledDocumentBuilder lPooledProxy = null;
        try {
            Object object;
            DocumentBuilder lDocumentBuilder;
            lPooledProxy = pValidating ? (PooledDocumentBuilder)this.validatingPool.claim(TIMEOUT) : (PooledDocumentBuilder)this.nonValidatingPool.claim(TIMEOUT);
            if (lPooledProxy != null) {
                lDocumentBuilder = lPooledProxy.getDocumentBuilder();
            } else {
                int lCount = 0;
                object = XMLToolsImpl.class;
                // MONITORENTER : com.anaptecs.jeaf.tools.impl.xml.XMLToolsImpl.class
                lCount = ++noPooledObjectCounter;
                // MONITOREXIT : object
                if (noPooledObjectCounter > 1) {
                    XFun.getTrace().writeEmergencyTrace("Max. waiting time for pooled document builder exeeded. Waited " + TIMEOUT.getTimeout() + "ns. This problem may occur once during startup. If you see this message more often inside your logs then please check your environment configuration. The pool size can be configured using system property '" + DOCUMENT_BUILDER_POOL_SIZE_PROPERTY + "'. Current pool size is " + this.poolSize + ". Problem occurred " + lCount + " times.", null, TraceLevel.INFO);
                }
                lDocumentBuilder = this.createDocumentBuilder(pValidating);
            }
            Document lDocument = pSystemID != null ? lDocumentBuilder.parse(lBufferedInputStream, pSystemID) : lDocumentBuilder.parse(lBufferedInputStream);
            lDocument.getDocumentElement().normalize();
            object = lDocument;
            return object;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_PARSE_XML_FILE, (Throwable)e, new String[]{lStreamName});
        }
        catch (PoolException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CLAIM_POOLED_DOCUMENT_BUILDER, (Throwable)e, new String[]{Integer.toString(this.poolSize)});
        }
        catch (InterruptedException e) {
            XFun.getTrace().warn("Thread interrupted when trying to get XML Document Builder from pool.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_CLAIM_POOLED_DOCUMENT_BUILDER, (Throwable)e, new String[]{Integer.toString(this.poolSize)});
        }
        finally {
            if (lPooledProxy != null) {
                lPooledProxy.release();
            }
        }
    }

    public Document parseString(String pXMLEncodedString, boolean pValidating, String pSystemID, String pStringName) throws JEAFSystemException {
        Check.checkInvalidParameterNull((Object)pStringName, (String)"pStringName");
        ByteArrayInputStream lInputStream = new ByteArrayInputStream(pXMLEncodedString.getBytes(Charset.defaultCharset()));
        return this.parseInputStream(lInputStream, pValidating, pSystemID, pStringName);
    }

    public void writeDocument(Document pDocument, OutputStream pOutputStream) {
        this.writeDocument(pDocument, null, pOutputStream);
    }

    public void writeDocument(Document pDocument, DocumentProperties pDocumentProperties, OutputStream pOutputStream) {
        Check.checkInvalidParameterNull((Object)pDocument, (String)"pDocument");
        this.writeNode(pDocument, pDocumentProperties, pOutputStream);
    }

    private void writeNode(Node pNode, DocumentProperties pDocumentProperties, OutputStream pOutputStream) {
        Check.checkInvalidParameterNull((Object)pNode, (String)"pNode");
        Check.checkInvalidParameterNull((Object)pOutputStream, (String)"pOutputStream");
        DOMSource lSource = new DOMSource(pNode);
        StreamResult lStreamResult = new StreamResult(pOutputStream);
        try {
            Transformer lTransformer = this.createTransformer(pDocumentProperties);
            lTransformer.transform(lSource, lStreamResult);
        }
        catch (TransformerException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_WRITE_XML, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    public String toString(Document pDocument) {
        return this.toString(pDocument, null);
    }

    public String toString(Document pDocument, DocumentProperties pDocumentProperties) {
        ByteArrayOutputStream lOutputStream = new ByteArrayOutputStream();
        this.writeDocument(pDocument, pDocumentProperties, lOutputStream);
        return lOutputStream.toString();
    }

    private Transformer createTransformer(DocumentProperties pDocumentProperties) {
        if (pDocumentProperties == null) {
            pDocumentProperties = DocumentProperties.Builder.newBuilder().build();
        }
        try {
            String lDoctypeSystem;
            TransformerFactory lFactory = TransformerFactory.newInstance();
            lFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            lFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            try {
                lFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer lTransformer = lFactory.newTransformer();
            lTransformer.setOutputProperty("omit-xml-declaration", this.booleanToYesNo(pDocumentProperties.omitXMLDeclaration()));
            lTransformer.setOutputProperty("version", pDocumentProperties.getVersion());
            lTransformer.setOutputProperty("encoding", pDocumentProperties.getEncoding());
            String lDoctypePublic = pDocumentProperties.getDoctypePublic();
            if (lDoctypePublic != null) {
                lTransformer.setOutputProperty("doctype-public", lDoctypePublic);
            }
            if ((lDoctypeSystem = pDocumentProperties.getDoctypeSystem()) != null) {
                lTransformer.setOutputProperty("doctype-system", lDoctypeSystem);
            }
            lTransformer.setOutputProperty("method", "xml");
            lTransformer.setOutputProperty("cdata-section-elements", pDocumentProperties.getCDataSectionElements());
            lTransformer.setOutputProperty("indent", this.booleanToYesNo(pDocumentProperties.isIndent()));
            return lTransformer;
        }
        catch (TransformerException e) {
            throw new JEAFSystemException(ToolsMessages.UNABLE_TO_WRITE_XML, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    private String booleanToYesNo(boolean pValue) {
        String lYesNo = pValue ? "yes" : "no";
        return lYesNo;
    }

    public String toString(Element pElement) {
        return this.toString(pElement, true);
    }

    public String toString(Element pElement, boolean pIndent) {
        Check.checkInvalidParameterNull((Object)pElement, (String)"pElement");
        DocumentProperties.Builder lBuilder = DocumentProperties.Builder.newBuilder();
        lBuilder.omitXMLDeclaration(true);
        if (pElement.hasChildNodes()) {
            lBuilder.setIndent(pIndent);
        } else {
            lBuilder.setIndent(false);
        }
        ByteArrayOutputStream lOutputStream = new ByteArrayOutputStream();
        this.writeNode(pElement, lBuilder.build(), lOutputStream);
        return lOutputStream.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element getSingleElement(String pElementName, Element pElement, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pElement, (String)"pElement");
        Check.checkInvalidParameterNull((Object)pElementName, (String)pElementName);
        NodeList lElementsByTagName = pElement.getElementsByTagName(pElementName);
        int lSize = lElementsByTagName.getLength();
        if (lSize == 0) {
            if (pRequired) throw new JEAFSystemException(ToolsMessages.REQUIRED_ELEMENT_NOT_FOUND, new String[]{pElementName});
            return null;
        }
        if (lSize != 1) throw new JEAFSystemException(ToolsMessages.ELEMENT_NOT_UNIQUE, new String[]{pElementName});
        return (Element)lElementsByTagName.item(0);
    }

    public Element getSingleElement(String pElementName, Document pDocument, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pDocument, (String)"pDocument");
        return this.getSingleElement(pElementName, pDocument.getDocumentElement(), pRequired);
    }

    public List<Element> getDescendantElements(String pElementName, Element pElement, boolean pRequired) {
        List<Element> lElements;
        Check.checkInvalidParameterNull((Object)pElementName, (String)"pElementName");
        Check.checkInvalidParameterNull((Object)pElement, (String)"pElement");
        NodeList lNodeList = pElement.getElementsByTagName(pElementName);
        int lElementCount = lNodeList.getLength();
        if (lElementCount > 0) {
            lElements = new ArrayList(lElementCount);
            for (int i = 0; i < lElementCount; ++i) {
                lElements.add((Element)lNodeList.item(i));
            }
        } else if (!pRequired) {
            lElements = Collections.emptyList();
        } else {
            throw new JEAFSystemException(ToolsMessages.REQUIRED_ELEMENT_NOT_FOUND, new String[]{pElementName});
        }
        return lElements;
    }

    public List<Element> getDescendantElements(String pElementName, Document pDocument, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pDocument, (String)"pDocument");
        return this.getDescendantElements(pElementName, pDocument.getDocumentElement(), pRequired);
    }

    public String getElementValue(Element pElement, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pElement, (String)"pElement");
        NodeList lChildNodes = pElement.getChildNodes();
        String lElementValue = null;
        for (int i = 0; i < lChildNodes.getLength(); ++i) {
            Node lNextNode = lChildNodes.item(i);
            String lNodeValue = lNextNode.getNodeValue().trim();
            if (lNodeValue.length() <= 0) continue;
            lElementValue = lNodeValue;
            break;
        }
        if (lElementValue != null || !pRequired) {
            return lElementValue;
        }
        throw new JEAFSystemException(ToolsMessages.ELEMENT_VALUE_MISSING, new String[]{pElement.getNodeName()});
    }

    public String getElementValueFromSubtree(String pElementName, Element pElement, boolean pRequired) {
        Element lElement = this.getSingleElement(pElementName, pElement, pRequired);
        String lElementValue = lElement != null ? this.getElementValue(lElement, pRequired) : null;
        return lElementValue;
    }

    public String getElementValueFromSubtree(String pElementName, Document pDocument, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pDocument, (String)"pDocument");
        return this.getElementValueFromSubtree(pElementName, pDocument.getDocumentElement(), pRequired);
    }

    public Element getFirstChildElement(String pElementName, Element pElement, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pElement, (String)"pElement");
        Check.checkInvalidParameterNull((Object)pElementName, (String)pElementName);
        Element lFirstChildElement = null;
        NodeList lChildNodes = pElement.getChildNodes();
        for (int i = 0; i < lChildNodes.getLength(); ++i) {
            Node lItem = lChildNodes.item(i);
            if (!pElementName.equals(lItem.getNodeName())) continue;
            lFirstChildElement = (Element)lItem;
            break;
        }
        if (lFirstChildElement != null || !pRequired) {
            return lFirstChildElement;
        }
        throw new JEAFSystemException(ToolsMessages.REQUIRED_ELEMENT_NOT_FOUND, new String[]{pElementName});
    }

    public List<Element> getChildren(String pElementName, Element pElement, boolean pRequired) {
        ArrayList<Element> lFilteredElements = new ArrayList<Element>();
        NodeList lChildNodes = pElement.getChildNodes();
        for (int i = 0; i < lChildNodes.getLength(); ++i) {
            Node lItem = lChildNodes.item(i);
            if (!pElementName.equals(lItem.getNodeName())) continue;
            lFilteredElements.add((Element)lItem);
        }
        if (!lFilteredElements.isEmpty() || !pRequired) {
            return lFilteredElements;
        }
        throw new JEAFSystemException(ToolsMessages.REQUIRED_ELEMENT_NOT_FOUND, new String[]{pElementName});
    }

    public String getAttributeValue(Element pElement, String pAttributeName, boolean pRequired) {
        Check.checkInvalidParameterNull((Object)pElement, (String)"pElement");
        Check.checkInvalidParameterNull((Object)pAttributeName, (String)"pAttributeName");
        String lValue = pElement.hasAttribute(pAttributeName) ? pElement.getAttribute(pAttributeName) : null;
        if (!pRequired) {
            return lValue;
        }
        if (lValue != null) {
            return lValue;
        }
        throw new JEAFSystemException(ToolsMessages.REQUIRED_ATTRIBUTE_NOT_FOUND, new String[]{pAttributeName, pElement.getTagName()});
    }

    public static int getNoPooledObjectCounter() {
        return noPooledObjectCounter;
    }

    public Class<?> getStartupCompletedEventSource() {
        return Tools.class;
    }

    public void traceStartupInfo(Trace pTrace, TraceLevel pTraceLevel) {
        String lClass = DocumentBuilderFactory.newInstance().getClass().getName();
        pTrace.writeInitInfo("Using class " + lClass + " as JAXP XML library", pTraceLevel);
    }
}

