/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.plugin.core;

import com.asyncapi.plugin.core.generator.GenerationStrategy;
import com.asyncapi.plugin.core.generator.exception.AsyncAPISchemaGenerationException;
import com.asyncapi.plugin.core.generator.settings.GenerationRules;
import com.asyncapi.plugin.core.generator.settings.GenerationSettings;
import com.asyncapi.plugin.core.generator.settings.GenerationSources;
import com.asyncapi.plugin.core.generator.settings.SchemaFileSettings;
import com.asyncapi.plugin.core.generator.strategy.JsonGenerationStrategy;
import com.asyncapi.plugin.core.generator.strategy.YamlGenerationStrategy;
import com.asyncapi.plugin.core.logging.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BW\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0016H&R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/asyncapi/plugin/core/AsyncAPISchemaGenerator;", "", "classNames", "", "", "packageNames", "includeNulls", "", "prettyPrint", "schemaFileNamePostfix", "schemaFileFormat", "schemaFilePath", "([Ljava/lang/String;[Ljava/lang/String;ZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "[Ljava/lang/String;", "checkRequiredParameters", "", "chooseGenerationStrategy", "Lcom/asyncapi/plugin/core/generator/GenerationStrategy;", "generate", "resolveClassLoader", "Ljava/lang/ClassLoader;", "resolveLogger", "Lcom/asyncapi/plugin/core/logging/Logger;", "asyncapi-plugin-core"})
public abstract class AsyncAPISchemaGenerator {
    private final String[] classNames;
    private final String[] packageNames;
    private final boolean includeNulls;
    private final boolean prettyPrint;
    private final String schemaFileNamePostfix;
    private final String schemaFileFormat;
    private final String schemaFilePath;

    @NotNull
    public abstract Logger resolveLogger();

    @NotNull
    public abstract ClassLoader resolveClassLoader();

    public void generate() throws IllegalArgumentException, AsyncAPISchemaGenerationException {
        this.checkRequiredParameters();
        GenerationStrategy generationStrategy = this.chooseGenerationStrategy();
        generationStrategy.generate();
    }

    private final void checkRequiredParameters() throws IllegalArgumentException {
        this.resolveLogger().info("required parameters: checking...");
        String[] stringArray = this.classNames;
        boolean bl = false;
        if (stringArray.length == 0) {
            stringArray = this.packageNames;
            bl = false;
            if (stringArray.length == 0) {
                this.resolveLogger().error("required parameters: classNames or packageNames are required");
                throw (Throwable)new IllegalArgumentException("classNames or packageNames are required");
            }
        }
        this.resolveLogger().info("required parameters: ok");
    }

    private final GenerationStrategy chooseGenerationStrategy() throws IllegalArgumentException {
        GenerationStrategy generationStrategy;
        GenerationSources generationSources = new GenerationSources(this.classNames, this.packageNames, this.resolveClassLoader());
        GenerationRules generationRules = new GenerationRules(this.includeNulls, this.prettyPrint);
        SchemaFileSettings schemaFileSettings = new SchemaFileSettings(this.schemaFilePath, this.schemaFileFormat, this.schemaFileNamePostfix);
        GenerationSettings generationSettings = new GenerationSettings(this.resolveLogger(), generationSources, generationRules, schemaFileSettings);
        this.resolveLogger().info("generation strategy: checking...");
        String string = this.schemaFileFormat;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "json": {
                this.resolveLogger().info("generation strategy: json");
                generationStrategy = new JsonGenerationStrategy(generationSettings);
                break;
            }
            case "yaml": {
                this.resolveLogger().info("generation strategy: yaml");
                generationStrategy = new YamlGenerationStrategy(generationSettings);
                break;
            }
            default: {
                this.resolveLogger().error("generation strategy: " + this.schemaFileFormat + " not recognized");
                throw (Throwable)new IllegalArgumentException("schemaFileFormat=" + this.schemaFileFormat + " not recognized");
            }
        }
        return generationStrategy;
    }

    public AsyncAPISchemaGenerator(@NotNull String[] classNames, @NotNull String[] packageNames, boolean includeNulls, boolean prettyPrint, @NotNull String schemaFileNamePostfix, @NotNull String schemaFileFormat, @NotNull String schemaFilePath) {
        Intrinsics.checkParameterIsNotNull((Object)classNames, (String)"classNames");
        Intrinsics.checkParameterIsNotNull((Object)packageNames, (String)"packageNames");
        Intrinsics.checkParameterIsNotNull((Object)schemaFileNamePostfix, (String)"schemaFileNamePostfix");
        Intrinsics.checkParameterIsNotNull((Object)schemaFileFormat, (String)"schemaFileFormat");
        Intrinsics.checkParameterIsNotNull((Object)schemaFilePath, (String)"schemaFilePath");
        this.classNames = classNames;
        this.packageNames = packageNames;
        this.includeNulls = includeNulls;
        this.prettyPrint = prettyPrint;
        this.schemaFileNamePostfix = schemaFileNamePostfix;
        this.schemaFileFormat = schemaFileFormat;
        this.schemaFilePath = schemaFilePath;
    }

    public /* synthetic */ AsyncAPISchemaGenerator(String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 2) != 0) {
            stringArray2 = new String[]{};
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            string = "asyncapi";
        }
        if ((n & 0x20) != 0) {
            string2 = "json";
        }
        if ((n & 0x40) != 0) {
            string3 = "generated/asyncapi";
        }
        this(stringArray, stringArray2, bl, bl2, string, string2, string3);
    }

    public AsyncAPISchemaGenerator() {
        this(null, null, false, false, null, null, null, 127, null);
    }
}

