/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.plugin.core.io;

import com.asyncapi.plugin.core.generator.exception.AsyncAPISchemaGenerationException;
import com.asyncapi.plugin.core.generator.settings.GenerationSources;
import com.asyncapi.plugin.core.logging.Logger;
import com.asyncapi.v2.model.AsyncAPI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0016J\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000bH\u0004J\u0012\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000bH\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/asyncapi/plugin/core/io/AsyncAPISchemaLoader;", "", "logger", "Lcom/asyncapi/plugin/core/logging/Logger;", "sources", "Lcom/asyncapi/plugin/core/generator/settings/GenerationSources;", "(Lcom/asyncapi/plugin/core/logging/Logger;Lcom/asyncapi/plugin/core/generator/settings/GenerationSources;)V", "load", "", "Ljava/lang/Class;", "loadClasses", "", "loadedClassesFromPackages", "asyncapi-plugin-core"})
public class AsyncAPISchemaLoader {
    private final Logger logger;
    private final GenerationSources sources;

    @NotNull
    public Set<Class<?>> load() throws AsyncAPISchemaGenerationException {
        this.logger.info("schemas loader: looking for schemas");
        Set<Class<?>> loadedClasses = this.loadClasses();
        Set<Class<?>> loadedClassesFromPackages = this.loadedClassesFromPackages();
        return SetsKt.plus(loadedClasses, (Iterable)loadedClassesFromPackages);
    }

    @NotNull
    protected final Set<Class<?>> loadClasses() throws AsyncAPISchemaGenerationException {
        String[] classesToLoad = this.sources.getClasses();
        boolean bl = false;
        Set loadedClasses = new LinkedHashSet();
        this.logger.info("[classes]: loading...");
        String[] stringArray = classesToLoad;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            this.logger.info("[classes]: nothing to load");
            boolean bl3 = false;
            return new LinkedHashSet();
        }
        this.logger.info("[classes]: loading " + classesToLoad.length + " classes");
        String[] $this$forEach$iv = classesToLoad;
        boolean $i$f$forEach = false;
        String[] stringArray2 = $this$forEach$iv;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String className = element$iv = stringArray2[i];
            boolean bl4 = false;
            this.logger.info("[classes]: loading " + className);
            try {
                Class<?> clazz = this.sources.getClassLoader().loadClass(className);
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"sources.classLoader.loadClass(className)");
                loadedClasses.add(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logger.error("[classes]: can't load " + className + " - " + classNotFoundException.getMessage());
                throw (Throwable)new AsyncAPISchemaGenerationException("Can't load class: " + className, classNotFoundException);
            }
        }
        if (loadedClasses.isEmpty()) {
            this.logger.info("[classes]: no classes loaded");
        } else {
            this.logger.info("[classes]: loaded " + loadedClasses.size() + " classes");
        }
        return loadedClasses;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<Class<?>> loadedClassesFromPackages() throws AsyncAPISchemaGenerationException {
        String[] packagesToScan = this.sources.getPackages();
        boolean bl = false;
        Set loadedClassesFromPackages = new LinkedHashSet();
        this.logger.info("[packages]: searching...");
        String[] stringArray = packagesToScan;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            this.logger.info("[packages]: no classes found to load");
            boolean bl3 = false;
            return new LinkedHashSet();
        }
        this.logger.info("[packages]: scanning " + packagesToScan.length + " packages");
        String[] $this$forEach$iv = packagesToScan;
        boolean $i$f$forEach = false;
        String[] stringArray2 = $this$forEach$iv;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String packageName = element$iv = stringArray2[i];
            boolean bl4 = false;
            this.logger.info("[packages]: scanning " + packageName);
            try {
                void $this$mapTo$iv$iv;
                ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().forPackages(new String[]{packageName}).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).addScanners(new Scanner[]{(Scanner)new SubTypesScanner(false)});
                ClassLoader classLoader = this.sources.getClassLoader();
                if (classLoader == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.net.URLClassLoader");
                }
                Object[] objectArray = ((URLClassLoader)classLoader).getURLs();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"(sources.classLoader as URLClassLoader).urLs");
                Reflections reflections = new Reflections((Configuration)configurationBuilder.addUrls((Collection)ArraysKt.asList((Object[])objectArray)).addClassLoader(this.sources.getClassLoader()));
                Set foundClasses = reflections.getSubTypesOf(AsyncAPI.class);
                this.logger.info("[packages]: found " + foundClasses.size() + " classes in " + packageName);
                Set set = foundClasses;
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"foundClasses");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Class clazz = (Class)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    void v4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                    String string = v4.getName();
                    collection.add(string);
                }
                Iterable $this$forEach$iv2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it = (String)element$iv2;
                    boolean bl6 = false;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    this.logger.info(string);
                }
                loadedClassesFromPackages.addAll(foundClasses);
                continue;
            }
            catch (Exception exception) {
                this.logger.error("[classes]: can't load classes from " + packageName + " - " + exception.getMessage());
                throw (Throwable)new AsyncAPISchemaGenerationException("Can't load classes from: " + packageName, exception);
            }
        }
        if (loadedClassesFromPackages.isEmpty()) {
            this.logger.info("[packages]: no classes loaded");
        } else {
            this.logger.info("[packages]: loaded " + loadedClassesFromPackages.size() + " classes");
        }
        return loadedClassesFromPackages;
    }

    public AsyncAPISchemaLoader(@NotNull Logger logger, @NotNull GenerationSources sources) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)sources, (String)"sources");
        this.logger = logger;
        this.sources = sources;
    }
}

