package com.impossibl.jdbc.spy;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

interface ConnectionListener {
  void getClientInfo(String targetSuccessResult, String name);

  void getClientInfo(Throwable targetFailureCause, String name);

  void getCatalog(String targetSuccessResult);

  void getCatalog(Throwable targetFailureCause);

  void createClob(Clob targetSuccessResult);

  void createClob(Throwable targetFailureCause);

  void releaseSavepoint(Savepoint savepoint);

  void releaseSavepoint(Throwable targetFailureCause, Savepoint savepoint);

  void isClosed(boolean targetSuccessResult);

  void isClosed(Throwable targetFailureCause);

  void getWarnings(SQLWarning targetSuccessResult);

  void getWarnings(Throwable targetFailureCause);

  void createStatement(Statement targetSuccessResult);

  void createStatement(Throwable targetFailureCause);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void getSchema(String targetSuccessResult);

  void getSchema(Throwable targetFailureCause);

  void prepareCall(CallableStatement targetSuccessResult, String sql);

  void prepareCall(Throwable targetFailureCause, String sql);

  void createBlob(Blob targetSuccessResult);

  void createBlob(Throwable targetFailureCause);

  void getNetworkTimeout(int targetSuccessResult);

  void getNetworkTimeout(Throwable targetFailureCause);

  void setSavepoint(Savepoint targetSuccessResult);

  void setSavepoint(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int[] columnIndexes);

  void prepareStatement(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void createSQLXML(SQLXML targetSuccessResult);

  void createSQLXML(Throwable targetFailureCause);

  void getTransactionIsolation(int targetSuccessResult);

  void getTransactionIsolation(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency);

  void setSavepoint(Savepoint targetSuccessResult, String name);

  void setSavepoint(Throwable targetFailureCause, String name);

  void createStruct(Struct targetSuccessResult, String typeName, Object[] attributes);

  void createStruct(Throwable targetFailureCause, String typeName, Object[] attributes);

  void setAutoCommit(boolean autoCommit);

  void setAutoCommit(Throwable targetFailureCause, boolean autoCommit);

  void getAutoCommit(boolean targetSuccessResult);

  void getAutoCommit(Throwable targetFailureCause);

  void rollback();

  void rollback(Throwable targetFailureCause);

  void setClientInfo(Properties properties);

  void setClientInfo(Throwable targetFailureCause, Properties properties);

  void rollback(Savepoint savepoint);

  void rollback(Throwable targetFailureCause, Savepoint savepoint);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int autoGeneratedKeys);

  void prepareStatement(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void isWrapperFor(boolean targetSuccessResult, Class<?> iface);

  void isWrapperFor(Throwable targetFailureCause, Class<?> iface);

  void setCatalog(String catalog);

  void setCatalog(Throwable targetFailureCause, String catalog);

  void setReadOnly(boolean readOnly);

  void setReadOnly(Throwable targetFailureCause, boolean readOnly);

  void getHoldability(int targetSuccessResult);

  void getHoldability(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareStatement(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void setTransactionIsolation(int level);

  void setTransactionIsolation(Throwable targetFailureCause, int level);

  void prepareCall(CallableStatement targetSuccessResult, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void prepareCall(Throwable targetFailureCause, String sql, int resultSetType,
      int resultSetConcurrency, int resultSetHoldability);

  void commit();

  void commit(Throwable targetFailureCause);

  void setHoldability(int holdability);

  void setHoldability(Throwable targetFailureCause, int holdability);

  void isReadOnly(boolean targetSuccessResult);

  void isReadOnly(Throwable targetFailureCause);

  void setClientInfo(String name, String value);

  void setClientInfo(Throwable targetFailureCause, String name, String value);

  void createArrayOf(Array targetSuccessResult, String typeName, Object[] elements);

  void createArrayOf(Throwable targetFailureCause, String typeName, Object[] elements);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql);

  void prepareStatement(Throwable targetFailureCause, String sql);

  void getMetaData(DatabaseMetaData targetSuccessResult);

  void getMetaData(Throwable targetFailureCause);

  void setTypeMap(Map<String, Class<?>> map);

  void setTypeMap(Throwable targetFailureCause, Map<String, Class<?>> map);

  void isValid(boolean targetSuccessResult, int timeout);

  void isValid(Throwable targetFailureCause, int timeout);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency);

  void getTypeMap(Map<String, Class<?>> targetSuccessResult);

  void getTypeMap(Throwable targetFailureCause);

  void createNClob(NClob targetSuccessResult);

  void createNClob(Throwable targetFailureCause);

  void getClientInfo(Properties targetSuccessResult);

  void getClientInfo(Throwable targetFailureCause);

  void createStatement(Statement targetSuccessResult, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void createStatement(Throwable targetFailureCause, int resultSetType, int resultSetConcurrency,
      int resultSetHoldability);

  void setNetworkTimeout(Executor executor, int milliseconds);

  void setNetworkTimeout(Throwable targetFailureCause, Executor executor, int milliseconds);

  void nativeSQL(String targetSuccessResult, String sql);

  void nativeSQL(Throwable targetFailureCause, String sql);

  void setSchema(String schema);

  void setSchema(Throwable targetFailureCause, String schema);

  void abort(Executor executor);

  void abort(Throwable targetFailureCause, Executor executor);

  void clearWarnings();

  void clearWarnings(Throwable targetFailureCause);

  void prepareStatement(PreparedStatement targetSuccessResult, String sql, String[] columnNames);

  void prepareStatement(Throwable targetFailureCause, String sql, String[] columnNames);

  <T> void unwrap(T targetSuccessResult, Class<T> iface);

  <T> void unwrap(Throwable targetFailureCause, Class<T> iface);

  void close();

  void close(Throwable targetFailureCause);

  ClobListener newClobListener();

  StatementListener newStatementListener();

  CallableStatementListener newCallableStatementListener();

  BlobListener newBlobListener();

  SavepointListener newSavepointListener();

  PreparedStatementListener newPreparedStatementListener();

  SQLXMLListener newSQLXMLListener();

  StructListener newStructListener();

  ArrayListener newArrayListener();

  DatabaseMetaDataListener newDatabaseMetaDataListener();

  NClobListener newNClobListener();
}
