package com.impossibl.jdbc.spy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLWarning;

interface StatementListener {
  void getMaxRows(int targetSuccessResult);

  void getMaxRows(Throwable targetFailureCause);

  void getMoreResults(boolean targetSuccessResult, int current);

  void getMoreResults(Throwable targetFailureCause, int current);

  void setCursorName(String name);

  void setCursorName(Throwable targetFailureCause, String name);

  void getResultSet(ResultSet targetSuccessResult);

  void getResultSet(Throwable targetFailureCause);

  void execute(boolean targetSuccessResult, String sql, int[] columnIndexes);

  void execute(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void isWrapperFor(boolean targetSuccessResult, Class<?> iface);

  void isWrapperFor(Throwable targetFailureCause, Class<?> iface);

  void getResultSetConcurrency(int targetSuccessResult);

  void getResultSetConcurrency(Throwable targetFailureCause);

  void getGeneratedKeys(ResultSet targetSuccessResult);

  void getGeneratedKeys(Throwable targetFailureCause);

  void executeQuery(ResultSet targetSuccessResult, String sql);

  void executeQuery(Throwable targetFailureCause, String sql);

  void getFetchSize(int targetSuccessResult);

  void getFetchSize(Throwable targetFailureCause);

  void setMaxRows(int max);

  void setMaxRows(Throwable targetFailureCause, int max);

  void getMoreResults(boolean targetSuccessResult);

  void getMoreResults(Throwable targetFailureCause);

  void execute(boolean targetSuccessResult, String sql, String[] columnNames);

  void execute(Throwable targetFailureCause, String sql, String[] columnNames);

  void execute(boolean targetSuccessResult, String sql, int autoGeneratedKeys);

  void execute(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void getLargeMaxRows(long targetSuccessResult);

  void getLargeMaxRows(Throwable targetFailureCause);

  void addBatch(String sql);

  void addBatch(Throwable targetFailureCause, String sql);

  void getConnection(Connection targetSuccessResult);

  void getConnection(Throwable targetFailureCause);

  void executeUpdate(int targetSuccessResult, String sql, int autoGeneratedKeys);

  void executeUpdate(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void getMaxFieldSize(int targetSuccessResult);

  void getMaxFieldSize(Throwable targetFailureCause);

  void executeUpdate(int targetSuccessResult, String sql);

  void executeUpdate(Throwable targetFailureCause, String sql);

  void isPoolable(boolean targetSuccessResult);

  void isPoolable(Throwable targetFailureCause);

  void setFetchDirection(int direction);

  void setFetchDirection(Throwable targetFailureCause, int direction);

  void executeLargeUpdate(long targetSuccessResult, String sql, int autoGeneratedKeys);

  void executeLargeUpdate(Throwable targetFailureCause, String sql, int autoGeneratedKeys);

  void close();

  void close(Throwable targetFailureCause);

  void getWarnings(SQLWarning targetSuccessResult);

  void getWarnings(Throwable targetFailureCause);

  void executeLargeUpdate(long targetSuccessResult, String sql);

  void executeLargeUpdate(Throwable targetFailureCause, String sql);

  void setQueryTimeout(int seconds);

  void setQueryTimeout(Throwable targetFailureCause, int seconds);

  void executeLargeUpdate(long targetSuccessResult, String sql, String[] columnNames);

  void executeLargeUpdate(Throwable targetFailureCause, String sql, String[] columnNames);

  void executeUpdate(int targetSuccessResult, String sql, int[] columnIndexes);

  void executeUpdate(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void setPoolable(boolean poolable);

  void setPoolable(Throwable targetFailureCause, boolean poolable);

  void isClosed(boolean targetSuccessResult);

  void isClosed(Throwable targetFailureCause);

  void setEscapeProcessing(boolean enable);

  void setEscapeProcessing(Throwable targetFailureCause, boolean enable);

  void executeLargeUpdate(long targetSuccessResult, String sql, int[] columnIndexes);

  void executeLargeUpdate(Throwable targetFailureCause, String sql, int[] columnIndexes);

  void setFetchSize(int rows);

  void setFetchSize(Throwable targetFailureCause, int rows);

  void execute(boolean targetSuccessResult, String sql);

  void execute(Throwable targetFailureCause, String sql);

  void isCloseOnCompletion(boolean targetSuccessResult);

  void isCloseOnCompletion(Throwable targetFailureCause);

  <T> void unwrap(T targetSuccessResult, Class<T> iface);

  <T> void unwrap(Throwable targetFailureCause, Class<T> iface);

  void getUpdateCount(int targetSuccessResult);

  void getUpdateCount(Throwable targetFailureCause);

  void setMaxFieldSize(int max);

  void setMaxFieldSize(Throwable targetFailureCause, int max);

  void getResultSetType(int targetSuccessResult);

  void getResultSetType(Throwable targetFailureCause);

  void executeBatch(int[] targetSuccessResult);

  void executeBatch(Throwable targetFailureCause);

  void clearBatch();

  void clearBatch(Throwable targetFailureCause);

  void clearWarnings();

  void clearWarnings(Throwable targetFailureCause);

  void closeOnCompletion();

  void closeOnCompletion(Throwable targetFailureCause);

  void executeUpdate(int targetSuccessResult, String sql, String[] columnNames);

  void executeUpdate(Throwable targetFailureCause, String sql, String[] columnNames);

  void setLargeMaxRows(long max);

  void setLargeMaxRows(Throwable targetFailureCause, long max);

  void cancel();

  void cancel(Throwable targetFailureCause);

  void getQueryTimeout(int targetSuccessResult);

  void getQueryTimeout(Throwable targetFailureCause);

  void getResultSetHoldability(int targetSuccessResult);

  void getResultSetHoldability(Throwable targetFailureCause);

  void getLargeUpdateCount(long targetSuccessResult);

  void getLargeUpdateCount(Throwable targetFailureCause);

  void executeLargeBatch(long[] targetSuccessResult);

  void executeLargeBatch(Throwable targetFailureCause);

  void getFetchDirection(int targetSuccessResult);

  void getFetchDirection(Throwable targetFailureCause);

  ResultSetListener newResultSetListener();

  ConnectionListener newConnectionListener();
}
