/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.VerificationException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.PemUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jws.JWSBuilder;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jws.JWSInput;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jws.crypto.RSAProvider;
import java.security.PrivateKey;
import java.security.PublicKey;

public class KeyPairVerifier {
    public static void verify(String privateKeyPem, String publicKeyPem) throws VerificationException {
        PublicKey publicKey;
        PrivateKey privateKey;
        try {
            privateKey = PemUtils.decodePrivateKey(privateKeyPem);
        }
        catch (Exception e) {
            throw new VerificationException("Failed to decode private key");
        }
        try {
            publicKey = PemUtils.decodePublicKey(publicKeyPem);
        }
        catch (Exception e) {
            throw new VerificationException("Failed to decode public key");
        }
        try {
            String jws = new JWSBuilder().content("content".getBytes()).rsa256(privateKey);
            if (!RSAProvider.verify(new JWSInput(jws), publicKey)) {
                throw new VerificationException("Keys don't match");
            }
        }
        catch (Exception e) {
            throw new VerificationException("Keys don't match");
        }
    }
}

