/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.KeycloakPrincipal;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.TokenVerifier;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterTokenStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.RefreshableKeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.rotation.AdapterTokenVerifier;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.VerificationException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.KeycloakUriBuilder;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jws.JWSInput;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jws.JWSInputException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.AccessToken;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.IDToken;

public class CookieTokenStore {
    private static final Logger log = Logger.getLogger(CookieTokenStore.class);
    private static final String DELIM = "___";

    public static void setTokenCookie(KeycloakDeployment deployment, HttpFacade facade, RefreshableKeycloakSecurityContext session) {
        log.debugf("Set new %s cookie now", (Object)"KEYCLOAK_ADAPTER_STATE");
        String accessToken = session.getTokenString();
        String idToken = session.getIdTokenString();
        String refreshToken = session.getRefreshToken();
        String cookie = accessToken + DELIM + idToken + DELIM + refreshToken;
        String cookiePath = CookieTokenStore.getCookiePath(deployment, facade);
        facade.getResponse().setCookie("KEYCLOAK_ADAPTER_STATE", cookie, cookiePath, null, -1, deployment.getSslRequired().isRequired(facade.getRequest().getRemoteAddr()), true);
    }

    public static KeycloakPrincipal<RefreshableKeycloakSecurityContext> getPrincipalFromCookie(KeycloakDeployment deployment, HttpFacade facade, AdapterTokenStore tokenStore) {
        HttpFacade.Cookie cookie = facade.getRequest().getCookie("KEYCLOAK_ADAPTER_STATE");
        if (cookie == null) {
            log.debug("Not found adapter state cookie in current request");
            return null;
        }
        String cookieVal = cookie.getValue();
        String[] tokens = cookieVal.split(DELIM);
        if (tokens.length != 3) {
            log.warnf("Invalid format of %s cookie. Count of tokens: %s, expected 3", (Object)"KEYCLOAK_ADAPTER_STATE", (Object)tokens.length);
            return null;
        }
        String accessTokenString = tokens[0];
        String idTokenString = tokens[1];
        String refreshTokenString = tokens[2];
        try {
            IDToken idToken;
            TokenVerifier<AccessToken> tokenVerifier = AdapterTokenVerifier.createVerifier(accessTokenString, deployment, true, AccessToken.class).checkActive(false).verify();
            AccessToken accessToken = tokenVerifier.getToken();
            if (idTokenString != null && idTokenString.length() > 0) {
                try {
                    JWSInput input = new JWSInput(idTokenString);
                    idToken = input.readJsonContent(IDToken.class);
                }
                catch (JWSInputException e) {
                    throw new VerificationException(e);
                }
            } else {
                idToken = null;
            }
            log.debug("Token Verification succeeded!");
            RefreshableKeycloakSecurityContext secContext = new RefreshableKeycloakSecurityContext(deployment, tokenStore, accessTokenString, accessToken, idTokenString, idToken, refreshTokenString);
            return new KeycloakPrincipal<RefreshableKeycloakSecurityContext>(AdapterUtils.getPrincipalName(deployment, accessToken), secContext);
        }
        catch (VerificationException ve) {
            log.warn((Object)"Failed verify token", ve);
            return null;
        }
    }

    public static void removeCookie(KeycloakDeployment deployment, HttpFacade facade) {
        String cookiePath = CookieTokenStore.getCookiePath(deployment, facade);
        facade.getResponse().resetCookie("KEYCLOAK_ADAPTER_STATE", cookiePath);
    }

    static String getCookiePath(KeycloakDeployment deployment, HttpFacade facade) {
        String path;
        String string = path = deployment.getAdapterStateCookiePath() == null ? "" : deployment.getAdapterStateCookiePath().trim();
        if (path.startsWith("/")) {
            return path;
        }
        String contextPath = CookieTokenStore.getContextPath(facade);
        StringBuilder cookiePath = new StringBuilder(contextPath);
        if (!contextPath.endsWith("/") && !path.isEmpty()) {
            cookiePath.append("/");
        }
        return cookiePath.append(path).toString();
    }

    static String getContextPath(HttpFacade facade) {
        String uri = facade.getRequest().getURI();
        String path = KeycloakUriBuilder.fromUri(uri).getPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        int index = path.indexOf("/", 1);
        return index == -1 ? path : path.substring(0, index);
    }
}

