/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters;

import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.HttpClientAdapterException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.util.JsonSerialization;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpAdapterUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T sendJsonHttpRequest(KeycloakDeployment deployment, HttpRequestBase httpRequest, Class<T> clazz) throws HttpClientAdapterException {
        try {
            HttpResponse response = deployment.getClient().execute((HttpUriRequest)httpRequest);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                HttpAdapterUtils.close(response);
                throw new HttpClientAdapterException("Unexpected status = " + status);
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new HttpClientAdapterException("There was no entity.");
            }
            InputStream is = entity.getContent();
            try {
                T t = JsonSerialization.readValue(is, clazz);
                return t;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new HttpClientAdapterException("IO error", e);
        }
    }

    private static void close(HttpResponse response) {
        if (response.getEntity() != null) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

