/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.ServerRequest;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.HostUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.Time;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NodesRegistrationManagement {
    private static final Logger log = Logger.getLogger(NodesRegistrationManagement.class);
    private final Map<String, NodeRegistrationContext> nodeRegistrations = new ConcurrentHashMap<String, NodeRegistrationContext>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void tryRegister(final KeycloakDeployment resolvedDeployment) {
        String registrationUri;
        if (resolvedDeployment.isRegisterNodeAtStartup() && this.needRefreshRegistration(registrationUri = resolvedDeployment.getRegisterNodeUrl(), resolvedDeployment)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (NodesRegistrationManagement.this.needRefreshRegistration(registrationUri, resolvedDeployment)) {
                        NodesRegistrationManagement.this.sendRegistrationEvent(resolvedDeployment);
                    }
                }
            };
            this.executor.execute(runnable);
        }
    }

    private boolean needRefreshRegistration(String registrationUri, KeycloakDeployment resolvedDeployment) {
        NodeRegistrationContext currentRegistration = this.nodeRegistrations.get(registrationUri);
        if (currentRegistration == null) {
            return true;
        }
        return currentRegistration.lastRegistrationTime + resolvedDeployment.getRegisterNodePeriod() < Time.currentTime();
    }

    public void stop() {
        this.executor.shutdownNow();
        Collection<NodeRegistrationContext> allRegistrations = this.nodeRegistrations.values();
        for (NodeRegistrationContext registration : allRegistrations) {
            this.sendUnregistrationEvent(registration.resolvedDeployment);
        }
    }

    protected void sendRegistrationEvent(KeycloakDeployment deployment) {
        String registrationUri = deployment.getRegisterNodeUrl();
        if (!this.needRefreshRegistration(registrationUri, deployment)) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        log.debug("Sending registration event right now");
        String host = HostUtils.getHostName();
        try {
            ServerRequest.invokeRegisterNode(deployment, host);
            NodeRegistrationContext regContext = new NodeRegistrationContext(Time.currentTime(), deployment);
            this.nodeRegistrations.put(deployment.getRegisterNodeUrl(), regContext);
            log.debugf("Node '%s' successfully registered in Keycloak", (Object)host);
        }
        catch (ServerRequest.HttpFailure failure) {
            log.error("failed to register node to keycloak");
            log.error("status from server: " + failure.getStatus());
            if (failure.getError() != null) {
                log.error("   " + failure.getError());
            }
        }
        catch (IOException e) {
            log.error((Object)"failed to register node to keycloak", e);
        }
    }

    protected boolean sendUnregistrationEvent(KeycloakDeployment deployment) {
        log.debug("Sending Unregistration event right now");
        String host = HostUtils.getHostName();
        try {
            ServerRequest.invokeUnregisterNode(deployment, host);
            log.debugf("Node '%s' successfully unregistered from Keycloak", (Object)host);
            return true;
        }
        catch (ServerRequest.HttpFailure failure) {
            log.error("failed to unregister node from keycloak");
            log.error("status from server: " + failure.getStatus());
            if (failure.getError() != null) {
                log.error("   " + failure.getError());
            }
            return false;
        }
        catch (IOException e) {
            log.error((Object)"failed to unregister node from keycloak", e);
            return false;
        }
    }

    public static class NodeRegistrationContext {
        private final Integer lastRegistrationTime;
        private final KeycloakDeployment resolvedDeployment;

        public NodeRegistrationContext(Integer lastRegTime, KeycloakDeployment deployment) {
            this.lastRegistrationTime = lastRegTime;
            this.resolvedDeployment = deployment;
        }
    }
}

