/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.BearerTokenRequestAuthenticator;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.OIDCAuthenticationError;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.AuthOutcome;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.spi.HttpFacade;

public class QueryParamterTokenRequestAuthenticator
extends BearerTokenRequestAuthenticator {
    public static final String ACCESS_TOKEN = "access_token";
    protected Logger log = Logger.getLogger(QueryParamterTokenRequestAuthenticator.class);

    public QueryParamterTokenRequestAuthenticator(KeycloakDeployment deployment) {
        super(deployment);
    }

    @Override
    public AuthOutcome authenticate(HttpFacade exchange) {
        if (!this.deployment.isOAuthQueryParameterEnabled()) {
            return AuthOutcome.NOT_ATTEMPTED;
        }
        this.tokenString = null;
        this.tokenString = this.getAccessTokenFromQueryParamter(exchange);
        if (this.tokenString == null || this.tokenString.trim().isEmpty()) {
            this.challenge = this.challengeResponse(exchange, OIDCAuthenticationError.Reason.NO_QUERY_PARAMETER_ACCESS_TOKEN, null, null);
            return AuthOutcome.NOT_ATTEMPTED;
        }
        return this.authenticateToken(exchange, this.tokenString);
    }

    String getAccessTokenFromQueryParamter(HttpFacade exchange) {
        try {
            if (exchange != null && exchange.getRequest() != null) {
                return exchange.getRequest().getQueryParamValue(ACCESS_TOKEN);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

