/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.AuthorizationContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.KeycloakSecurityContext;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterTokenStore;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.ServerRequest;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.rotation.AdapterTokenVerifier;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.VerificationException;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.Time;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.AccessToken;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.AccessTokenResponse;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.IDToken;
import java.io.IOException;

public class RefreshableKeycloakSecurityContext
extends KeycloakSecurityContext {
    protected static Logger log = Logger.getLogger(RefreshableKeycloakSecurityContext.class);
    protected transient KeycloakDeployment deployment;
    protected transient AdapterTokenStore tokenStore;
    protected String refreshToken;

    public RefreshableKeycloakSecurityContext() {
    }

    public RefreshableKeycloakSecurityContext(KeycloakDeployment deployment, AdapterTokenStore tokenStore, String tokenString, AccessToken token, String idTokenString, IDToken idToken, String refreshToken) {
        super(tokenString, token, idTokenString, idToken);
        this.deployment = deployment;
        this.tokenStore = tokenStore;
        this.refreshToken = refreshToken;
    }

    @Override
    public AccessToken getToken() {
        this.refreshExpiredToken(true);
        return super.getToken();
    }

    @Override
    public String getTokenString() {
        this.refreshExpiredToken(true);
        return super.getTokenString();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void logout(KeycloakDeployment deployment) {
        try {
            ServerRequest.invokeLogout(deployment, this.refreshToken);
        }
        catch (Exception e) {
            log.error((Object)"failed to invoke remote logout", e);
        }
    }

    public boolean isActive() {
        return this.token != null && this.token.isActive() && this.deployment != null && this.token.getIssuedAt() >= this.deployment.getNotBefore();
    }

    public boolean isTokenTimeToLiveSufficient(AccessToken token) {
        return token != null && token.getExpiration() - this.deployment.getTokenMinimumTimeToLive() > Time.currentTime();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    public void setCurrentRequestInfo(KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        this.deployment = deployment;
        this.tokenStore = tokenStore;
    }

    public boolean refreshExpiredToken(boolean checkActive) {
        if (checkActive) {
            if (log.isTraceEnabled()) {
                log.trace("checking whether to refresh.");
            }
            if (this.isActive() && this.isTokenTimeToLiveSufficient(this.token)) {
                return true;
            }
        }
        if (this.deployment == null || this.refreshToken == null) {
            return false;
        }
        if (!this.getRealm().equals(this.deployment.getRealm())) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("Doing refresh");
        }
        AccessTokenResponse response = null;
        try {
            response = ServerRequest.invokeRefresh(this.deployment, this.refreshToken);
        }
        catch (IOException e) {
            log.error((Object)"Refresh token failure", e);
            return false;
        }
        catch (ServerRequest.HttpFailure httpFailure) {
            log.error("Refresh token failure status: " + httpFailure.getStatus() + " " + httpFailure.getError());
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("received refresh response");
        }
        String tokenString = response.getToken();
        AccessToken token = null;
        try {
            AdapterTokenVerifier.VerifiedTokens tokens = AdapterTokenVerifier.verifyTokens(tokenString, response.getIdToken(), this.deployment);
            token = tokens.getAccessToken();
            log.debug("Token Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error("failed verification of token");
            return false;
        }
        if (!this.isTokenTimeToLiveSufficient(token)) {
            log.error("failed to refresh the token with a longer time-to-live than the minimum");
            return false;
        }
        if (response.getNotBeforePolicy() > this.deployment.getNotBefore()) {
            this.deployment.updateNotBefore(response.getNotBeforePolicy());
        }
        this.token = token;
        if (response.getRefreshToken() != null) {
            if (log.isTraceEnabled()) {
                log.trace("Setup new refresh token to the security context");
            }
            this.refreshToken = response.getRefreshToken();
        }
        this.tokenString = tokenString;
        if (this.tokenStore != null) {
            this.tokenStore.refreshCallback(this);
        }
        return true;
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }
}

