/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authentication;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authentication.ClientCredentialsProvider;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.util.BasicAuthHelper;
import java.util.Map;

public class ClientIdAndSecretCredentialsProvider
implements ClientCredentialsProvider {
    private static Logger logger = Logger.getLogger(ClientIdAndSecretCredentialsProvider.class);
    public static final String PROVIDER_ID = "secret";
    private String clientSecret;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void init(KeycloakDeployment deployment, Object config) {
        this.clientSecret = (String)config;
    }

    @Override
    public void setClientCredentials(KeycloakDeployment deployment, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String clientId = deployment.getResourceName();
        if (!deployment.isPublicClient()) {
            if (this.clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader(clientId, this.clientSecret);
                requestHeaders.put("Authorization", authorization);
            } else {
                logger.warnf("Client '%s' doesn't have secret available", (Object)clientId);
            }
        } else {
            formParams.put("client_id", clientId);
        }
    }
}

