/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authentication;

import de.acosix.alfresco.keycloak.repo.deps.jboss.logging.Logger;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.AdapterUtils;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.KeycloakDeployment;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.adapters.authentication.ClientCredentialsProvider;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.common.util.Time;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.jose.jws.JWSBuilder;
import de.acosix.alfresco.keycloak.repo.deps.keycloak.representations.JsonWebToken;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JWTClientSecretCredentialsProvider
implements ClientCredentialsProvider {
    private static final Logger logger = Logger.getLogger(JWTClientSecretCredentialsProvider.class);
    public static final String PROVIDER_ID = "secret-jwt";
    private SecretKey clientSecret;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void init(KeycloakDeployment deployment, Object config) {
        if (!(config instanceof Map)) {
            throw new RuntimeException("Configuration of jwt credentials by client secret is missing or incorrect for client '" + deployment.getResourceName() + "'. Check your adapter configuration");
        }
        Map cfg = (Map)config;
        String clientSecretString = (String)cfg.get("secret");
        if (clientSecretString == null) {
            throw new RuntimeException("Missing parameter secret-jwt in configuration of jwt for client " + deployment.getResourceName());
        }
        this.setClientSecret(clientSecretString);
    }

    @Override
    public void setClientCredentials(KeycloakDeployment deployment, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String signedToken = this.createSignedRequestToken(deployment.getResourceName(), deployment.getRealmInfoUrl());
        formParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        formParams.put("client_assertion", signedToken);
    }

    public void setClientSecret(String clientSecretString) {
        this.clientSecret = new SecretKeySpec(clientSecretString.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
    }

    public String createSignedRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken jwt = this.createRequestToken(clientId, realmInfoUrl);
        return new JWSBuilder().jsonContent(jwt).hmac256(this.clientSecret);
    }

    private JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken reqToken = new JsonWebToken();
        reqToken.id(AdapterUtils.generateId());
        reqToken.issuer(clientId);
        reqToken.subject(clientId);
        reqToken.audience(realmInfoUrl);
        int now = Time.currentTime();
        reqToken.issuedAt(now);
        reqToken.expiration(now + 10);
        reqToken.notBefore(now);
        return reqToken;
    }
}

